/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.CopyOnWriteFS;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.PendingToDeployMetadata;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectToDeploy;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.impl.DeployedProjectExt;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.mds.BPMLabels;
import oracle.bpm.metadata.mds.Namespace;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.InvalidNamespaceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetadataArtifactHelper {
    private static final JAXBContext JAXB_CONTEXT;
    private static final Map<Class<? extends MdProject>, Class<? extends MetadataType>> types;
    private static final Map<Class<? extends MdProject>, ProjectType> projectTypes;
    public static final String METADATA_FILENAME = "projectMetadata.xml";

    private MetadataArtifactHelper() {
    }

    public static <T extends MdProject> MetadataType deserialize(@NotNull Class<T> mdType, @NotNull InputStream input) throws IOException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.deserialize must not be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.deserialize must not be null");
        }
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            Class<? extends MetadataType> declaredType = types.get(mdType);
            JAXBElement o = unmarshaller.unmarshal((Source)new StreamSource(input), declaredType);
            return (MetadataType)o.getValue();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public static LockType deserializeLock(@NotNull InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.deserializeLock must not be null");
        }
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            JAXBElement o = unmarshaller.unmarshal((Source)new StreamSource(input), LockType.class);
            return (LockType)o.getValue();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public static void serialize(@NotNull Object raw, @NotNull VFile vFileOutput) throws IOException {
        if (raw == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.serialize must not be null");
        }
        if (vFileOutput == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.serialize must not be null");
        }
        VFileOutputStream out = null;
        try {
            out = new VFileOutputStream(vFileOutput);
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(raw, (OutputStream)out);
        }
        catch (JAXBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{out});
    }

    public static VFileSystem convertToVFileSystem(@NotNull MDSInstance instance, @NotNull Filesystem fs) throws IOException {
        MdsFileSystem vfilesystem;
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.convertToVFileSystem must not be null");
        }
        if (fs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.convertToVFileSystem must not be null");
        }
        if (fs.getSimpleFilesystem() != null) {
            vfilesystem = new MdsFileSystem(instance, fs.getSimpleFilesystem());
        } else {
            CowFilesystem cowFilesystem = fs.getCowFilesystem();
            VFileSystem read = MetadataArtifactHelper.convertToVFileSystem(instance, cowFilesystem.getRead());
            VFileSystem write = MetadataArtifactHelper.convertToVFileSystem(instance, cowFilesystem.getWrite());
            vfilesystem = new CopyOnWriteFS(read, write);
        }
        return vfilesystem;
    }

    public static String resolverRelativeFolder(@NotNull MetadataType metadata) throws InvalidNamespaceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.resolverRelativeFolder must not be null");
        }
        Filesystem filesystem = metadata.getTopology().getFilesystem();
        String folder = MetadataArtifactHelper.getFolderFrom(filesystem);
        String relativePath = MetadataArtifactHelper.getRelativePathFrom(metadata.getProjectType());
        return VFileUtils.getCannonicalPath((String)folder.substring(relativePath.length()));
    }

    public static String getRelativePathFrom(@NotNull ProjectType projectType) throws InvalidNamespaceException {
        String location;
        if (projectType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getRelativePathFrom must not be null");
        }
        if (ProjectType.DEPLOY == projectType) {
            location = Namespace.SOAINFRA.getMdsNamespace().getPath();
        } else {
            location = Namespace.BPM.getMdsNamespace().getPath();
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            switch (projectType) {
                case TEMPLATE: {
                    location = location + BPMLabels.TEMPLATES.getLabel();
                    break;
                }
                case PUBLIC_SHARED: {
                    location = location + BPMLabels.PUBLIC_SHARED.getLabel();
                    break;
                }
                case DRAFT: {
                    location = location + BPMLabels.DRAFT.getLabel();
                    break;
                }
                case PENDING_TO_DEPLOY: {
                    location = location + BPMLabels.PROJECT_TO_DEPLOY.getLabel();
                }
            }
        }
        return location;
    }

    public static PublicShareMetadata.WorkflowParticipants getWorkflowParticipants(@NotNull PublicShareMetadata publicShareMetadata) {
        if (publicShareMetadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getWorkflowParticipants must not be null");
        }
        PublicShareMetadata.WorkflowParticipants participants = publicShareMetadata.getWorkflowParticipants();
        if (participants == null) {
            participants = new PublicShareMetadata.WorkflowParticipants();
            publicShareMetadata.setWorkflowParticipants(participants);
        }
        return participants;
    }

    public static void setWorkflowParticipants(@NotNull PublicShareMetadata publicShareMetadata, @Nullable List<String> participantIds) {
        if (publicShareMetadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.setWorkflowParticipants must not be null");
        }
        PublicShareMetadata.WorkflowParticipants participants = MetadataArtifactHelper.getWorkflowParticipants(publicShareMetadata);
        List<String> ids = participants.getParticipantId();
        ids.clear();
        ids.addAll(participantIds);
    }

    public static ProjectType getProjectType(@NotNull Class project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getProjectType must not be null");
        }
        return projectTypes.get(project);
    }

    public static void copyPublicShare(@NotNull PublicShareProject targetPublicShare, @NotNull PublicShareProject sourcePublicShare) {
        if (targetPublicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.copyPublicShare must not be null");
        }
        if (sourcePublicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.copyPublicShare must not be null");
        }
        MetadataArtifactHelper.copyMetadataAttributes(targetPublicShare.getMetadata(), sourcePublicShare.getMetadata());
        targetPublicShare.setAllowSharing(sourcePublicShare.isAllowSharing());
        targetPublicShare.setProjectFromScratch(sourcePublicShare.isProjectFromScratch());
        if (sourcePublicShare.isApprovalWorkflow()) {
            targetPublicShare.setWorkflowParticipants(sourcePublicShare.getWorkflowParticipants());
            targetPublicShare.setApprovalWorkflowUrl(sourcePublicShare.getApprovalWorkflowUrl());
        }
    }

    public static void copyMetadataAttributes(@NotNull MetadataType targetMetadata, @NotNull MetadataType sourceMetadata) {
        if (targetMetadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.copyMetadataAttributes must not be null");
        }
        if (sourceMetadata == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.copyMetadataAttributes must not be null");
        }
        targetMetadata.setName(sourceMetadata.getName());
        targetMetadata.setDescription(sourceMetadata.getDescription());
        targetMetadata.setProjectType(sourceMetadata.getProjectType());
        targetMetadata.setCreator(sourceMetadata.getCreator());
        targetMetadata.setProperties(null);
        MetadataType.Properties sourceProperties = sourceMetadata.getProperties();
        if (sourceProperties != null) {
            MetadataType.Properties properties = new MetadataType.Properties();
            targetMetadata.setProperties(properties);
            properties.getProperty().addAll(sourceProperties.getProperty());
        }
    }

    public static <T extends MdProject> MetadataType getMetadataArtifact(@NotNull VFileSystem filesystem, @NotNull Class<T> mdType, @NotNull String location) throws PersistenceException {
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getMetadataArtifact must not be null");
        }
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getMetadataArtifact must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getMetadataArtifact must not be null");
        }
        VFileInputStream input = null;
        MetadataType result = null;
        try {
            VFile file;
            String filePath = location;
            if (!filePath.endsWith("/")) {
                filePath = filePath + "/";
            }
            if ((file = filesystem.createFile(filePath + METADATA_FILENAME)).exists()) {
                input = new VFileInputStream(file);
                result = MetadataArtifactHelper.deserialize(mdType, (InputStream)input);
            }
        }
        catch (IOException e) {
            try {
                throw PersistenceException.createIOException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{input});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{input});
        return result;
    }

    private static String getFolderFrom(@NotNull Filesystem filesystem) {
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactHelper.getFolderFrom must not be null");
        }
        String folder = filesystem.getSimpleFilesystem();
        if (folder == null) {
            CowFilesystem cowFilesystem = filesystem.getCowFilesystem();
            Filesystem write = cowFilesystem.getWrite();
            folder = MetadataArtifactHelper.getFolderFrom(write);
        }
        return folder;
    }

    static {
        types = new HashMap<Class<? extends MdProject>, Class<? extends MetadataType>>();
        projectTypes = new HashMap<Class<? extends MdProject>, ProjectType>();
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{LockType.class, MetadataType.class});
            types.put(PublicShareProject.class, PublicShareMetadata.class);
            types.put(ProjectToDeploy.class, PendingToDeployMetadata.class);
            types.put(DraftProject.class, MetadataType.class);
            types.put(TemplateProject.class, MetadataType.class);
            types.put(DeployedProject.class, MetadataType.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        projectTypes.put(TemplateProject.class, ProjectType.TEMPLATE);
        projectTypes.put(PublicShareProject.class, ProjectType.PUBLIC_SHARED);
        projectTypes.put(DraftProject.class, ProjectType.DRAFT);
        projectTypes.put(DeployedProject.class, ProjectType.DEPLOY);
        projectTypes.put(DeployedProjectExt.class, ProjectType.DEPLOY);
        projectTypes.put(ProjectToDeploy.class, ProjectType.PENDING_TO_DEPLOY);
        projectTypes.put(DeployedProjectExt.class, ProjectType.DEPLOY);
    }
}

