/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import java.util.Calendar;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MdProjectImpl<T extends ProjectArtifact>
implements MdProject<T> {
    protected MetadataType metadata;
    protected LocalRef<Project> projectRef;
    private MdPersistence persistence;
    private LocalRef<ProjectFolder> projectFolderRef;

    protected MdProjectImpl(@NotNull MdPersistence mdPersistence, @NotNull String location) {
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        this(mdPersistence, null, location);
    }

    protected MdProjectImpl(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        this.metadata = new MetadataType();
        this.setName(name);
        this.setProject(project);
    }

    protected MdProjectImpl(@NotNull MdPersistence mdPersistence, @Nullable MetadataType metadataType, @NotNull String location) {
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        this.metadata = metadataType != null ? metadataType : new MetadataType();
        this.persistence = mdPersistence;
        ProjectFolder projectFolder = ProjectFolder.create(location);
        this.projectFolderRef = new LocalRef<ProjectFolder>(location, projectFolder);
    }

    @Override
    public boolean isMdProject() {
        return true;
    }

    @Override
    public LocalRef<Project> getProject() throws MetadataException {
        if (this.projectRef == null && this.persistence != null) {
            this.projectRef = this.persistence.loadProject(this.getMetadata());
        }
        return this.projectRef;
    }

    @Override
    public String getId() {
        return this.getFolder().get().getLocation();
    }

    @Override
    public String getName() {
        return this.getMetadata().getName();
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setName must not be null");
        }
        this.getMetadata().setName(name);
    }

    @Override
    public Calendar getUpdateTimestamp() {
        XMLGregorianCalendar timestamp = this.getMetadata().getUpdateTimestamp();
        return timestamp != null ? timestamp.toGregorianCalendar() : null;
    }

    @Override
    public void setUpdateTimestamp(XMLGregorianCalendar timestamp) {
        this.getMetadata().setUpdateTimestamp(timestamp);
    }

    @Override
    public LocalRef<ProjectFolder> getParentFolder() {
        return this.getFolder().get().getParentFolder();
    }

    @Override
    public LocalRef<ProjectFolder> getFolder() {
        return this.projectFolderRef;
    }

    @Override
    public void setFolder(@NotNull ProjectFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setFolder must not be null");
        }
        this.projectFolderRef = new LocalRef<ProjectFolder>(folder.getLocation(), folder);
    }

    public void setProject(@NotNull LocalRef<Project> projectRef) {
        if (projectRef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProject must not be null");
        }
        this.projectRef = projectRef;
    }

    public String getOwner() {
        return this.getMetadata().getCreator();
    }

    public void setOwner(@NotNull String owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setOwner must not be null");
        }
        this.getMetadata().setCreator(owner);
    }

    public Calendar getCreationTimestamp() {
        XMLGregorianCalendar timestamp = this.getMetadata().getTimestamp();
        return timestamp != null ? timestamp.toGregorianCalendar() : null;
    }

    @Override
    public void setProperty(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProperty must not be null");
        }
        MetadataType.Properties.Property property = this.findProperty(key);
        if (property == null) {
            MetadataType.Properties properties = this.metadata.getProperties();
            if (properties == null) {
                properties = new MetadataType.Properties();
                this.metadata.setProperties(properties);
            }
            property = new MetadataType.Properties.Property();
            properties.getProperty().add(property);
            property.setKey(key);
        }
        property.setValue(value);
    }

    @Override
    public String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.getProperty must not be null");
        }
        String result = null;
        MetadataType.Properties.Property property = this.findProperty(key);
        if (property != null) {
            result = property.getValue();
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null || this.getClass() != object.getClass()) {
            result = false;
        } else if (object == this) {
            result = true;
        } else {
            MdProject mdProject = (MdProject)object;
            result = this.getClass().equals(object.getClass()) && this.getId().equals(mdProject.getId());
        }
        return result;
    }

    protected MetadataType getMetadata() {
        return this.metadata;
    }

    protected void setMdPersistence(@NotNull MdPersistence mdPersistence) {
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setMdPersistence must not be null");
        }
        this.persistence = mdPersistence;
    }

    private void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProject must not be null");
        }
        this.projectRef = new LocalRef<Project>(this.getName(), project);
    }

    private MetadataType.Properties.Property findProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.findProperty must not be null");
        }
        MetadataType.Properties.Property result = null;
        MetadataType.Properties metadataProperties = this.metadata.getProperties();
        if (metadataProperties != null) {
            List<MetadataType.Properties.Property> properties = metadataProperties.getProperty();
            for (MetadataType.Properties.Property property : properties) {
                if (!key.equals(property.getKey())) continue;
                result = property;
                break;
            }
        }
        return result;
    }
}

