/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.entity;

import java.util.Collection;
import java.util.LinkedList;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.ProjectArtifact;
import org.jetbrains.annotations.NotNull;

public final class ProjectFolder
implements ProjectArtifact<ProjectFolder> {
    private String location;
    private String name;
    private transient LocalRef<ProjectFolder> parentFolder;

    private ProjectFolder(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/ProjectFolder.<init> must not be null");
        }
        if (!location.equals("/") && location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        this.location = location;
    }

    public static ProjectFolder create(@NotNull String locationPath) {
        if (locationPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/ProjectFolder.create must not be null");
        }
        return new ProjectFolder(locationPath);
    }

    public static ProjectFolder create(@NotNull ProjectFolder parent, @NotNull String locationPath) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/ProjectFolder.create must not be null");
        }
        if (locationPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/entity/ProjectFolder.create must not be null");
        }
        return new ProjectFolder(parent.getLocation() + "/" + locationPath);
    }

    @Override
    public boolean isMdProject() {
        return false;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        if (this.name == null) {
            LinkedList path = VFileUtils.canonicalDecomposition((String)this.location);
            this.name = (String)path.getLast();
            if (this.name.endsWith("/")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        }
        return this.name;
    }

    @Override
    public LocalRef<ProjectFolder> getParentFolder() {
        if (this.parentFolder == null) {
            LinkedList path = VFileUtils.canonicalDecomposition((String)this.location);
            if (path.size() > 1) {
                path.removeLast();
                ProjectFolder projectFolder = ProjectFolder.create(VFileUtils.makePathName((Collection)path));
                this.parentFolder = new LocalRef<ProjectFolder>(projectFolder.getName(), projectFolder);
            } else {
                this.parentFolder = null;
            }
        }
        return this.parentFolder;
    }

    @Override
    public LocalRef<ProjectFolder> getLocalRef() {
        return new LocalRef<ProjectFolder>(this.getName(), this);
    }

    public int hashCode() {
        return this.location != null ? VFileUtils.makePathName((Collection)VFileUtils.canonicalDecomposition((String)this.location)).hashCode() : 0;
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null || this.getClass() != object.getClass()) {
            result = false;
        } else if (object == this) {
            result = true;
        } else {
            LinkedList pathItems = VFileUtils.canonicalDecomposition((String)((ProjectFolder)object).location);
            this.checkLastPathItem(pathItems);
            String projectFolderPath = VFileUtils.makePathName((Collection)pathItems);
            pathItems = VFileUtils.canonicalDecomposition((String)this.location);
            this.checkLastPathItem(pathItems);
            result = VFileUtils.makePathName((Collection)pathItems).equals(projectFolderPath);
        }
        return result;
    }

    private void checkLastPathItem(@NotNull LinkedList<String> parts) {
        if (parts == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/ProjectFolder.checkLastPathItem must not be null");
        }
        if (!parts.isEmpty()) {
            String lastPart = parts.getLast();
            if (lastPart.length() > 1 && lastPart.endsWith("/")) {
                parts.removeLast();
                parts.add(lastPart.substring(0, lastPart.length() - 1));
            }
            if (parts.size() > 1 && "/".equals(parts.getLast())) {
                parts.removeLast();
            }
        }
    }
}

