/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import oracle.bpm.extensionpoint.metadata.ProjectRepositoryMetadata;
import oracle.bpm.io.fs.MdsProjectLoader;
import oracle.bpm.io.fs.MdsProjectWriter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.bpm.metadata.mds.utils.MdsTransactionUtil;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.ProjectFileSystemImpl;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;

@ProjectRepositoryMetadata(type="mds")
public class MdsProjectRepository
extends AbstractProjectRepository {
    private MDSInstance instance;
    private String rootPath;

    public MdsProjectRepository(@NotNull MDSInstance instance, @NotNull String rootPath) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.<init> must not be null");
        }
        if (rootPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.<init> must not be null");
        }
        this.instance = instance;
        this.rootPath = rootPath;
    }

    public Project create(@NotNull String projectName) throws ProjectException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.create must not be null");
        }
        try {
            return super.create(new URI(this.rootPath), projectName);
        }
        catch (URISyntaxException e) {
            throw new ProjectException(null, null, (Throwable)e);
        }
    }

    @Override
    public Project create(@NotNull URI baseLocation, @NotNull String projectName) throws ProjectException {
        if (baseLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.create must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.create must not be null");
        }
        String path = baseLocation.toString() + "/" + projectName;
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.instance);
        try {
            if (!tx.existsPackage(path)) {
                tx.createPackage(path);
            }
        }
        catch (MetadataException e) {
            throw new ProjectException(null, ProjectIoMsg.CANNOT_CREATE_FOLDER(path), (Throwable)((Object)e));
        }
        return super.create(baseLocation, projectName);
    }

    public void flushChanges(@NotNull String projectName) throws ProjectException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.flushChanges must not be null");
        }
        Project project = this.getProject(projectName);
        assert (project != null);
        MdsProjectWriter writer = (MdsProjectWriter)project.getWriter();
        writer.flushChanges();
        ProjectFileSystem fileSystem = writer.getProjectFileSystem();
        try {
            fileSystem.getDataFileSystem().flush();
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)project, (Throwable)e);
        }
    }

    public File getDefaultBaseDir() {
        return FileSystemTokens.getDefaultProjectsDir();
    }

    @Override
    public void delete(@NotNull Project project) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.delete must not be null");
        }
        String name = project.getName();
        this.close(project);
        this.projectsMap.remove(name);
        this.fireProjectDeleted(project);
    }

    public Project create(@NotNull MetadataType metadata) throws ProjectException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.create must not be null");
        }
        try {
            Filesystem filesystem = metadata.getTopology().getFilesystem();
            VFileSystem fs = MetadataArtifactHelper.convertToVFileSystem(this.instance, filesystem);
            String projectName = metadata.getName();
            if (this.existsProject(projectName)) {
                throw new ProjectException(null, ProjectMsg.PROJECT_DIR_ALREADY_EXISTS);
            }
            FuegoProject project = FuegoProject.create((String)projectName);
            project.setRepository((ProjectRepository)this);
            ProjectFileSystem fileSystem = this.createFileSystem((Project)project, fs);
            this.initProject((Project)project, fileSystem);
            return project;
        }
        catch (IOException e) {
            throw new ProjectException(null, null, (Throwable)e);
        }
    }

    @Override
    protected ProjectFileSystem createFileSystem(@NotNull Project project, @NotNull URI baseLocation) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createFileSystem must not be null");
        }
        if (baseLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createFileSystem must not be null");
        }
        String mountPoint = baseLocation.toString() + "/" + project.getName();
        MdsFileSystem fileSystem = new MdsFileSystem(this.instance, mountPoint);
        File localRootFolder = new File(FileSystemTokens.getTempProjectsDir(), project.getName());
        ProjectFileSystem result = ProjectFileSystemImpl.create(fileSystem, localRootFolder);
        ProjectObjectImpl.setAdapter((ProjectObject)project, (Object)fileSystem.getRoot());
        return result;
    }

    @Override
    protected ProjectLoader createLoader(@NotNull Project project, @NotNull ProjectFileSystem fileSystem) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createLoader must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createLoader must not be null");
        }
        return new MdsProjectLoader(this, project, fileSystem);
    }

    @Override
    protected ProjectWriter createWriter(@NotNull Project project, @NotNull ProjectFileSystem fileSystem) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createWriter must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createWriter must not be null");
        }
        return new MdsProjectWriter(this, project, fileSystem);
    }

    private ProjectFileSystem createFileSystem(@NotNull Project project, @NotNull VFileSystem fileSystem) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createFileSystem must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectRepository.createFileSystem must not be null");
        }
        File localRootFolder = new File(FileSystemTokens.getTempProjectsDir(), project.getName());
        ProjectFileSystem result = ProjectFileSystemImpl.create(fileSystem, localRootFolder);
        ProjectObjectImpl.setAdapter((ProjectObject)project, (Object)fileSystem.getRoot());
        return result;
    }
}

