/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpa.util.logging;

import java.io.StringWriter;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.log.BpaDiagnosticService;
import org.w3c.dom.Node;

public class XMLLogUtil {
    private static Transformer transformer;

    public static void logXMLSnippet(Node snippet, String prelude, int component, String className, String methodName, BpaContext context) {
        DOMSource domSource = new DOMSource(snippet);
        StreamResult stringResult = new StreamResult(new StringWriter());
        try {
            transformer.transform(domSource, stringResult);
            String xmlResult = stringResult.getWriter().toString();
            BpaDiagnosticService.log((int)component, (Level)BpaDiagnosticService.DEBUG, (String)className, (String)methodName, (String)(prelude + "\n" + xmlResult));
        }
        catch (TransformerException e) {
            new BpaException("XMLLogUtil", "logXMLSnippet()", 24002, context);
        }
    }

    static {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
        }
        catch (TransformerConfigurationException e) {
            new BpaException("XMLLogUtil", "init()", 24001, new BpaContext(Locale.ENGLISH));
        }
    }
}

