/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpa.export.bpmn.impl;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.bpa.bpmn.util.BoundaryFinder;
import oracle.bpa.bpmn.util.Graph;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.log.BpaDiagnosticService;
import oracle.bpa.common.soa.ConstantsUtil;
import oracle.bpa.export.bpmn.iface.IBpelElement;
import oracle.bpa.export.bpmn.iface.IBpelProcessExport;
import oracle.bpa.export.bpmn.iface.IBpelProcessExportAction;
import oracle.bpa.export.bpmn.impl.BpelElementImpl;
import oracle.bpa.export.bpmn.impl.BpelExportActionImpl;
import oracle.bpa.export.bpmn.impl.BpelProcessExportActionImpl;
import oracle.bpa.export.bpmn.impl.BpmnAttribute;
import oracle.bpa.export.bpmn.impl.BpmnConnection;
import oracle.bpa.export.bpmn.impl.BpmnObject;
import oracle.bpa.export.bpmn.impl.BpmnProcess;
import oracle.bpa.export.exportimpl.BpelExportExtnImpl;
import oracle.bpa.export.exportimpl.data.AdditionalDocumentImpl;
import oracle.bpa.export.exportimpl.data.SCAExportState;
import oracle.bpa.export.pluginwrapper.BpaAdditionalDocument;
import oracle.bpa.export.pluginwrapper.BpaBpelConnection;
import oracle.bpa.export.pluginwrapper.BpaBpelObject;
import oracle.bpa.export.pluginwrapper.BpaBpelProcess;
import oracle.bpa.export.pluginwrapper.BpaBpelProcessExportAction;
import oracle.bpa.export.pluginwrapper.BpaNamespace;
import oracle.bpa.export.pluginwrapper.BpelElementExtn;
import oracle.bpa.export.pluginwrapper.BpelExportExtn;
import oracle.bpa.export.util.GenericBpelExportUtil;
import oracle.bpa.util.logging.XMLLogUtil;
import oracle.bpa.util.xmlwrapper.OracleExtensionElement;
import oracle.bpa.util.xmlwrapper.XMLWrapper;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.tip.tools.ide.common.bpeldesigner.util.TemplateUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BpelProcessExportImpl
implements IBpelProcessExport {
    BpaContext bpaContext;
    Document bpelDocument;
    BpelExportActionImpl bpelExportAction;
    BpelExportExtn bpelExportExtn;
    BpelProcessExportActionImpl bpelProcessExportAction;
    GenericBpelExportUtil genericBpelExport;
    Process process;
    BoundaryFinder processBoundaryFinder;
    Graph processGraph;
    String processId;
    String processType;
    Map subprocessIdIndexMapping = new HashMap();
    int subprocessIndex = 1;
    private static HashMap oracleExtnMappings = new HashMap();
    private static HashMap processAttributeTypes = new HashMap();

    public BpelProcessExportImpl(Process process, Document document, XMLWrapper xmlWrapperRef, BpelExportActionImpl bpelExportActionRef, SCAExportState exportState, BpaContext bpaContext) {
        this.process = process;
        this.bpelDocument = document;
        this.processGraph = new Graph();
        this.processBoundaryFinder = new BoundaryFinder(bpaContext);
        this.bpelProcessExportAction = new BpelProcessExportActionImpl();
        this.bpelExportAction = bpelExportActionRef;
        this.bpaContext = bpaContext;
        XMLWrapper xmlWrapper = xmlWrapperRef;
        oracleExtnMappings = xmlWrapper.getSymbolMappings();
        processAttributeTypes = xmlWrapper.getProcessAttributeMappings();
        HashMap sensorMap = xmlWrapper.getSensorMappings();
        this.processType = new BpmnProcess(process).getAttribute("ProcessType").getValue(bpaContext.getLocale());
        this.bpelExportExtn = new BpelExportExtnImpl(oracleExtnMappings, processAttributeTypes, sensorMap, exportState, this.processType, bpaContext);
    }

    @Override
    public IBpelElement processExporting() throws Exception {
        this.processId = new BpmnProcess(this.process).getName();
        this.processGraph.parse((NodeContainer)this.process);
        this.processBoundaryFinder.parse((NodeContainer)this.process);
        this.genericBpelExport = new GenericBpelExportUtil(this.processId, this.processType, this.bpelDocument, this.bpaContext);
        IBpelElement bpelElement = new BpelElementImpl();
        BpelElementExtn bpelElementExtn = this.bpelExportExtn.processExporting((BpaBpelProcess)new BpmnProcess(this.process), this.bpelDocument, true);
        if (bpelElementExtn.getAdditionalNamespaces() != null) {
            ListIterator l = bpelElementExtn.getAdditionalNamespaces().listIterator();
            while (l.hasNext()) {
                BpaNamespace namespace = (BpaNamespace)l.next();
                this.bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)namespace.getPrefix()), namespace.getPath());
            }
        }
        this.bpelProcessExportAction.addToNamespaces("targetNamespace", URI.create(ConstantsUtil.prependXMLNS((String)("bpmn/bpmnProcess/" + this.processId))));
        this.bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)"client"), URI.create(ConstantsUtil.prependXMLNS((String)("bpmn/bpmnProcess/" + this.processId))));
        this.bpelProcessExportAction.addToNamespaces("xmlns", URI.create("http://schemas.xmlsoap.org/ws/2003/03/business-process/"));
        this.genericBpelExport.addDefPlAndVars(this.processId, this.processType, (BpaBpelProcessExportAction)this.bpelProcessExportAction);
        bpelElement = this.constructBpelElement(null, bpelElementExtn);
        return bpelElement;
    }

    @Override
    public IBpelElement elementExporting(FlowNode element, String elementType) throws BpaException {
        ListIterator l;
        Activity act;
        IBpelElement bpelElement = new BpelElementImpl();
        Element stdBpel = null;
        BpelElementExtn bpelElementExtn = null;
        boolean noScopeRequired = false;
        BpmnObject bpmnObject = new BpmnObject(element, this.processGraph, this.processBoundaryFinder);
        BpaDiagnosticService.log((int)4, (Level)BpaDiagnosticService.DEBUG, (String)"BpelProcessExportExtnImpl", (String)"elementExporting()", (String)("Element Exporting :" + element.getName()));
        if (element.isActivity() && (act = (Activity)element.asAnyNode(Activity.class)).isSubprocess() && elementType.equals("Invoke")) {
            String subpId = act.toSubprocess().getId();
            String subpName = act.toSubprocess().getDefaultLabel();
            String subpInvokeName = act.getDefaultLabel();
            if (!this.subprocessIdIndexMapping.containsKey(subpId)) {
                stdBpel = this.genericBpelExport.generateSubprocessInvoke(subpInvokeName, subpName, this.subprocessIndex);
                this.genericBpelExport.generateSubprocessNsAndPl(subpName, this.subprocessIndex, (BpaBpelProcessExportAction)this.bpelProcessExportAction);
                this.subprocessIdIndexMapping.put(subpId, this.subprocessIndex);
                ++this.subprocessIndex;
            } else {
                int tempSubpIndex = (Integer)this.subprocessIdIndexMapping.get(subpId);
                stdBpel = this.genericBpelExport.generateSubprocessInvoke(subpInvokeName, subpName, tempSubpIndex);
            }
            bpmnObject.setType("Invoke");
            bpmnObject.setAutomated();
            bpmnObject.setSubprocess();
            bpelElementExtn = this.bpelExportExtn.elementExporting((BpaBpelObject)bpmnObject, this.bpelDocument);
        }
        if (!elementType.equals("Sequence")) {
            BpmnAttribute nodeType = (BpmnAttribute)bpmnObject.getAttribute("NodeType");
            if (nodeType != null && nodeType.getValue(null).equals("Activity")) {
                HashMap emptyAttributes;
                BpmnAttribute taskType = (BpmnAttribute)bpmnObject.getAttribute("TaskType");
                if (taskType != null && taskType.getValue(null).equals("User")) {
                    if (elementType != null && !elementType.equals("Empty")) {
                        bpmnObject.setType("HumanTask");
                    } else {
                        bpmnObject.setType("Empty");
                        bpmnObject.setAutomated();
                        emptyAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Empty")).getAttributeMappings();
                        stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, emptyAttributes, "Empty");
                    }
                } else if (taskType != null && taskType.getValue(null).equals("Rule")) {
                    if (elementType != null && !elementType.equals("Empty")) {
                        bpmnObject.setType("DecisionService");
                    } else {
                        bpmnObject.setType("Empty");
                        bpmnObject.setAutomated();
                        emptyAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Empty")).getAttributeMappings();
                        stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, emptyAttributes, "Empty");
                    }
                } else if (taskType != null && taskType.getValue(null).equals("Notification")) {
                    if (elementType != null && !elementType.equals("Empty")) {
                        bpmnObject.setType("Notification");
                    } else {
                        bpmnObject.setType("Empty");
                        bpmnObject.setAutomated();
                        emptyAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Empty")).getAttributeMappings();
                        stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, emptyAttributes, "Empty");
                    }
                } else if (elementType != null && elementType.equals("Receive")) {
                    bpmnObject.setType("Receive");
                    bpmnObject.setAutomated();
                    HashMap receiveAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Receive")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, receiveAttributes, "Receive");
                } else if (elementType != null && elementType.equals("Invoke")) {
                    bpmnObject.setType("Invoke");
                    bpmnObject.setAutomated();
                    HashMap invokeAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Invoke")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, invokeAttributes, "Invoke");
                } else if (elementType != null && elementType.equals("Empty")) {
                    bpmnObject.setType("Empty");
                    bpmnObject.setAutomated();
                    emptyAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Empty")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, emptyAttributes, "Empty");
                } else if (elementType != null && elementType.equals("script")) {
                    bpmnObject.setType("script");
                    bpmnObject.setEventScope();
                    HashMap replyAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Reply")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, replyAttributes, "script");
                } else {
                    if (elementType.equals("Scope")) {
                        bpmnObject.setSubprocessScope();
                    } else if (elementType.equals("AbstractActivity")) {
                        bpmnObject.setAutomated();
                    }
                    bpmnObject.setType(elementType);
                    noScopeRequired = true;
                }
            } else if (nodeType != null && nodeType.getValue(null).equals("Event")) {
                HashMap receiveAttributes;
                if (this.processGraph.isStart(element)) {
                    bpmnObject.setStartActivity();
                } else if (this.processGraph.isEnd(element)) {
                    bpmnObject.setEndActivity();
                }
                if (elementType != null && elementType.equals("Receive")) {
                    bpmnObject.setType("Receive");
                    bpmnObject.setEventScope();
                    receiveAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Receive")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, receiveAttributes, "Receive");
                } else if (elementType != null && elementType.equals("Invoke")) {
                    bpmnObject.setType("Invoke");
                    bpmnObject.setEventScope();
                    receiveAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Invoke")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, receiveAttributes, "Invoke");
                } else if (elementType != null && elementType.equals("Reply")) {
                    bpmnObject.setType("Reply");
                    bpmnObject.setEventScope();
                    HashMap replyAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Reply")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, replyAttributes, "Reply");
                } else {
                    bpmnObject.setType(elementType);
                    if (!elementType.equals("Throw")) {
                        noScopeRequired = true;
                    }
                }
            } else if (nodeType != null && nodeType.getValue(null).equals("Gateway")) {
                if (elementType != null && elementType.equals("While")) {
                    bpmnObject.setType("While");
                    HashMap whileAttributes = ((OracleExtensionElement)oracleExtnMappings.get("While")).getAttributeMappings();
                    stdBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, whileAttributes, "While");
                    noScopeRequired = true;
                } else {
                    bpmnObject.setType(elementType);
                    noScopeRequired = true;
                }
            } else if (nodeType != null && elementType != null) {
                bpmnObject.setType(elementType);
                noScopeRequired = true;
            }
            bpelElementExtn = this.bpelExportExtn.elementExporting((BpaBpelObject)bpmnObject, this.bpelDocument);
        } else {
            noScopeRequired = true;
            bpelElementExtn = this.bpelExportExtn.elementExporting(null, this.bpelDocument, (BpaBpelObject)bpmnObject);
        }
        if (bpelElementExtn.getAdditionalPartnerLinks() != null) {
            l = bpelElementExtn.getAdditionalPartnerLinks().listIterator();
            while (l.hasNext()) {
                Element partnerLink = (Element)l.next();
                this.bpelProcessExportAction.addToPartnerLinks(partnerLink);
            }
        }
        if (bpelElementExtn.getAdditionalVariables() != null) {
            l = bpelElementExtn.getAdditionalVariables().listIterator();
            while (l.hasNext()) {
                Element variable = (Element)l.next();
                this.bpelProcessExportAction.addToVariables(variable);
            }
        }
        if (bpelElementExtn.getAdditionalNamespaces() != null) {
            l = bpelElementExtn.getAdditionalNamespaces().listIterator();
            while (l.hasNext()) {
                BpaNamespace namespace = (BpaNamespace)l.next();
                this.bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)namespace.getPrefix()), namespace.getPath());
            }
        }
        bpelElement = this.constructBpelElement(stdBpel, bpelElementExtn);
        String taskVal = "";
        BpmnAttribute isExtType = (BpmnAttribute)bpmnObject.getAttribute("TaskType");
        if (isExtType != null) {
            taskVal = isExtType.getValue(null);
        }
        if (!(noScopeRequired || taskVal.equals("User") || taskVal.equals("Notification") || taskVal.equals("Rule"))) {
            IBpelElement finalBpelElement = null;
            bpmnObject.setType("Scope");
            HashMap scopeAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Scope")).getAttributeMappings();
            Element scopeBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, scopeAttributes, "Scope");
            HashMap seqAttributes = ((OracleExtensionElement)oracleExtnMappings.get("Sequence")).getAttributeMappings();
            Element sequenceBpel = this.genericBpelExport.getSnippet((BpaBpelObject)bpmnObject, seqAttributes, "Sequence");
            sequenceBpel.appendChild(bpelElement.getXMLNotation());
            scopeBpel.appendChild(sequenceBpel);
            bpelElementExtn = this.bpelExportExtn.elementExporting((BpaBpelObject)bpmnObject, this.bpelDocument);
            finalBpelElement = this.constructBpelElement(scopeBpel, bpelElementExtn);
            return finalBpelElement;
        }
        return bpelElement;
    }

    @Override
    public IBpelElement elementExporting(SequenceFlow conn, String type) throws BpaException {
        IBpelElement bpelElement = new BpelElementImpl();
        BpelElementExtn bpelElementExtn = null;
        Element stdBpel = null;
        BpmnConnection connection = new BpmnConnection(conn, this.processGraph, this.processBoundaryFinder);
        HashMap connAttr = ((OracleExtensionElement)oracleExtnMappings.get("Case")).getAttributeMappings();
        if (type != null && !type.equals("Sequence")) {
            BpaDiagnosticService.log((int)4, (Level)BpaDiagnosticService.DEBUG, (String)"BpelProcessExportImpl", (String)"elementExporting(Connection)", (String)("Exporting case connection" + connection.getConnectionIdentifier()));
            BpmnObject source = (BpmnObject)connection.getSourceObject();
            HashMap switchAttr = ((OracleExtensionElement)oracleExtnMappings.get("Switch")).getAttributeMappings();
            HashMap humanTaskAttr = ((OracleExtensionElement)oracleExtnMappings.get("HumanTask")).getAttributeMappings();
            String caseId = connection.getAttribute((String)connAttr.get("BusinessId")).getValue(null);
            String switchId = source.getAttribute((String)switchAttr.get("BusinessId")).getValue(null);
            if (caseId == null || caseId.equals("default")) {
                connection.setConnectionIdentifier(switchId + "_" + "Case" + "_" + caseId);
            } else {
                connection.setConnectionIdentifier("Case_" + caseId);
            }
            String condnExpr = null;
            String HtLabel = null;
            String HtSequence = null;
            BpmnAttribute exprAttribute = (BpmnAttribute)connection.getAttribute((String)connAttr.get("ConditionExpression"));
            if (exprAttribute != null) {
                condnExpr = exprAttribute.getValue(null);
            }
            List incomingConnections = source.getAllIncomingConnections();
            ListIterator l = incomingConnections.listIterator();
            while (l.hasNext()) {
                String objType;
                BpmnObject obj = (BpmnObject)((BpmnConnection)l.next()).getSourceObject();
                if (obj == null || (objType = obj.getType()) == null || !objType.equals("HumanTask")) continue;
                if (condnExpr != null) {
                    connection.setOutcomeAssociated();
                }
                HtLabel = obj.getAttribute((String)humanTaskAttr.get("Label")).getValue(null);
                if (obj.getAttribute((String)humanTaskAttr.get("HumanTaskSequence")) == null) break;
                HtSequence = obj.getAttribute((String)humanTaskAttr.get("HumanTaskSequence")).getValue(null);
                break;
            }
            if (caseId != null && !caseId.equals("default") && condnExpr != null) {
                if (HtLabel != null && HtSequence != null) {
                    connection.setConditionExpr("bpws:getVariableData('" + HtLabel + "_" + HtSequence + "_globalVariable" + "','payload','/task:task/task:systemAttributes/task:outcome')='" + condnExpr + "'");
                } else {
                    connection.setConditionExpr(condnExpr);
                }
            }
            stdBpel = type.equals("Case") ? this.genericBpelExport.generateCase((BpaBpelConnection)connection, connAttr) : this.genericBpelExport.generateOtherwise((BpaBpelConnection)connection, connAttr);
            bpelElementExtn = this.bpelExportExtn.elementExporting((BpaBpelConnection)connection, this.bpelDocument, null);
        } else {
            BpmnObject srcObj = (BpmnObject)connection.getSourceObject();
            HashMap scopeAttr = ((OracleExtensionElement)oracleExtnMappings.get("Scope")).getAttributeMappings();
            String id = null;
            if (connection.getAttribute((String)connAttr.get("BusinessId")) != null) {
                id = connection.getAttribute((String)connAttr.get("BusinessId")).getValue(null);
            }
            connection.setConnectionIdentifier(id);
            if (srcObj.getAttribute((String)scopeAttr.get("LastUpdateDate")) != null) {
                connection.setUpdateDate(srcObj.getAttribute((String)scopeAttr.get("LastUpdateDate")).getValue(null));
            }
            bpelElementExtn = this.bpelExportExtn.elementExporting((BpaBpelConnection)connection, this.bpelDocument, (BpaBpelObject)srcObj);
        }
        bpelElement = this.constructBpelElement(stdBpel, bpelElementExtn);
        return bpelElement;
    }

    @Override
    public IBpelProcessExportAction processExported() throws BpaException {
        String wsdlTemplate;
        List additionalDocuments = this.bpelExportExtn.processExported(this.bpelDocument, Collections.EMPTY_LIST);
        AdditionalDocumentImpl bpelProcessWSDL = new AdditionalDocumentImpl();
        if (this.processType.equals("Asynchronous")) {
            new TemplateUtil();
            wsdlTemplate = TemplateUtil.getAsyncWSDLTemplate((String)this.processId, (String)("http://xmlns.oracle.com/" + this.processId), (String)"xsd/");
        } else {
            new TemplateUtil();
            wsdlTemplate = TemplateUtil.getSyncWSDLTemplate((String)this.processId, (String)("http://xmlns.oracle.com/" + this.processId), (String)"xsd/");
        }
        DOMParser dom = new DOMParser();
        try {
            dom.parse((Reader)new StringReader(wsdlTemplate));
        }
        catch (SAXException e) {
            throw new BpaException("BpelProcessExportImpl", "processExported()", 20026, (Throwable)e, this.bpaContext);
        }
        catch (Throwable t) {
            throw new BpaException("BpelProcessExportImpl", "processExported()", 20027, t, this.bpaContext);
        }
        XMLDocument bpelProcessWSDLFile = dom.getDocument();
        bpelProcessWSDL.setAdditionalDocument((Document)bpelProcessWSDLFile);
        String bpelProcessWSDLFileName = ConstantsUtil.appendSuffix((String)this.processId, (String)".wsdl");
        bpelProcessWSDL.setDocumentName(bpelProcessWSDLFileName);
        additionalDocuments.add(bpelProcessWSDL);
        ListIterator l = additionalDocuments.listIterator();
        while (l.hasNext()) {
            BpaAdditionalDocument doc = (BpaAdditionalDocument)l.next();
            this.bpelExportAction.addToAdditionalDocuments(doc.getdocumentName(), doc.getAdditionalDocument());
        }
        return this.bpelProcessExportAction;
    }

    public BpelProcessExportActionImpl getBpelProcessExportAction() {
        return this.bpelProcessExportAction;
    }

    @Override
    public void setProcessContext(Graph processGraph) {
        this.processGraph = processGraph;
    }

    private IBpelElement constructBpelElement(Element stdBpel, BpelElementExtn bpelElementExtn) {
        BpelElementImpl bpelElement = new BpelElementImpl();
        if (bpelElementExtn.getXMLNotation() != null) {
            bpelElement.setXMLNotation(bpelElementExtn.getXMLNotation());
        } else {
            Element refChild = null;
            if (stdBpel != null) {
                refChild = (Element)stdBpel.getFirstChild();
            }
            for (Node addlNode : bpelElementExtn.getAdditionalNodes()) {
                if (addlNode instanceof Element) {
                    if (stdBpel == null) {
                        stdBpel = (Element)addlNode;
                        refChild = (Element)stdBpel.getFirstChild();
                        continue;
                    }
                    if (refChild == null) {
                        stdBpel.appendChild((Element)addlNode);
                        refChild = (Element)addlNode;
                        continue;
                    }
                    stdBpel.insertBefore((Element)addlNode, refChild);
                    refChild = (Element)addlNode;
                    continue;
                }
                if (!(addlNode instanceof Attr) || stdBpel == null) continue;
                stdBpel.setAttributeNode((Attr)addlNode);
            }
            bpelElement.setXMLNotation(stdBpel);
        }
        XMLLogUtil.logXMLSnippet(bpelElement.getXMLNotation(), "Constructed Snippet : ", 4, "BpelProcessExportImpl", "constructBpelElement()", this.bpaContext);
        return bpelElement;
    }
}

