/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpa.bpmn.util;

import java.util.Date;
import java.util.Stack;
import java.util.logging.Level;
import oracle.bpa.common.log.BpaDiagnosticService;

public class Timer {
    private Stack times = new Stack();

    public void tick(String op) {
        this.log("starting " + op);
        TimeOp timeOp = new TimeOp(op, new Date().getTime());
        this.times.push(timeOp);
    }

    public void tock() {
        TimeOp timeOp = (TimeOp)this.times.pop();
        this.log(timeOp.op + " : " + (new Date().getTime() - timeOp.time));
    }

    private void log(String message) {
        BpaDiagnosticService.log((int)5, (Level)BpaDiagnosticService.DEBUG, (String)message);
    }

    private class TimeOp {
        public String op;
        public long time;

        public TimeOp(String op, long time) {
            this.op = op;
            this.time = time;
        }
    }
}

