/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpa.bpmn.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;

public class Graph {
    private Decoration decoration;
    private Sequence<SequenceFlow> empty;

    public Object parse(NodeContainer process) {
        this.decoration = new Decoration();
        this.empty = CollectionUtils.emptySequence();
        this.parseObjects(process.getFlowNodes());
        return this.decoration;
    }

    public Sequence<SequenceFlow> getIncomingSequenceFlows(FlowNode node) {
        if (node.getId() != null) {
            return node.getIncomingSequenceFlows();
        }
        return this.empty;
    }

    public Sequence<SequenceFlow> getOutgoingSequenceFlows(FlowNode node) {
        if (node.getId() != null) {
            return node.getOutgoingSequenceFlows();
        }
        return this.empty;
    }

    public Set<FlowNode> getNodes() {
        return this.decoration.nodes;
    }

    public FlowNode getNode(String id) {
        return this.decoration.idxnode.get(id);
    }

    public FlowNode getStart() throws Exception {
        FlowNode start = null;
        HashSet<FlowNode> starts = new HashSet<FlowNode>();
        for (FlowNode node : this.getNodes()) {
            if (!this.getIncomingSequenceFlows(node).isEmpty()) continue;
            starts.add(node);
        }
        if (starts.size() == 1) {
            start = (FlowNode)starts.iterator().next();
        }
        if (starts.size() > 1) {
            throw new Exception("Can not convert processes with more than one start event to bpel");
        }
        return start;
    }

    public FlowNode getEnd() {
        FlowNode end = null;
        for (FlowNode node : this.getNodes()) {
            if (!this.getOutgoingSequenceFlows(node).isEmpty() || !node.isEvent()) continue;
            end = node;
        }
        if (end == null) {
            for (FlowNode node : this.getNodes()) {
                if (!this.getOutgoingSequenceFlows(node).isEmpty()) continue;
                end = node;
            }
        }
        return end;
    }

    public boolean isEnd(FlowNode node) {
        if (node == null) {
            return true;
        }
        if (node.getId() == null) {
            return false;
        }
        return this.getOutgoingSequenceFlows(node).isEmpty();
    }

    public boolean isStart(FlowNode node) {
        if (node.getId() == null) {
            return false;
        }
        return this.getIncomingSequenceFlows(node).isEmpty();
    }

    public String toString() {
        return this.decoration.incoming.toString() + this.decoration.outgoing.toString();
    }

    private void parseObjects(Sequence<FlowNode> objects) {
        for (FlowNode node : objects) {
            this.decoration.nodes.add(node);
            this.decoration.idxnode.put(node.getId(), node);
            for (SequenceFlow sequenceFlow : node.getOutgoingSequenceFlows()) {
                Set<SequenceFlow> in = this.decoration.incoming.get(sequenceFlow.getTarget());
                if (in == null) {
                    in = new HashSet<SequenceFlow>();
                    this.decoration.incoming.put(sequenceFlow.getTarget().getId(), in);
                }
                in.add(sequenceFlow);
                Set<SequenceFlow> out = this.decoration.outgoing.get(node.getId());
                if (out == null) {
                    out = new HashSet<SequenceFlow>();
                    this.decoration.outgoing.put(node.getId(), out);
                }
                out.add(sequenceFlow);
            }
        }
    }

    private class Decoration {
        public Hashtable<String, FlowNode> idxnode;
        public Hashtable<String, Set<SequenceFlow>> incoming;
        public Set<FlowNode> nodes = new HashSet<FlowNode>();
        public Hashtable<String, Set<SequenceFlow>> outgoing;

        public Decoration() {
            this.idxnode = new Hashtable();
            this.incoming = new Hashtable();
            this.outgoing = new Hashtable();
        }
    }
}

