/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpa.bpmn.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import oracle.bpa.bpmn.util.BackedgeFinder;
import oracle.bpa.bpmn.util.Graph;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.log.BpaDiagnosticService;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;

public class BoundaryFinder {
    BpaContext bpaContext;
    private BackedgeFinder backFinder;
    private Set<FlowNode> badGateways;
    private FlowNode current;
    private Decoration decoration;
    private Set<FlowNode> deferred;
    private HashMap<SequenceFlow, Token> edges;
    private Token endToken;
    private Graph graph;
    private Set<SequenceFlow> ignoreEdges;
    private Set<String> ignoreLetters;
    private Letter letter;
    private Queue<FlowNode> nodes;
    private int threshhold;
    private static int threshhold_max = 1000;
    private static double combineThreshhold = 0.98;

    public BoundaryFinder(BpaContext context) {
        this.bpaContext = context;
    }

    public Set<FlowNode> getCrossEdgeNodes() {
        return this.badGateways;
    }

    public Object parse(NodeContainer process) throws Exception {
        this.ignoreLetters = new HashSet<String>();
        this.ignoreEdges = new HashSet<SequenceFlow>();
        this.badGateways = new HashSet<FlowNode>();
        this.endToken = new Token();
        this.letter = new Letter();
        this.edges = new HashMap();
        this.nodes = new LinkedList<FlowNode>();
        this.deferred = new HashSet<FlowNode>();
        this.graph = new Graph();
        this.graph.parse(process);
        this.current = this.graph.getStart();
        this.nodes.offer(this.current);
        this.backFinder = new BackedgeFinder();
        this.backFinder.parse(process);
        this.decoration = new Decoration();
        Exception ex = null;
        try {
            this.assignTokens();
        }
        catch (Exception e) {
            ex = e;
        }
        if (this.badGateways.size() != 0) {
            Object[] args = new Object[this.badGateways.size()];
            int i = 0;
            for (FlowNode node : this.badGateways) {
                this.log("Cross Edge at : " + node.getId() + " " + node.getName());
                args[i++] = node.getId();
            }
            throw new BpaException("BoundaryFinder", "parse()", 19002, args, this.bpaContext);
        }
        return this.decoration;
    }

    public Object getBound(FlowNode origin) {
        return this.decoration.boundary.get(origin);
    }

    public String toString() {
        Hashtable b = this.decoration.boundary;
        String ret = "";
        ret = "Boundary is [ ";
        Enumeration e = b.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = b.get(k);
            ret = ret + this.str(k) + "=" + this.str(v) + ",";
        }
        return ret + "]";
    }

    private void foundBoundary(String l) {
        if (this.decoration.boundary.containsKey(l)) {
            FlowNode originator = (FlowNode)this.decoration.boundary.get(l);
            this.decoration.boundary.remove(l);
            this.decoration.boundary.put(originator, this.current);
            this.log("Found boundary : " + l + " : " + originator.getId() + " " + originator.getName() + " : " + this.current.getId() + " " + this.current.getName());
        }
    }

    private void assignTokens() throws BpaException {
        while (!this.nodes.isEmpty()) {
            this.current = this.nodes.poll();
            this.log("Assigning Token at node : " + this.current.getId() + " " + this.current.getName());
            Sequence<SequenceFlow> inSequenceFlows = this.graph.getIncomingSequenceFlows(this.current);
            Sequence<SequenceFlow> outSequenceFlows = this.graph.getOutgoingSequenceFlows(this.current);
            this.log("no. of inflows " + CollectionUtils.size(inSequenceFlows));
            this.log("No. of outflows " + CollectionUtils.size(outSequenceFlows));
            if (inSequenceFlows.isEmpty()) {
                String letterr = this.letter.getLetter();
                this.decoration.boundary.put(letterr, this.current);
                if (outSequenceFlows.iterator().hasNext()) {
                    Token token;
                    Token mtoken = token = new Token();
                    int i = 0;
                    for (SequenceFlow flow : outSequenceFlows) {
                        Token newToken = mtoken.clone().addPart(new TokenPart(letterr, i + 1, 1.0 / (double)CollectionUtils.size(outSequenceFlows)));
                        this.edges.put(flow, newToken);
                        this.nodes.offer(flow.getTarget());
                        ++i;
                    }
                    continue;
                }
                return;
            }
            if (outSequenceFlows.isEmpty()) {
                for (SequenceFlow sequenceFlow : inSequenceFlows) {
                    if (this.ignoreEdges.contains(sequenceFlow) || !this.edges.containsKey(sequenceFlow)) continue;
                    this.ignoreEdges.add(sequenceFlow);
                    this.endToken.combineEnds(this.edges.get(sequenceFlow));
                }
                this.releaseGateways();
                continue;
            }
            boolean allTokens = true;
            for (SequenceFlow sequenceFlow : inSequenceFlows) {
                if (this.backFinder.isBackEdge(sequenceFlow) || this.edges.containsKey(sequenceFlow)) continue;
                this.log("Bad Edge : Source" + sequenceFlow.getSource().getName() + " : Target " + sequenceFlow.getTarget().getName());
                allTokens = false;
                ++this.threshhold;
                if (this.threshhold < threshhold_max) {
                    this.nodes.offer(this.current);
                    this.deferred.add(this.current);
                    break;
                }
                this.nodes.offer(this.current);
                this.deferred.add(this.current);
                Object[] args = new Object[this.nodes.size()];
                int i = 0;
                while (!this.nodes.isEmpty()) {
                    this.current = this.nodes.poll();
                    this.log("Missing token at : " + this.current.getId() + " " + this.current.getName());
                    args[i++] = this.current.getId();
                }
                throw new BpaException("BoundaryFinder", "assignTokens()", 19003, args, this.bpaContext);
            }
            if (!allTokens) {
                this.log("Continuing in lack of tokens : " + this.current.getId() + " " + this.current.getName());
                continue;
            }
            this.deferred.remove(this.current);
            boolean hadBackEdge = false;
            SequenceFlow[] sequenceFlows = inSequenceFlows.toArray(new SequenceFlow[1]);
            for (int p = 0; p < sequenceFlows.length; ++p) {
                for (int i = 0; i < sequenceFlows.length; ++i) {
                    String l;
                    if (this.backFinder.isBackEdge(sequenceFlows[i])) {
                        hadBackEdge = true;
                    }
                    if (!this.backFinder.isBackEdge(sequenceFlows[i]) || !this.edges.containsKey(sequenceFlows[i])) continue;
                    Token token1 = this.edges.get(sequenceFlows[i]);
                    this.log("Token is : " + token1.toString());
                    Token token2 = null;
                    for (int j = 0; j < sequenceFlows.length; ++j) {
                        if (sequenceFlows[i] == sequenceFlows[j] || this.backFinder.isBackEdge(sequenceFlows[j])) continue;
                        token2 = this.edges.get(sequenceFlows[j]);
                        this.log("Other token is : " + token2.toString());
                    }
                    Set letters = token1.minus(token2);
                    if (letters.size() > 1) {
                        this.log("Could not process back edge : Source" + sequenceFlows[i].getSource().getName() + " : Target " + sequenceFlows[i].getTarget().getName());
                        continue;
                    }
                    if (CollectionUtils.size(outSequenceFlows) == 1) {
                        l = token1.bigLetter();
                        this.ignoreLetters.add(l);
                        this.log("Adding to whileLetter : " + l);
                    } else {
                        l = (String)this.decoration.getKey(this.current);
                        this.ignoreLetters.add(l);
                        this.log("Adding to whileLetter : " + l);
                    }
                    int label = token1.getPart((String)l).n;
                    FlowNode v = (FlowNode)this.decoration.boundary.get(l);
                    this.decoration.boundary.remove(l);
                    for (SequenceFlow sequenceFlow : this.graph.getOutgoingSequenceFlows(v)) {
                        if (this.edges.get((Object)sequenceFlow).getPart((String)l).n != label) continue;
                        this.decoration.boundary.put(v, sequenceFlow);
                    }
                    this.backFinder.remove(sequenceFlows[i]);
                    this.endToken.combineEnds(this.edges.get(sequenceFlows[i]));
                    this.releaseGateways();
                }
            }
            allTokens = true;
            int countback = 0;
            for (SequenceFlow sequenceFlow : inSequenceFlows) {
                if (!this.backFinder.isBackEdge(sequenceFlow)) continue;
                ++countback;
                if (this.edges.containsKey(sequenceFlow)) continue;
                allTokens = false;
            }
            if (countback > 0 && allTokens) {
                this.log("Continuing");
                ++this.threshhold;
                if (this.threshhold < threshhold_max) {
                    this.nodes.offer(this.current);
                    continue;
                }
                this.badGateways.add(this.current);
                return;
            }
            if (this.edges.get(outSequenceFlows.iterator().next()) != null) continue;
            inSequenceFlows = this.removeBackedges(inSequenceFlows);
            Token token = new Token();
            boolean success = false;
            for (SequenceFlow sequenceFlow : inSequenceFlows) {
                if (token.parts.size() == 0) {
                    token = this.edges.get(sequenceFlow).clone();
                    continue;
                }
                boolean tmp = token.combine(this.edges.get(sequenceFlow));
            }
            if (CollectionUtils.size(inSequenceFlows) > 1) {
                success = token.combineWithEnd();
            }
            if (!success && CollectionUtils.size(inSequenceFlows) > 1) {
                HashSet<String> tmp = new HashSet<String>();
                for (SequenceFlow sequenceFlow : inSequenceFlows) {
                    tmp.add(this.edges.get(sequenceFlow).bigLetter());
                }
                if (tmp.size() == 1) {
                    this.log("Partial Recombination at : " + this.current.getId() + " " + this.current.getName());
                } else {
                    this.badGateways.add(this.current);
                    continue;
                }
            }
            if (CollectionUtils.size(outSequenceFlows) == 1) {
                this.edges.put(outSequenceFlows.iterator().next(), token);
                this.nodes.offer(this.graph.getNode(outSequenceFlows.iterator().next().getTarget().getId()));
                continue;
            }
            String letterr = this.letter.getLetter();
            this.decoration.boundary.put(letterr, this.current);
            this.log("Got letter : " + letterr + " for node : " + this.current.getId() + " " + this.current.getName());
            Token mtoken = token.clone().split(CollectionUtils.size(outSequenceFlows));
            int i = 0;
            for (SequenceFlow sequenceFlow : outSequenceFlows) {
                Token newToken = mtoken.clone().addPart(new TokenPart(letterr, i + 1, 1.0 / (double)CollectionUtils.size(outSequenceFlows)));
                this.edges.put(sequenceFlow, newToken);
                this.nodes.offer(this.graph.getNode(sequenceFlow.getTarget().getId()));
                ++i;
            }
        }
    }

    private boolean containNonDeferred() {
        Object[] a = this.nodes.toArray();
        boolean retV = false;
        for (int i = 0; i < a.length; ++i) {
            if (this.deferred.contains(a[i])) continue;
            retV = true;
            break;
        }
        return retV;
    }

    private Sequence<SequenceFlow> removeBackedges(Sequence<SequenceFlow> edges) {
        if (edges == null) {
            return null;
        }
        HashSet<SequenceFlow> c = new HashSet<SequenceFlow>();
        for (SequenceFlow sequenceFlow : edges) {
            if (this.backFinder.isBackEdge(sequenceFlow)) continue;
            c.add(sequenceFlow);
        }
        return CollectionUtils.asSequence(c);
    }

    private void releaseGateways() {
        for (FlowNode node : this.badGateways) {
            this.nodes.offer(node);
        }
        this.badGateways = new HashSet<FlowNode>();
    }

    private void log(String message) {
        BpaDiagnosticService.log((int)5, (Level)BpaDiagnosticService.INFORMATION, (String)message);
    }

    private String str(Object o) {
        String ret = "";
        ret = o instanceof FlowNode ? ((FlowNode)o).getId() : (o instanceof SequenceFlow ? ((SequenceFlow)o).getName() : o.toString());
        return ret;
    }

    private boolean isSwitch(FlowNode node) {
        return node.isGateway() && node.getBpmnType().equals((Object)BpmnType.EXCLUSIVE_GATEWAY);
    }

    static {
        try {
            Class.forName("oracle.bpa.bpmn.util.BPELWriter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class TokenPart {
        public double fraction;
        public String letter;
        public int n;

        public TokenPart(String letter, int n, double fraction) {
            this.letter = letter;
            this.n = n;
            this.fraction = fraction;
        }

        public boolean equals(TokenPart other) {
            return this.letter.equals(other.letter) && this.n == other.n && this.fraction == other.fraction;
        }

        public TokenPart clone() {
            return new TokenPart(this.letter, this.n, this.fraction);
        }

        public String toString() {
            return this.letter + "/" + this.fraction;
        }
    }

    private class Token {
        public Set<TokenPart> parts = new HashSet<TokenPart>();

        public Token split(int n) {
            for (TokenPart part : this.parts) {
                part.fraction /= (double)n;
            }
            return this;
        }

        public TokenPart getPart(String letter) {
            TokenPart r = null;
            for (TokenPart part : this.parts) {
                if (!part.letter.equals(letter)) continue;
                r = part;
            }
            return r;
        }

        public Token addPart(TokenPart tokenPart) {
            TokenPart t = this.getPart(tokenPart.letter);
            if (t == null) {
                this.parts.add(tokenPart);
            } else {
                t.fraction += tokenPart.fraction;
            }
            return this;
        }

        public String bigLetter() {
            String r = "";
            for (TokenPart part : this.parts) {
                if (r.compareTo(part.letter) >= 0 || BoundaryFinder.this.ignoreLetters.contains(part.letter)) continue;
                r = part.letter;
            }
            return r;
        }

        public Set minus(Token other) {
            HashSet<String> l = new HashSet<String>();
            HashSet<String> r = new HashSet<String>();
            for (TokenPart part : this.parts) {
                if (BoundaryFinder.this.ignoreLetters.contains(part.letter)) continue;
                l.add(part.letter);
            }
            for (TokenPart part : other.parts) {
                if (BoundaryFinder.this.ignoreLetters.contains(part.letter)) continue;
                r.add(part.letter);
            }
            l.removeAll(r);
            return l;
        }

        public boolean combine(Token other) {
            boolean r = false;
            for (TokenPart part : other.parts) {
                this.addPart(part);
            }
            return r;
        }

        public boolean combineEnds(Token other) {
            for (TokenPart part : other.parts) {
                this.addPart(part);
                String l = part.letter;
                if (!(this.getPart((String)part.letter).fraction > combineThreshhold) || l.equals("a")) continue;
                BoundaryFinder.this.foundBoundary(l);
                this.parts.remove(this.getPart(l));
            }
            return true;
        }

        public boolean combineWithEnd() {
            String l;
            TokenPart part;
            boolean r = false;
            while ((part = this.getPart(l = this.bigLetter())) != null && part.fraction > combineThreshhold && !l.equals("a")) {
                BoundaryFinder.this.foundBoundary(l);
                this.parts.remove(part);
                r = true;
            }
            if (r) {
                return r;
            }
            while (true) {
                l = this.bigLetter();
                part = this.getPart(l);
                TokenPart partE = BoundaryFinder.this.endToken.getPart(l);
                if (part == null) break;
                double d = part.fraction;
                double d2 = partE == null ? 0.0 : partE.fraction;
                if (!(d + d2 > combineThreshhold) || l.equals("a")) break;
                BoundaryFinder.this.foundBoundary(l);
                this.parts.remove(part);
                r = true;
                ((BoundaryFinder)BoundaryFinder.this).endToken.parts.remove(partE);
            }
            return r;
        }

        public Token clone() {
            Token t = new Token();
            for (TokenPart part : this.parts) {
                t.addPart(part.clone());
            }
            return t;
        }

        public String toString() {
            return this.parts.toString();
        }
    }

    private class Letter {
        public int c = 0;
        public String[] letters;

        public Letter() {
            int i;
            String[] t = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
            Vector<String> v = new Vector<String>();
            for (i = 0; i < t.length; ++i) {
                v.add(t[i]);
            }
            for (i = 0; i < 1000; ++i) {
                v.add("z" + v.elementAt(v.size() - 1));
            }
            this.letters = v.toArray(new String[1]);
        }

        public String getLetter() {
            ++this.c;
            return this.letters[this.c - 1];
        }
    }

    private class Decoration {
        public Hashtable boundary = new Hashtable();

        public Object getKey(FlowNode node) {
            for (Object key : this.boundary.keySet()) {
                Object value = this.boundary.get(key);
                if (value != node) continue;
                return key;
            }
            return null;
        }
    }
}

