/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpa.bpmn.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import oracle.bpa.bpmn.util.BoundaryFinder;
import oracle.bpa.bpmn.util.Counter;
import oracle.bpa.bpmn.util.Graph;
import oracle.bpa.bpmn.util.Timer;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.log.BpaDiagnosticService;
import oracle.bpa.common.log.iface.IBpaLogger;
import oracle.bpa.common.soa.ConstantsUtil;
import oracle.bpa.export.bpmn.BpelExportFactory;
import oracle.bpa.export.bpmn.iface.IBpelExport;
import oracle.bpa.export.bpmn.iface.IBpelExportAction;
import oracle.bpa.export.bpmn.iface.IBpelProcessExport;
import oracle.bpa.export.bpmn.iface.IBpelProcessExportAction;
import oracle.bpa.export.bpmn.impl.BpelProcessExportActionImpl;
import oracle.bpa.export.bpmn.impl.BpelProcessExportImpl;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lib.Expression;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MessageEventDefinition;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.project.model.processes.ParticipantReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.TimerEventType;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.rules.sdk2.datamodel.FactType;
import oracle.rules.sdk2.decisionpoint.MetadataHelper;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Analysis;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Annotation;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Property;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BPELWriter {
    private IBpelExportAction action;
    private BoundaryFinder boundaryFinder;
    private BpaContext context;
    private Counter counter;
    private Decoration decoration;
    private IBpelExport exporter;
    private Graph graph;
    private boolean isSub;
    private NodeContainer process;
    private IBpelProcessExportAction processAction;
    private IBpelProcessExport processExporter;
    private XMLElement processXml;
    private File projectDirectory;
    private HashMap<String, SchemaObject> schemaType = new HashMap();
    private boolean subpExp;
    private Timer timer;
    private HashMap<FlowNode, XMLElement> transformedNodes = new HashMap();
    private ZipOutputStream zipStream;
    private static final String UTF8 = "UTF-8";
    private static IBpaLogger logger = new IBpaLogger(){

        public void log(Level p2, String p3, Throwable p4) {
            if (p3 != null) {
                Log.logDebug(p3);
                System.out.println(p3);
            }
            if (p4 != null) {
                Log.logFatal(p4);
            }
        }
    };
    private static String Name;

    public BPELWriter(File projectDirectory, Boolean subpExport, Locale locale) {
        this.projectDirectory = projectDirectory;
        this.subpExp = subpExport;
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        this.context = new BpaContext(locale);
        this.context.setMode(BpaContext.Mode.BpmBpel);
        this.context.setOutFolder(projectDirectory.getAbsolutePath());
    }

    public BPELWriter(ZipOutputStream zipStream, Boolean subpExport, Locale locale, File projectDirectory) {
        this.projectDirectory = projectDirectory;
        this.zipStream = zipStream;
        this.subpExp = subpExport;
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        this.context = new BpaContext(locale);
        this.context.setMode(BpaContext.Mode.BpmBpel);
    }

    public Object parse(Process process) throws Exception {
        this.isSub = false;
        this.process = process;
        if (process.isCallableSubprocess()) {
            throw new Exception("Can not convert a callable process to bpel");
        }
        Sequence activities = process.getActivities(Subprocess.class);
        for (Subprocess activity : activities) {
            if (!activity.isTriggeredByEvent()) continue;
            throw new Exception("Can not convert a bpmn process containing event subprocess to bpel");
        }
        Sequence gateways = process.getGateways();
        for (Gateway gateway : gateways) {
            if (!gateway.getBpmnType().equals((Object)BpmnType.COMPLEX_GATEWAY)) continue;
            throw new Exception("Can not convert a bpmn process containing complex gateways");
        }
        this.writeDataAndServiceRefs((NodeContainer)process);
        this.exporter = BpelExportFactory.getBpelExportInstance();
        this.decoration = new Decoration();
        this.exporter.exportStarting(process.getId() + "_composite", (Document)this.decoration.document, logger, BpaDiagnosticService.DEBUG, this.context);
        this.counter = new Counter();
        this.timer = new Timer();
        this.timer.tick("Processing");
        this.graph = new Graph();
        this.graph.parse((NodeContainer)process);
        this.timer.tick("Analyzing Tokens");
        this.boundaryFinder = new BoundaryFinder(this.context);
        this.boundaryFinder.parse((NodeContainer)process);
        this.log(this.boundaryFinder.toString());
        this.timer.tock();
        this.processExporter = this.exporter.getProcessExport(process, (Document)this.decoration.document);
        FlowNode start = this.graph.getStart();
        this.log("start node is : " + start.getName());
        if (start.isEvent() && (((CatchEvent)start).getEventTriggerType().equals((Object)EventTriggerType.SIGNAL) || ((CatchEvent)start).getEventTriggerType().equals((Object)EventTriggerType.TIMER))) {
            throw new Exception("Can not convert bpmn starting with signal or timer event to bpel");
        }
        this.processXml = (XMLElement)this.decoration.document.createElement("process");
        this.processXml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        this.processXml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:taskservice", "http://xmlns.oracle.com/bpel/workflow/taskService");
        this.processXml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:task", "http://xmlns.oracle.com/bpel/workflow/task");
        this.processXml.setAttribute(Name, process.getDefaultLabel());
        this.decoration.document.appendChild((Node)this.processXml);
        Element processAnnotations = this.processExporter.processExporting().getXMLNotation();
        XMLElement partnerLinks = (XMLElement)this.decoration.document.createElement("partnerLinks");
        XMLElement variables = (XMLElement)this.decoration.document.createElement("variables");
        this.createVariablesFromDataObjects();
        this.timer.tick("Generation");
        this.generate(start, null, this.graph.getEnd(), this.processXml, Construct.Sequence, false);
        this.timer.tock();
        this.processAction = this.processExporter.processExported();
        this.processXml.insertBefore((Node)partnerLinks, this.processXml.getLastChild());
        for (XMLElement partnerLink : this.processAction.getPartnerLinks()) {
            partnerLinks.appendChild((Node)partnerLink);
        }
        for (XMLElement variable : this.processAction.getVariables()) {
            variables.appendChild((Node)variable);
        }
        if (variables.getChildrenByTagName("variable").getLength() > 0) {
            this.processXml.insertBefore((Node)variables, this.processXml.getLastChild());
        }
        Map nameSpaces = this.processAction.getNamespaces();
        for (String prefix : nameSpaces.keySet()) {
            String uri = nameSpaces.get(prefix).toString();
            this.processXml.setAttribute(prefix, uri);
        }
        this.log(this.counter.toString());
        this.action = this.exporter.exportFinished();
        this.timer.tock();
        return this.decoration;
    }

    public Object parse(NodeContainer process, XMLDocument document, IBpelExport exporter, IBpelProcessExport processExporter) throws Exception {
        this.isSub = true;
        XMLElement returnVal = null;
        Sequence activities = process.getActivities(Subprocess.class);
        for (Subprocess activity : activities) {
            if (!activity.isTriggeredByEvent()) continue;
            throw new Exception("Can not convert a bpmn process containing event subprocess to bpel");
        }
        this.decoration = new Decoration(document);
        this.processExporter = processExporter;
        XMLElement scope = (XMLElement)this.decoration.document.createElement("scope");
        scope.setAttribute(Name, process.getName());
        if (process instanceof oracle.bpm.project.model.processes.Activity) {
            scope.appendChild((Node)this.processExporter.elementExporting((FlowNode)((oracle.bpm.project.model.processes.Activity)process), "Scope").getXMLNotation());
        }
        returnVal = scope;
        this.log("Subprocess has : " + CollectionUtils.size(process.getFlowNodes()) + " nodes");
        if (CollectionUtils.size(process.getFlowNodes()) > 0) {
            this.process = process;
            this.counter = new Counter();
            this.timer = new Timer();
            this.timer.tick("Processing");
            this.graph = new Graph();
            this.graph.parse(process);
            this.timer.tick("Analyzing Tokens");
            this.boundaryFinder = new BoundaryFinder(this.context);
            this.boundaryFinder.parse(process);
            this.log(this.boundaryFinder.toString());
            this.timer.tock();
            this.exporter = exporter;
            this.processExporter.setProcessContext(this.graph);
            FlowNode start = this.graph.getStart();
            this.log("start node is : " + start.getName());
            if (start.isEvent() && (((CatchEvent)start).getEventTriggerType().equals((Object)EventTriggerType.SIGNAL) || ((CatchEvent)start).getEventTriggerType().equals((Object)EventTriggerType.TIMER))) {
                throw new Exception("Can not convert bpmn starting with signal or timer event to bpel");
            }
            this.createVariablesFromDataObjects();
            this.timer.tick("Generation");
            this.generate(start, null, this.graph.getEnd(), scope, Construct.Sequence, false);
            this.timer.tock();
            this.log(this.counter.toString());
            this.timer.tock();
        }
        return returnVal;
    }

    public void save() throws Exception {
        ZipEntry entry = null;
        if (this.process instanceof Process) {
            entry = new ZipEntry(this.process.getDefaultLabel() + ".bpel");
        }
        this.zipStream.putNextEntry(entry);
        this.zipStream.write(this.toString().getBytes(UTF8));
        this.zipStream.closeEntry();
        this.zipStream.close();
    }

    public void saveToProjectDirectory() throws Exception {
        String name = ((Process)this.process).getDefaultLabel() + ".bpel";
        FileOutputStream bpel = new FileOutputStream(new File(this.projectDirectory, name));
        this.save(bpel);
        bpel.close();
    }

    public void save(OutputStream output) throws IOException {
        output.write(this.toString().getBytes(UTF8));
    }

    public void writeDataAndServiceRefs(NodeContainer process) throws Exception {
    }

    public XMLDocument getDocument() {
        return this.decoration.document;
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.decoration.document.print((Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            new BpaException("BPELWriter", "toString()", 19001, (Throwable)e, this.context);
            return null;
        }
    }

    private void createVariablesFromDataObjects() throws Exception {
        SchemaObject schemaObject;
        Variable variable;
        BpelProcessExportActionImpl bpelProcessExportAction = ((BpelProcessExportImpl)this.processExporter).getBpelProcessExportAction();
        for (DataObject dataObject : this.process.getDataObjects()) {
            variable = (Variable)BPELParser.createImplementation(Variable.class);
            variable.createDOMElement((Document)this.decoration.document, "", true);
            variable.setName(dataObject.getName());
            schemaObject = null;
            if (dataObject.asAttributeTypeDescription().getType() != null) {
                schemaObject = dataObject.asAttributeTypeDescription().getType().asSchemaObject();
            }
            if (schemaObject != null) {
                if (!schemaObject.isBasicType()) {
                    variable.setElement(new QName("", schemaObject.getName(), dataObject.getName()));
                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)dataObject.getName()), new URI(schemaObject.getNamespace()));
                    this.schemaType.put(dataObject.getName(), schemaObject);
                } else if (schemaObject.isBasicType()) {
                    variable.setType(new QName("", schemaObject.getName(), "xsd"));
                }
            }
            bpelProcessExportAction.addToVariables((Element)((XMLElement)variable.getDOMElement()));
        }
        for (DataObject dataObject : this.process.getProject().getBusinessIndicators()) {
            variable = (Variable)BPELParser.createImplementation(Variable.class);
            variable.createDOMElement((Document)this.decoration.document, "", true);
            variable.setName(dataObject.getName());
            schemaObject = null;
            if (dataObject.asAttributeTypeDescription().getType() != null) {
                schemaObject = dataObject.asAttributeTypeDescription().getType().asSchemaObject();
            }
            if (schemaObject != null) {
                if (!schemaObject.isBasicType()) {
                    variable.setElement(new QName("", schemaObject.getName(), dataObject.getName()));
                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)dataObject.getName()), new URI(schemaObject.getNamespace()));
                    this.schemaType.put(dataObject.getName(), schemaObject);
                } else if (schemaObject.isBasicType()) {
                    variable.setType(new QName("", schemaObject.getName(), "xsd"));
                }
            }
            bpelProcessExportAction.addToVariables((Element)((XMLElement)variable.getDOMElement()));
        }
        for (DataObject dataObject : this.process.getProject().getNonBusinessIndicators()) {
            variable = (Variable)BPELParser.createImplementation(Variable.class);
            variable.createDOMElement((Document)this.decoration.document, "", true);
            variable.setName(dataObject.getName());
            schemaObject = null;
            if (dataObject.asAttributeTypeDescription().getType() != null) {
                schemaObject = dataObject.asAttributeTypeDescription().getType().asSchemaObject();
            }
            if (schemaObject != null) {
                if (!schemaObject.isBasicType()) {
                    variable.setElement(new QName("", schemaObject.getName(), dataObject.getName()));
                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)dataObject.getName()), new URI(schemaObject.getNamespace()));
                    this.schemaType.put(dataObject.getName(), schemaObject);
                } else if (schemaObject.isBasicType()) {
                    variable.setType(new QName("", schemaObject.getName(), "xsd"));
                }
            }
            bpelProcessExportAction.addToVariables((Element)((XMLElement)variable.getDOMElement()));
        }
    }

    private Construct getType(FlowNode node) {
        Object endNode = this.boundaryFinder.getBound(node);
        Sequence<SequenceFlow> sequenceFlows = this.graph.getOutgoingSequenceFlows(node);
        if (CollectionUtils.size(sequenceFlows) < 2) {
            LoopCharacteristicsType loop;
            if (node.isActivity() && (loop = ((oracle.bpm.project.model.processes.Activity)node).getLoopCharacteristicsType()) != null) {
                if (loop.equals((Object)LoopCharacteristicsType.MULTIINSTANCE)) {
                    return Construct.MICycle;
                }
                if (loop.equals((Object)LoopCharacteristicsType.LOOP)) {
                    return Construct.SICycle;
                }
            }
            return Construct.Sequence;
        }
        if (endNode != null && endNode instanceof SequenceFlow) {
            return Construct.While;
        }
        if (node.isGateway() && node.getBpmnType().equals((Object)BpmnType.EXCLUSIVE_GATEWAY)) {
            return Construct.Switch;
        }
        if (node.isGateway() && node.getBpmnType().equals((Object)BpmnType.EVENT_BASED_GATEWAY)) {
            return Construct.Pick;
        }
        if (node.isGateway() && node.getBpmnType().equals((Object)BpmnType.INCLUSIVE_GATEWAY)) {
            return Construct.OR;
        }
        return Construct.Flow;
    }

    private boolean processBoundaryEvents(FlowNode node, Object bound) throws Exception {
        if (node.isActivity() && CollectionUtils.size(((oracle.bpm.project.model.processes.Activity)node).getActivityBoundaryEvents()) > 0) {
            Sequence faultEvents = ((oracle.bpm.project.model.processes.Activity)node).getActivityBoundaryEvents();
            for (BoundaryEvent faultEvent : faultEvents) {
                XMLElement eventHandlers;
                XMLElement faultHandlers;
                XMLElement handlerFor;
                if (faultEvent.getEventTriggerType().equals((Object)EventTriggerType.COMPENSATION)) {
                    XMLElement compensationHandler;
                    handlerFor = this.transformedNodes.get(node);
                    if (handlerFor == null) continue;
                    XMLElement xMLElement = compensationHandler = handlerFor.getChildrenByTagName("compensationHandler").getLength() > 0 ? (XMLElement)handlerFor.getChildrenByTagName("compensationHandler").item(0) : null;
                    if (compensationHandler == null) {
                        compensationHandler = (XMLElement)this.decoration.document.createElement("compensationHandler");
                        compensationHandler.appendChild((Node)this.processExporter.elementExporting((FlowNode)faultEvent, "CompensationHandler").getXMLNotation());
                        handlerFor.insertBefore((Node)compensationHandler, handlerFor.getLastChild());
                    }
                    if (!this.graph.getOutgoingSequenceFlows((FlowNode)faultEvent).iterator().hasNext()) continue;
                    SequenceFlow afterEvent = this.graph.getOutgoingSequenceFlows((FlowNode)faultEvent).iterator().next();
                    this.generate(afterEvent.getTarget(), afterEvent, bound, compensationHandler, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                    continue;
                }
                handlerFor = this.transformedNodes.get(node);
                if (handlerFor == null) continue;
                XMLElement xMLElement = faultHandlers = handlerFor.getChildrenByTagName("faultHandlers").getLength() > 0 ? (XMLElement)handlerFor.getChildrenByTagName("faultHandlers").item(0) : null;
                if (faultHandlers == null) {
                    faultHandlers = (XMLElement)this.decoration.document.createElement("faultHandlers");
                    faultHandlers.appendChild((Node)this.processExporter.elementExporting((FlowNode)faultEvent, "FaultHandler").getXMLNotation());
                    handlerFor.insertBefore((Node)faultHandlers, handlerFor.getLastChild());
                }
                XMLElement catche = (XMLElement)this.decoration.document.createElement("catch");
                faultHandlers.appendChild((Node)catche);
                if (this.graph.getOutgoingSequenceFlows((FlowNode)faultEvent).iterator().hasNext()) {
                    SequenceFlow afterEvent = this.graph.getOutgoingSequenceFlows((FlowNode)faultEvent).iterator().next();
                    this.generate(afterEvent.getTarget(), afterEvent, bound, catche, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                }
                this.log("******** at event");
                EventDefinition ed = faultEvent.getEventDefinition();
                if (faultEvent.getEventTriggerType().equals((Object)EventTriggerType.ERROR)) continue;
                XMLElement on = null;
                if (faultEvent.getEventTriggerType().equals((Object)EventTriggerType.TIMER)) {
                    on = (XMLElement)this.decoration.document.createElement("onAlarm");
                    TimerEventDefinition ted = (TimerEventDefinition)ed.as(TimerEventDefinition.class);
                    TimerEventType timerEventType = ted.getType();
                    Expression timeCycle = ted.getTimeCycleExpression();
                    if (timeCycle != null) {
                        this.log("******* Timer Cycle" + timeCycle.getExpressionValue());
                        on.setAttribute("for", timeCycle.getExpressionValue());
                    } else {
                        Expression timeDate = ted.getTimeDateExpression();
                        if (timeDate != null) {
                            this.log("******* Timer Date" + timeDate.getExpressionValue());
                            on.setAttribute("until", timeDate.getExpressionValue());
                        }
                    }
                } else {
                    CatalogObject participant;
                    on = (XMLElement)this.decoration.document.createElement("onMessage");
                    this.log("****** onMessage class: " + ed.getClass().getName());
                    MessageEventDefinition med = (MessageEventDefinition)ed.as(MessageEventDefinition.class);
                    CatchEvent ce = faultEvent.asCatchEvent();
                    String operationName = ce.getOperationName();
                    this.log("**** operationName: " + operationName);
                    if (operationName != null) {
                        on.setAttribute("operation", operationName);
                    }
                    CatalogMember operation = ce.getOperation();
                    ParticipantReference parRef = ce.getParticipantRef();
                    if (parRef != null) {
                        this.log("*** parRef: " + parRef.getId());
                    }
                    if ((participant = ce.getParticipant()) != null) {
                        this.log("*******participant.getId():" + participant.getId());
                        String serviceName = participant.getName();
                        if (serviceName != null) {
                            this.createPartnerLinkAndVariable(ce, handlerFor, on);
                        }
                    }
                }
                XMLElement thr = (XMLElement)this.decoration.document.createElement("throw");
                on.appendChild((Node)thr);
                XMLElement xMLElement2 = eventHandlers = handlerFor.getChildrenByTagName("eventHandlers").getLength() > 0 ? (XMLElement)handlerFor.getChildrenByTagName("eventHandlers").item(0) : null;
                if (eventHandlers == null) {
                    eventHandlers = (XMLElement)this.decoration.document.createElement("eventHandlers");
                    eventHandlers.appendChild((Node)this.processExporter.elementExporting((FlowNode)faultEvent, "EventHandler").getXMLNotation());
                    handlerFor.insertBefore((Node)eventHandlers, handlerFor.getLastChild());
                }
                eventHandlers.appendChild((Node)on);
            }
            return true;
        }
        return false;
    }

    private FlowNode generate(FlowNode node, SequenceFlow inConnection, Object bound, XMLElement container, Construct type, boolean exclude) throws Exception {
        if (!(this.boundaryFinder.getBound(node) == null || !(this.boundaryFinder.getBound(node) instanceof SequenceFlow) && this.graph.isEnd((FlowNode)this.boundaryFinder.getBound(node)) || type.equals((Object)Construct.Sequence))) {
            bound = this.boundaryFinder.getBound(node);
        }
        if (type.equals((Object)Construct.None)) {
            type = this.getType(node);
        }
        switch (type) {
            case Sequence: {
                XMLElement sequence = (XMLElement)this.decoration.document.createElement("sequence");
                if (inConnection != null) {
                    sequence.appendChild((Node)this.processExporter.elementExporting(inConnection, "Sequence").getXMLNotation());
                } else {
                    if (this.process instanceof NodeContainer) {
                        SendTask dummyTask = this.process.createActivity().toSendTask();
                        dummyTask.setId(this.process.getId());
                        sequence.appendChild((Node)this.processExporter.elementExporting((FlowNode)dummyTask, "Sequence").getXMLNotation());
                    }
                    sequence.setAttribute("name", "main");
                }
                container.appendChild((Node)sequence);
                container = sequence;
                while (node != null && bound != null && !node.equals(bound) && CollectionUtils.size(this.graph.getOutgoingSequenceFlows(node)) > 0) {
                    boolean isLoop;
                    LoopCharacteristicsType loop = null;
                    if (node.isActivity()) {
                        loop = ((oracle.bpm.project.model.processes.Activity)node).getLoopCharacteristicsType();
                    }
                    boolean bl = isLoop = loop != null && !loop.equals((Object)LoopCharacteristicsType.NONE);
                    if (CollectionUtils.size(this.graph.getOutgoingSequenceFlows(node)) == 1 && !isLoop) {
                        if (!node.isGateway()) {
                            this.transform(node, container);
                        }
                        this.processBoundaryEvents(node, bound);
                        node = this.graph.getNode(this.graph.getOutgoingSequenceFlows(node).iterator().next().getTarget().getId());
                        continue;
                    }
                    if (!node.isGateway() && !isLoop) {
                        this.transform(node, container);
                    }
                    this.processBoundaryEvents(node, bound);
                    node = this.generate(node, null, bound, container, Construct.None, false);
                }
                if (node != null && (!exclude || this.graph.isEnd(node))) {
                    this.transform(node, container);
                    this.processBoundaryEvents(node, bound);
                }
                return node;
            }
            case SICycle: {
                XMLElement whil = (XMLElement)this.decoration.document.createElement("while");
                SendTask dummyTask = this.process.createActivity().toSendTask();
                dummyTask.setId(node.getId());
                whil.appendChild((Node)this.processExporter.elementExporting((FlowNode)dummyTask, "While").getXMLNotation());
                if (((Loop)((oracle.bpm.project.model.processes.Activity)node).getLoopCharacteristics().as(Loop.class)).getLoopExpression() != null) {
                    whil.setAttribute("condition", ((Loop)((oracle.bpm.project.model.processes.Activity)node).getLoopCharacteristics().as(Loop.class)).getLoopExpression().getExpressionValue());
                }
                container.appendChild((Node)whil);
                this.generate(node, this.graph.getIncomingSequenceFlows(node).iterator().next(), node, whil, Construct.Sequence, false);
                return this.graph.getNode(this.graph.getOutgoingSequenceFlows(node).iterator().next().getTarget().getId());
            }
            case MICycle: {
                SendTask dummyTask = this.process.createActivity().toSendTask();
                dummyTask.setId(node.getId());
                XMLElement flown = (XMLElement)this.processExporter.elementExporting((FlowNode)dummyTask, "FlowN").getXMLNotation();
                if (((MultiInstance)((oracle.bpm.project.model.processes.Activity)node).getLoopCharacteristics().as(MultiInstance.class)).getLoopCardinality() != null) {
                    flown.setAttribute("N", ((MultiInstance)((oracle.bpm.project.model.processes.Activity)node).getLoopCharacteristics().as(MultiInstance.class)).getLoopCardinality().getExpressionValue());
                }
                container.appendChild((Node)flown);
                this.generate(node, this.graph.getIncomingSequenceFlows(node).iterator().next(), node, flown, Construct.Sequence, false);
                return this.graph.getNode(this.graph.getOutgoingSequenceFlows(node).iterator().next().getTarget().getId());
            }
            case While: {
                FlowNode nextNode = null;
                XMLElement whil = (XMLElement)this.processExporter.elementExporting(node, "While").getXMLNotation();
                whil.setAttribute(Name, node.getName());
                container.appendChild((Node)whil);
                Sequence<SequenceFlow> cxns = this.graph.getOutgoingSequenceFlows(node);
                String condition = null;
                for (SequenceFlow sequenceFlow : cxns) {
                    if (!sequenceFlow.isConditionalFlow() || (condition = sequenceFlow.asConditionalFlow().getCondition().getExpressionValue()) == null) continue;
                    condition = condition.replaceAll("bpmn:getDataObject", "bpws:getVariableData");
                }
                for (SequenceFlow sequenceFlow : cxns) {
                    if (!sequenceFlow.equals(bound)) continue;
                    if (sequenceFlow.isConditionalFlow()) {
                        whil.setAttribute("condition", condition);
                        continue;
                    }
                    whil.setAttribute("condition", "!(" + condition + ")");
                }
                for (SequenceFlow sequenceFlow1 : cxns) {
                    if (sequenceFlow1.equals(bound)) {
                        this.generate(sequenceFlow1.getTarget(), sequenceFlow1, node, whil, Construct.Sequence, true);
                        continue;
                    }
                    nextNode = sequenceFlow1.getTarget();
                }
                return nextNode;
            }
            case Switch: {
                XMLElement branch;
                XMLElement swit = (XMLElement)this.decoration.document.createElement("switch");
                swit.setAttribute(Name, node.getName());
                swit.appendChild((Node)this.processExporter.elementExporting(node, "Switch").getXMLNotation());
                container.appendChild((Node)swit);
                Sequence<SequenceFlow> sequenceFlows = this.graph.getOutgoingSequenceFlows(node);
                for (SequenceFlow sequenceFlow : sequenceFlows) {
                    branch = null;
                    if (!sequenceFlow.isConditionalFlow()) continue;
                    branch = (XMLElement)this.processExporter.elementExporting(sequenceFlow, "Case").getXMLNotation();
                    swit.appendChild((Node)branch);
                    this.generate(sequenceFlow.getTarget(), sequenceFlow, bound, branch, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                }
                for (SequenceFlow sequenceFlow : sequenceFlows) {
                    branch = null;
                    if (sequenceFlow.isConditionalFlow()) continue;
                    branch = (XMLElement)this.processExporter.elementExporting(sequenceFlow, "Otherwise").getXMLNotation();
                    swit.appendChild((Node)branch);
                    this.generate(sequenceFlow.getTarget(), sequenceFlow, bound, branch, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                }
                if (((FlowNode)bound).isEvent() && ((FlowNode)bound).getBpmnType().equals((Object)BpmnType.END_EVENT)) {
                    return null;
                }
                return (FlowNode)bound;
            }
            case OR: {
                XMLElement flow = (XMLElement)this.decoration.document.createElement("flow");
                flow.setAttribute(Name, node.getName());
                flow.appendChild((Node)this.processExporter.elementExporting(node, "Flow").getXMLNotation());
                container.appendChild((Node)flow);
                String defCondition = null;
                XMLElement defBranch = null;
                Sequence<SequenceFlow> sequenceFlows = this.graph.getOutgoingSequenceFlows(node);
                for (SequenceFlow sequenceFlow : sequenceFlows) {
                    XMLElement branch = (XMLElement)this.decoration.document.createElement("sequence");
                    branch.appendChild((Node)this.processExporter.elementExporting(sequenceFlow, "Sequence").getXMLNotation());
                    flow.appendChild((Node)branch);
                    XMLElement swit = (XMLElement)this.decoration.document.createElement("switch");
                    ExclusiveGateway dummyGateway = this.process.createExclusiveGateway();
                    dummyGateway.setId(sequenceFlow.getId());
                    swit.appendChild((Node)this.processExporter.elementExporting((FlowNode)dummyGateway, "Switch").getXMLNotation());
                    branch.appendChild((Node)swit);
                    SequenceFlow dummyMainConnection = this.process.createSequenceFlow(node, null);
                    if (sequenceFlow.isConditionalFlow()) {
                        dummyMainConnection.toConditionalFlow().setCondition(sequenceFlow.toConditionalFlow().getCondition());
                        defCondition = defCondition == null ? "!(" + sequenceFlow.toConditionalFlow().getCondition().getExpressionValue() + ")" : defCondition + "&& !(" + sequenceFlow.toConditionalFlow().getCondition().getExpressionValue() + ")";
                    }
                    dummyMainConnection.setId("Main_" + sequenceFlow.getId());
                    XMLElement mainCase = (XMLElement)this.processExporter.elementExporting(dummyMainConnection, "Case").getXMLNotation();
                    swit.appendChild((Node)mainCase);
                    if (!sequenceFlow.isConditionalFlow()) {
                        defBranch = mainCase;
                    }
                    this.generate(this.graph.getNode(sequenceFlow.getTarget().getId()), dummyMainConnection, bound, mainCase, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                    SequenceFlow dummyEmptyConnection = this.process.createSequenceFlow(node, null);
                    dummyEmptyConnection.setId("Def_" + sequenceFlow.getId());
                    XMLElement emptyCase = (XMLElement)this.processExporter.elementExporting(dummyEmptyConnection, "Otherwise").getXMLNotation();
                    swit.appendChild((Node)emptyCase);
                    XMLElement emptySequence = (XMLElement)this.decoration.document.createElement("sequence");
                    emptySequence.appendChild((Node)this.processExporter.elementExporting(dummyEmptyConnection, "Sequence").getXMLNotation());
                    emptyCase.appendChild((Node)emptySequence);
                    SendTask dummyEmpty = this.process.createActivity().toSendTask();
                    dummyEmpty.setDefaultLabel("Empty");
                    dummyEmpty.setId(sequenceFlow.getId());
                    XMLElement empty = (XMLElement)this.processExporter.elementExporting((FlowNode)dummyEmpty, "Empty").getXMLNotation();
                    emptySequence.appendChild((Node)empty);
                }
                if (defBranch != null) {
                    defBranch.setAttribute("condition", defCondition);
                }
                if (((FlowNode)bound).isEvent() && ((FlowNode)bound).getBpmnType().equals((Object)BpmnType.END_EVENT)) {
                    return null;
                }
                return (FlowNode)bound;
            }
            case Flow: {
                XMLElement flow = (XMLElement)this.decoration.document.createElement("flow");
                flow.setAttribute(Name, node.getName());
                SendTask dummyFlow = this.process.createActivity().toSendTask();
                dummyFlow.setDefaultLabel(node.getName());
                dummyFlow.setId(node.getId());
                flow.appendChild((Node)this.processExporter.elementExporting((FlowNode)dummyFlow, "Flow").getXMLNotation());
                container.appendChild((Node)flow);
                Sequence<SequenceFlow> sequenceFlows = this.graph.getOutgoingSequenceFlows(node);
                for (SequenceFlow sequenceFlow : sequenceFlows) {
                    this.generate(this.graph.getNode(sequenceFlow.getTarget().getId()), sequenceFlow, bound, flow, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                }
                if (((FlowNode)bound).isEvent() && ((FlowNode)bound).getBpmnType().equals((Object)BpmnType.END_EVENT)) {
                    return null;
                }
                return (FlowNode)bound;
            }
            case Pick: {
                XMLElement pick = (XMLElement)this.decoration.document.createElement("pick");
                pick.setAttribute(Name, node.getName());
                pick.appendChild((Node)this.processExporter.elementExporting(node, "Pick").getXMLNotation());
                container.appendChild((Node)pick);
                Sequence<SequenceFlow> sequenceFlows = this.graph.getOutgoingSequenceFlows(node);
                for (SequenceFlow sequenceFlow : sequenceFlows) {
                    XMLElement branch = null;
                    Event event = null;
                    if (sequenceFlow.getTarget().isEvent()) {
                        event = (Event)sequenceFlow.getTarget();
                        if (event.getEventTriggerType().equals((Object)EventTriggerType.NONE) || event.getEventTriggerType().equals((Object)EventTriggerType.MESSAGE) || event.getEventTriggerType().equals((Object)EventTriggerType.LINK)) {
                            branch = (XMLElement)this.decoration.document.createElement("onMessage");
                            branch.setAttribute(Name, event.getDefaultLabel());
                            branch.appendChild((Node)this.processExporter.elementExporting((FlowNode)event, "OnMessage").getXMLNotation());
                        } else if (event.getEventTriggerType().equals((Object)EventTriggerType.TIMER)) {
                            branch = (XMLElement)this.decoration.document.createElement("onAlarm");
                            branch.appendChild((Node)this.processExporter.elementExporting((FlowNode)event, "OnAlarm").getXMLNotation());
                        }
                    }
                    if (sequenceFlow.getTarget().isActivity()) {
                        event = (oracle.bpm.project.model.processes.Activity)sequenceFlow.getTarget();
                        branch = (XMLElement)this.decoration.document.createElement("onMessage");
                        branch.appendChild((Node)this.processExporter.elementExporting((FlowNode)event, "OnMessage").getXMLNotation());
                    }
                    if (branch == null) continue;
                    pick.appendChild(branch);
                    if (!this.graph.getOutgoingSequenceFlows((FlowNode)event).iterator().hasNext()) continue;
                    this.generate(this.graph.getNode(this.graph.getOutgoingSequenceFlows((FlowNode)event).iterator().next().getTarget().getId()), this.graph.getOutgoingSequenceFlows((FlowNode)event).iterator().next(), bound, branch, Construct.Sequence, !this.graph.isEnd((FlowNode)bound));
                }
                if (((FlowNode)bound).isEvent() && ((FlowNode)bound).getBpmnType().equals((Object)BpmnType.END_EVENT)) {
                    return null;
                }
                return (FlowNode)bound;
            }
        }
        return null;
    }

    private void transform(FlowNode node, XMLElement container) throws Exception {
        XMLElement element = null;
        XMLElement element1 = null;
        this.log("Creating " + node.toString());
        boolean variableCreationAndAssignRequired = true;
        if (node.isEvent()) {
            Event event = (Event)node;
            if (!this.isSub && event.isStart() && (event.getEventTriggerType().equals((Object)EventTriggerType.MESSAGE) || event.getEventTriggerType().equals((Object)EventTriggerType.LINK))) {
                element = (XMLElement)this.processExporter.elementExporting(node, "Receive").getXMLNotation();
            }
            if (event.isIntermediate()) {
                if (event.getEventTriggerType().equals((Object)EventTriggerType.MESSAGE)) {
                    element = event.getBpmnType().equals((Object)BpmnType.THROW_INTERMEDIATE_EVENT) ? (XMLElement)this.processExporter.elementExporting(node, "Invoke").getXMLNotation() : (XMLElement)this.processExporter.elementExporting(node, "Receive").getXMLNotation();
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.TIMER)) {
                    element = (XMLElement)this.decoration.document.createElement("wait");
                    element.setAttribute(Name, node.getName());
                    element.appendChild((Node)this.processExporter.elementExporting(node, "Wait").getXMLNotation());
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.ERROR)) {
                    element = (XMLElement)this.decoration.document.createElement("throw");
                    element.setAttribute(Name, node.getName());
                    element.appendChild((Node)this.processExporter.elementExporting(node, "Throw").getXMLNotation());
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.COMPENSATION)) {
                    element = (XMLElement)this.decoration.document.createElement("compensate");
                    element.setAttribute(Name, node.getName());
                    element.appendChild((Node)this.processExporter.elementExporting(node, "Compensate").getXMLNotation());
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.LINK)) {
                    element = (XMLElement)this.processExporter.elementExporting(node, "Invoke").getXMLNotation();
                }
            }
            if (event.isEnd()) {
                if (event.getEventTriggerType().equals((Object)EventTriggerType.MESSAGE)) {
                    if (((MessageEventDefinition)event.getEventDefinition().as(MessageEventDefinition.class)).returnsErrors()) {
                        element = (XMLElement)this.decoration.document.createElement("throw");
                        element.setAttribute(Name, node.getName());
                        element.setAttribute("faultName", node.getName());
                        element.setAttribute("faultVariable", ((MessageEventDefinition)event.getEventDefinition().as(MessageEventDefinition.class)).getErrorEventDefinition().getErrorCode());
                        element1 = (XMLElement)this.processExporter.elementExporting(node, "Throw").getXMLNotation();
                        element.appendChild((Node)element1);
                    } else if (!this.isSub) {
                        element = this.isSynchronous(this.process, event) ? (XMLElement)this.processExporter.elementExporting(node, "Reply").getXMLNotation() : (XMLElement)this.processExporter.elementExporting(node, "Invoke").getXMLNotation();
                    }
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.COMPENSATION)) {
                    if (!this.isSub) {
                        element = (XMLElement)this.decoration.document.createElement("compensate");
                        element.setAttribute(Name, node.getName());
                        element.appendChild((Node)this.processExporter.elementExporting(node, "Compensate").getXMLNotation());
                    }
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.LINK)) {
                    if (!this.isSub) {
                        element = (XMLElement)this.processExporter.elementExporting(node, "Invoke").getXMLNotation();
                    }
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.ERROR)) {
                    element1 = (XMLElement)this.processExporter.elementExporting(node, "Throw").getXMLNotation();
                    element = (XMLElement)this.decoration.document.createElement("throw");
                    element.setAttribute(Name, node.getName());
                    if (((ErrorEventDefinition)event.getEventDefinition().as(ErrorEventDefinition.class)).getError() != null) {
                        element.setAttribute("faultName", ((ErrorEventDefinition)event.getEventDefinition().as(ErrorEventDefinition.class)).getError().getErrorCode().getLocalPart());
                    } else {
                        element.setAttribute("faultName", node.getName());
                    }
                    element.setAttribute("faultVariable", (String)((ErrorEventDefinition)event.getEventDefinition().as(ErrorEventDefinition.class)).getError().getErrorInfoAttributes().keySet().iterator().next());
                    element.appendChild((Node)element1);
                } else if (event.getEventTriggerType().equals((Object)EventTriggerType.TERMINATE)) {
                    element = (XMLElement)this.decoration.document.createElement("terminate");
                    element.setAttribute(Name, node.getName());
                    element.appendChild((Node)this.processExporter.elementExporting(node, "Terminate").getXMLNotation());
                }
            }
        }
        if (node.isActivity()) {
            BPELWriter bpelWriter;
            Subprocess process;
            oracle.bpm.project.model.processes.Activity task = (oracle.bpm.project.model.processes.Activity)node;
            if (task.getBpmnType().equals((Object)BpmnType.ABSTRACT_ACTIVITY)) {
                element = (XMLElement)this.processExporter.elementExporting(node, "Empty").getXMLNotation();
            } else if (task.getBpmnType().equals((Object)BpmnType.MANUAL_TASK)) {
                element = (XMLElement)this.processExporter.elementExporting(node, "Empty").getXMLNotation();
            } else if (task.getBpmnType().equals((Object)BpmnType.SERVICE_TASK)) {
                if (task.toServiceTask().getParticipant() == null) {
                    variableCreationAndAssignRequired = false;
                    this.log("Warning: Service task " + task.getId() + " is not implemented. Conversion will be incomplete.");
                }
                element = (XMLElement)this.processExporter.elementExporting(node, "Invoke").getXMLNotation();
            } else if (task.getBpmnType().equals((Object)BpmnType.SCRIPT_TASK)) {
                element = (XMLElement)this.processExporter.elementExporting(node, "script").getXMLNotation();
            } else if (task.getBpmnType().equals((Object)BpmnType.SEND_TASK)) {
                if (task.toSendTask().getParticipant() == null) {
                    variableCreationAndAssignRequired = false;
                    this.log("Warning: Service task " + task.getId() + " is not implemented. Conversion will be incomplete.");
                }
                element = (XMLElement)this.processExporter.elementExporting(node, "Invoke").getXMLNotation();
            } else if (task.getBpmnType().equals((Object)BpmnType.USER_TASK)) {
                if (task.toUserTask().isManualStart()) {
                    throw new Exception("Conversion of processes having initiator user task, to BPEL is not supported");
                }
                if (task.toUserTask().getHumanTask() != null) {
                    element = (XMLElement)this.processExporter.elementExporting(node, "HumanTask").getXMLNotation();
                } else {
                    this.log("Warning: User Task " + task.getId() + " is not implemented. Converting to BPEL Empty");
                    element = (XMLElement)this.processExporter.elementExporting(node, "Empty").getXMLNotation();
                    variableCreationAndAssignRequired = false;
                }
            } else if (task.getBpmnType().equals((Object)BpmnType.BUSINESS_RULE_TASK)) {
                if (task.toBusinessRuleTask().getBusinessRule() != null) {
                    element = (XMLElement)this.processExporter.elementExporting(node, "DecisionService").getXMLNotation();
                } else {
                    this.log("Warning: Business Rule Task " + task.getId() + " is not implemented. Converting to BPEL Empty.");
                    element = (XMLElement)this.processExporter.elementExporting(node, "Empty").getXMLNotation();
                    variableCreationAndAssignRequired = false;
                }
            } else if (task.getBpmnType().equals((Object)BpmnType.RECEIVE_TASK)) {
                if (task.toReceiveTask().getParticipant() == null) {
                    variableCreationAndAssignRequired = false;
                    this.log("Warning: Receive task " + task.getId() + " is not implemented. Conversion will be incomplete.");
                }
                element = (XMLElement)this.processExporter.elementExporting(node, "Receive").getXMLNotation();
            }
            if (this.isSub && (task.isSubprocess() || task.isCallActivity())) {
                throw new Exception("Processes with more than one level of callable or embedded subprocesses can not be currently transformed to bpel");
            }
            if (task.isSubprocess()) {
                process = (Subprocess)task;
                bpelWriter = new BPELWriter(this.zipStream, this.subpExp, this.context.getLocale(), this.projectDirectory);
                element = (XMLElement)bpelWriter.parse((NodeContainer)process, this.decoration.document, this.exporter, this.processExporter);
                this.processExporter.setProcessContext(this.graph);
            }
            if (task.isCallActivity()) {
                process = ((CallActivity)task).getCalledElement();
                if (process == null) {
                    this.log("Warning:CallActivity is unimplemented. Converting to Empty Bpel.");
                    element = (XMLElement)this.processExporter.elementExporting(node, "Empty").getXMLNotation();
                    variableCreationAndAssignRequired = false;
                } else {
                    bpelWriter = new BPELWriter(this.zipStream, this.subpExp, this.context.getLocale(), this.projectDirectory);
                    element = (XMLElement)bpelWriter.parse((NodeContainer)process, this.decoration.document, this.exporter, this.processExporter);
                    this.processExporter.setProcessContext(this.graph);
                }
            }
        }
        if (element == null) {
            return;
        }
        container.appendChild(element);
        if (element != null && variableCreationAndAssignRequired) {
            if (element1 != null) {
                this.createVariableAndAssign(node, element1, container);
            } else {
                this.createVariableAndAssign(node, element, container);
            }
        }
        this.counter.addCount(node);
        this.transformedNodes.put(node, element);
    }

    private String getVariablePart(String text) {
        return text.indexOf(".") > 0 ? text.substring(0, text.indexOf(".")) : text;
    }

    private String getExpressionPart(String text) {
        String variableName = this.getVariablePart(text);
        String schema = null;
        if (this.schemaType.get(variableName) != null) {
            schema = this.schemaType.get(variableName).getName();
        }
        if (schema == null) {
            return null;
        }
        text = text.substring(text.indexOf(".") + 1);
        String ns = "/" + variableName + ":";
        String query = ns + schema;
        while (text.indexOf(".") > 0) {
            query = query + ns + text.substring(0, text.indexOf("."));
            text = text.substring(text.indexOf(".") + 1);
        }
        if (!text.equals(variableName) && !text.equals(schema)) {
            query = query + ns + text;
        }
        return query;
    }

    private String getSchemaPart(String text) {
        String variableName = this.getVariablePart(text);
        String schema = null;
        if (this.schemaType.get(variableName) != null) {
            schema = this.schemaType.get(variableName).getName();
        }
        if (schema == null) {
            return null;
        }
        return schema;
    }

    private void createPartnerLinkAndVariable(CatchEvent ce, XMLElement scope, XMLElement onMessage) throws Exception {
        XMLElement variables = scope.getChildrenByTagName("variables").getLength() > 0 ? (XMLElement)onMessage.getChildrenByTagName("variables").item(0) : (XMLElement)this.decoration.document.createElement("variables");
        OperationReference operationRef = ce.getOperationRef();
        ParticipantReference participantRef = ce.getParticipantRef();
        PartnerLink partnerLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        Element ele = partnerLink.createDOMElement((Document)this.decoration.document, "", true);
        partnerLink.setName(participantRef.getId());
        onMessage.setAttribute("partnerLink", partnerLink.getName());
        QName portType = null;
        if (operationRef != null) {
            portType = operationRef.getPortType();
        }
        BpelProcessExportActionImpl bpelProcessExportAction = ((BpelProcessExportImpl)this.processExporter).getBpelProcessExportAction();
        if (portType != null && !portType.getLocalPart().endsWith("Callback")) {
            File serviceWsdl;
            SchemaObject schemaObject = ce.getParticipant().getDelegate().asSchemaObject();
            URL url = null;
            if (schemaObject.getResourceLocation() != null) {
                VFile file = schemaObject.getResourceLocation();
                VFileSystem fs = file.getFileSystem();
                url = ((JavaFileSystem)fs).toJavaFile(file).toURI().toURL();
            }
            if (schemaObject.getName() != null && (serviceWsdl = new File(this.projectDirectory.getAbsolutePath(), schemaObject.getName() + ".wsdl")).exists()) {
                url = serviceWsdl.toURI().toURL();
            }
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            Definition wsdlInstance = reader.readWSDL(null, url.toURI().toString());
            XMLDocument wsdlDoc = new XMLDocument();
            PartnerLinkType plType = null;
            Map map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)wsdlInstance);
            boolean found = false;
            if (!map.isEmpty()) {
                for (Object obj : map.keySet()) {
                    plType = (PartnerLinkType)map.get(obj);
                    found = false;
                    if (plType == null) continue;
                    Map roles = plType.getRoles();
                    for (Object obj2 : roles.keySet()) {
                        Role role = (Role)roles.get(obj2);
                        if (!role.getPortType().getQName().equals(portType)) continue;
                        found = true;
                        partnerLink.setPartnerRole(role.getName());
                        if (operationRef.getInputType() != null) {
                            partnerLink.setPartnerLinkType(new QName("", plType.getQName().getLocalPart(), operationRef.getInputType().getLocalPart()));
                            continue;
                        }
                        partnerLink.setPartnerLinkType(plType.getQName());
                    }
                }
            }
            bpelProcessExportAction.addToPartnerLinks(partnerLink.getDOMElement());
            bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)participantRef.getId()), new URI(portType.getNamespaceURI()));
            String portTypeValue = participantRef.getId() + ":" + portType.getLocalPart();
            onMessage.setAttribute("portType", portTypeValue);
        }
        Variable variable = (Variable)BPELParser.createImplementation(Variable.class);
        variable.createDOMElement((Document)this.decoration.document, "", true);
        if (operationRef.getInputType() != null) {
            String varName = "in_" + ce.getName();
            variable.setName(varName);
            variable.setMessageType(new QName("", operationRef.getInputType().getLocalPart(), operationRef.getInputType().getLocalPart()));
            bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)operationRef.getInputType().getLocalPart()), new URI(operationRef.getInputType().getNamespaceURI()));
            variables.appendChild((Node)((XMLElement)variable.getDOMElement()));
            onMessage.setAttribute("variable", varName);
        }
        variable = (Variable)BPELParser.createImplementation(Variable.class);
        variable.createDOMElement((Document)this.decoration.document, "", true);
        if (operationRef.getOutputType() != null) {
            variable.setName("out");
            variable.setMessageType(new QName("", operationRef.getOutputType().getLocalPart(), operationRef.getOutputType().getLocalPart()));
            bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)operationRef.getOutputType().getLocalPart()), new URI(operationRef.getOutputType().getNamespaceURI()));
            variables.appendChild((Node)((XMLElement)variable.getDOMElement()));
        }
        if (variables.getChildrenByTagName("variable").getLength() > 0) {
            XMLElement pos = (XMLElement)scope.getFirstChild();
            if (pos != null) {
                pos = (XMLElement)pos.getNextSibling();
            }
            scope.insertBefore((Node)variables, (Node)pos);
        }
    }

    private void createVariableAndAssign(FlowNode node, XMLElement element, XMLElement container) throws Exception {
        To to;
        From from;
        Copy copy;
        Assign assign;
        String payload;
        DataAssociationSet associationSet;
        InputDataAssociationEnabled input;
        XMLElement variables = element.getChildrenByTagName("variables").getLength() > 0 ? (XMLElement)element.getChildrenByTagName("variables").item(0) : (XMLElement)this.decoration.document.createElement("variables");
        BpelProcessExportActionImpl bpelProcessExportAction = ((BpelProcessExportImpl)this.processExporter).getBpelProcessExportAction();
        XMLElement sequence = (XMLElement)element.getChildrenByTagName("sequence").item(0);
        System.out.println("element is " + element.toString());
        System.out.println("element child is " + element.getFirstChild().getNodeName());
        System.out.println("element sequence length " + element.getChildrenByTagName("sequence").getLength());
        System.out.println("sequence is" + sequence.getFirstChild());
        if ((!node.isActivity() || !((oracle.bpm.project.model.processes.Activity)node).isBusinessRuleTask()) && (node.isEvent() || node.isActivity() && (((oracle.bpm.project.model.processes.Activity)node).isSendTask() || ((oracle.bpm.project.model.processes.Activity)node).isReceiveTask() || ((oracle.bpm.project.model.processes.Activity)node).isServiceTask()))) {
            Variable variable;
            Role role;
            Map roles;
            boolean found;
            Map map;
            PartnerLinkType plType;
            XMLDocument wsdlDoc;
            Definition wsdlInstance;
            WSDLReader reader;
            WSDLFactory factory;
            File serviceWsdl;
            VFileSystem fs;
            VFile file;
            URL url;
            ServiceObject serviceObject;
            SchemaObject schemaObject;
            Element ele;
            PartnerLink partnerLink;
            ParticipantReference participantRef;
            QName portType;
            OperationReference operationRef;
            ParticipantEnabled participantEnabled;
            if (node.isActivity() && (participantEnabled = (ParticipantEnabled)node).getOperationRef() != null && participantEnabled.getParticipantRef() != null) {
                operationRef = participantEnabled.getOperationRef();
                portType = null;
                try {
                    portType = operationRef.getPortType();
                }
                catch (Exception e) {
                    // empty catch block
                }
                participantRef = participantEnabled.getParticipantRef();
                partnerLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
                ele = partnerLink.createDOMElement((Document)this.decoration.document, "", true);
                partnerLink.setName(participantRef.getId());
                if (this.projectDirectory != null && portType != null && !portType.getLocalPart().endsWith("Callback") && participantEnabled.getParticipant() != null) {
                    schemaObject = participantEnabled.getParticipant().getDelegate().asSchemaObject();
                    serviceObject = participantEnabled.getParticipant().getDelegate().asServiceObject();
                    url = null;
                    if (schemaObject.getResourceLocation() != null) {
                        file = schemaObject.getResourceLocation();
                        fs = file.getFileSystem();
                        url = ((JavaFileSystem)fs).toJavaFile(file).toURI().toURL();
                    }
                    if (schemaObject.getName() != null && (serviceWsdl = new File(this.projectDirectory.getAbsolutePath(), serviceObject.getServiceLocation())).exists()) {
                        url = serviceWsdl.toURI().toURL();
                    }
                    if (url != null) {
                        factory = WSDLFactory.newInstance();
                        reader = factory.newWSDLReader();
                        wsdlInstance = reader.readWSDL(null, url.toURI().toString());
                        wsdlDoc = new XMLDocument();
                        plType = null;
                        map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)wsdlInstance);
                        found = false;
                        if (!map.isEmpty()) {
                            for (Object obj : map.keySet()) {
                                plType = (PartnerLinkType)map.get(obj);
                                found = false;
                                if (plType == null) continue;
                                roles = plType.getRoles();
                                for (Object obj2 : roles.keySet()) {
                                    role = (Role)roles.get(obj2);
                                    if (!role.getPortType().getQName().equals(portType)) continue;
                                    found = true;
                                    partnerLink.setPartnerRole(role.getName());
                                    partnerLink.setPartnerLinkType(new QName("", plType.getQName().getLocalPart(), participantRef.getId()));
                                    bpelProcessExportAction.addToPartnerLinks(partnerLink.getDOMElement());
                                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)participantRef.getId()), new URI(portType.getNamespaceURI()));
                                }
                            }
                        } else {
                            PartnerLinkWSDLUtil.addPLTypesIntoWSDL((String)url.toURI().toString(), null);
                        }
                    }
                }
                if (partnerLink.getPartnerLinkType() == null && portType != null && !portType.getLocalPart().endsWith("Callback")) {
                    partnerLink.setPartnerRole(portType.getLocalPart() + "_role");
                    partnerLink.setPartnerLinkType(new QName("", portType.getLocalPart() + "_PL", operationRef.getInputType().getLocalPart()));
                    bpelProcessExportAction.addToPartnerLinks(partnerLink.getDOMElement());
                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)participantRef.getId()), new URI(portType.getNamespaceURI()));
                }
                variable = (Variable)BPELParser.createImplementation(Variable.class);
                variable.createDOMElement((Document)this.decoration.document, "", true);
                if (operationRef.getInputType() != null) {
                    String varName = "in";
                    oracle.bpm.project.model.processes.Activity act = (oracle.bpm.project.model.processes.Activity)node.asAnyNode(oracle.bpm.project.model.processes.Activity.class);
                    if (act.isReceiveTask()) {
                        varName = "out";
                    }
                    variable.setName(varName);
                    variable.setMessageType(new QName("", operationRef.getInputType().getLocalPart(), operationRef.getInputType().getLocalPart()));
                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)operationRef.getInputType().getLocalPart()), new URI(operationRef.getInputType().getNamespaceURI()));
                    variables.appendChild((Node)((XMLElement)variable.getDOMElement()));
                }
                variable = (Variable)BPELParser.createImplementation(Variable.class);
                variable.createDOMElement((Document)this.decoration.document, "", true);
                if (operationRef.getOutputType() != null) {
                    variable.setName("out");
                    variable.setMessageType(new QName("", operationRef.getOutputType().getLocalPart(), operationRef.getOutputType().getLocalPart()));
                    bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)operationRef.getOutputType().getLocalPart()), new URI(operationRef.getOutputType().getNamespaceURI()));
                    variables.appendChild((Node)((XMLElement)variable.getDOMElement()));
                }
            }
            if (node.isEvent()) {
                if (((Event)node).isCatchEvent()) {
                    ConversationEnabled conversationEnabled = (ConversationEnabled)node;
                    if (conversationEnabled.getOperationRef() != null && conversationEnabled.getParticipantRef() != null) {
                        operationRef = conversationEnabled.getOperationRef();
                        portType = null;
                        try {
                            portType = operationRef.getPortType();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        participantRef = conversationEnabled.getParticipantRef();
                        partnerLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
                        ele = partnerLink.createDOMElement((Document)this.decoration.document, "", true);
                        partnerLink.setName(participantRef.getId());
                        if (this.projectDirectory != null && portType != null && conversationEnabled.getParticipant() != null) {
                            schemaObject = conversationEnabled.getParticipant().getDelegate().asSchemaObject();
                            serviceObject = conversationEnabled.getParticipant().getDelegate().asServiceObject();
                            url = null;
                            if (schemaObject.getResourceLocation() != null) {
                                file = schemaObject.getResourceLocation();
                                fs = file.getFileSystem();
                                url = ((JavaFileSystem)fs).toJavaFile(file).toURI().toURL();
                            }
                            if (schemaObject.getName() != null && (serviceWsdl = new File(this.projectDirectory.getAbsolutePath(), serviceObject.getServiceLocation())).exists()) {
                                url = serviceWsdl.toURI().toURL();
                            }
                            if (url != null) {
                                factory = WSDLFactory.newInstance();
                                reader = factory.newWSDLReader();
                                wsdlInstance = reader.readWSDL(null, url.toURI().toString());
                                wsdlDoc = new XMLDocument();
                                plType = null;
                                map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)wsdlInstance);
                                found = false;
                                if (!map.isEmpty()) {
                                    for (Object obj : map.keySet()) {
                                        plType = (PartnerLinkType)map.get(obj);
                                        found = false;
                                        if (plType == null) continue;
                                        roles = plType.getRoles();
                                        for (Object obj2 : roles.keySet()) {
                                            role = (Role)roles.get(obj2);
                                            if (!role.getPortType().getQName().equals(portType)) continue;
                                            found = true;
                                            partnerLink.setMyRole(role.getName());
                                            partnerLink.setPartnerLinkType(new QName("", plType.getQName().getLocalPart(), participantRef.getId()));
                                            bpelProcessExportAction.addToPartnerLinks(partnerLink.getDOMElement());
                                            bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)participantRef.getId()), new URI(portType.getNamespaceURI()));
                                        }
                                    }
                                } else {
                                    PartnerLinkWSDLUtil.addPLTypesIntoWSDL((String)url.toURI().toString(), null);
                                }
                            }
                        }
                        variable = (Variable)BPELParser.createImplementation(Variable.class);
                        variable.createDOMElement((Document)this.decoration.document, "", true);
                        variable.setName("out");
                        if (operationRef.getInputType() != null) {
                            if (operationRef.getInputType().getLocalPart().equals(node.getId() + "Request")) {
                                variable.setMessageType(new QName("", operationRef.getInputType().getLocalPart(), "client"));
                            } else {
                                variable.setMessageType(new QName("", operationRef.getInputType().getLocalPart(), operationRef.getInputType().getLocalPart()));
                                bpelProcessExportAction.addToNamespaces(ConstantsUtil.addNamespacePrefix((String)operationRef.getInputType().getLocalPart()), new URI(operationRef.getInputType().getNamespaceURI()));
                            }
                        } else {
                            variable.setMessageType(new QName("", node.getId() + "Request", "client"));
                        }
                        variables.appendChild((Node)((XMLElement)variable.getDOMElement()));
                    } else {
                        Variable variable2 = (Variable)BPELParser.createImplementation(Variable.class);
                        variable2.createDOMElement((Document)this.decoration.document, "", true);
                        variable2.setName("out");
                        variable2.setMessageType(new QName("", node.getId() + "Request", "client"));
                        variables.appendChild((Node)((XMLElement)variable2.getDOMElement()));
                    }
                }
                if (((Event)node).isThrowEvent()) {
                    Variable variable3 = (Variable)BPELParser.createImplementation(Variable.class);
                    variable3.createDOMElement((Document)this.decoration.document, "", true);
                    variable3.setName("in");
                    if (((ThrowEvent)node).isSync()) {
                        variable3.setMessageType(new QName("", this.graph.getStart().getId() + "Response", "client"));
                    } else {
                        variable3.setMessageType(new QName("", node.getId() + "Response", "client"));
                    }
                    variables.appendChild((Node)((XMLElement)variable3.getDOMElement()));
                }
            }
        }
        if (variables.getChildrenByTagName("variable").getLength() > 0) {
            element.insertBefore((Node)variables, element.getLastChild());
        }
        if (node.isEvent() && ((Event)node).isThrowEvent() || node.isActivity() && (((oracle.bpm.project.model.processes.Activity)node).isServiceTask() || ((oracle.bpm.project.model.processes.Activity)node).isSendTask())) {
            input = (InputDataAssociationEnabled)node;
            associationSet = input.getInputDataAssociationSet();
            payload = "payload";
            if (node.isEvent() && ((Event)node).isThrowEvent() && ((ThrowEvent)node).getInputDataAssociationSet() != null && ((ThrowEvent)node).getInputDataAssociationSet().getArguments().toArray().length > 0) {
                payload = ((DataDeclaration)((ThrowEvent)node).getInputDataAssociationSet().getArguments().toArray()[0]).getName();
            }
            if (associationSet != null) {
                assign = (Assign)BPELParser.createImplementation(Assign.class);
                assign.createDOMElement((Document)this.decoration.document, "", true);
                assign.setName("");
                for (DataAssociation association : associationSet.getDataAssociations()) {
                    CatalogArgument arg1;
                    copy = (Copy)BPELParser.createImplementation(Copy.class);
                    copy.createDOMElement((Document)this.decoration.document, "", true);
                    from = (From)BPELParser.createImplementation(From.class);
                    from.createDOMElement((Document)this.decoration.document, "", true);
                    if (association.getSource().getText().contains("\"") || association.getSource().getText().contains("'") || Character.isDigit(association.getSource().getText().charAt(0))) {
                        from.setExpression(association.getSource().getText().replaceAll("bpmn:getDataObject", "bpws:getVariableData"));
                    } else {
                        from.setVariable(this.getVariablePart(association.getSource().getText()));
                        if (this.getExpressionPart(association.getSource().getText()) != null) {
                            from.setQuery(this.getExpressionPart(association.getSource().getText().replaceAll("bpmn:getDataObject", "bpws:getVariableData")));
                        }
                    }
                    copy.setFrom(from);
                    to = (To)BPELParser.createImplementation(To.class);
                    to.createDOMElement((Document)this.decoration.document, "", true);
                    to.setVariable("in");
                    if (((oracle.bpm.project.model.processes.Activity)node).isServiceTask() && ((oracle.bpm.project.model.processes.Activity)node).toServiceTask().getOperation() != null && (arg1 = ((oracle.bpm.project.model.processes.Activity)node).toServiceTask().getOperation().findArgument(this.getVariablePart(association.getTarget().getText()))) != null) {
                        System.out.println("arg 1 is " + arg1.getName());
                        String partName = arg1.getDelegateArgument().getProperty("partName");
                        System.out.println("part name " + partName);
                        payload = partName;
                    }
                    to.setPart(payload);
                    System.out.println("target text is " + association.getTarget().getText());
                    if (this.getExpressionPart(association.getTarget().getText()) != null) {
                        to.setQuery(this.getExpressionPart(association.getTarget().getText()));
                    }
                    copy.setTo(to);
                    assign.addCopyRule(copy);
                }
                if (assign.getCopyRules().size() > 0) {
                    sequence.insertBefore((Node)assign.getDOMElement(), sequence.getFirstChild());
                }
            }
        }
        if (node.isEvent() && ((Event)node).isCatchEvent() || node.isActivity() && ((oracle.bpm.project.model.processes.Activity)node).isServiceTask() || ((oracle.bpm.project.model.processes.Activity)node).isReceiveTask()) {
            OutputDataAssociationEnabled output = (OutputDataAssociationEnabled)node;
            associationSet = output.getOutputDataAssociationSet();
            payload = "payload";
            if (!node.isEvent() || !((Event)node).isCatchEvent() || ((CatchEvent)node).getOutputDataAssociationSet() == null || ((CatchEvent)node).getOutputDataAssociationSet().getArguments().toArray().length > 0) {
                // empty if block
            }
            if (associationSet != null) {
                assign = (Assign)BPELParser.createImplementation(Assign.class);
                assign.createDOMElement((Document)this.decoration.document, "", true);
                assign.setName("");
                for (DataAssociation association : associationSet.getDataAssociations()) {
                    copy = (Copy)BPELParser.createImplementation(Copy.class);
                    copy.createDOMElement((Document)this.decoration.document, "", true);
                    from = (From)BPELParser.createImplementation(From.class);
                    from.createDOMElement((Document)this.decoration.document, "", true);
                    from.setVariable("out");
                    if (node.isEvent() && ((Event)node).isCatchEvent() && ((CatchEvent)node).getOutputDataAssociationSet() != null && ((CatchEvent)node).getOutputDataAssociationSet().getArguments().toArray().length > 0) {
                        payload = association.getSource().getText();
                    }
                    from.setPart(payload);
                    if (this.getExpressionPart(association.getTarget().getText()) != null) {
                        from.setQuery(this.getExpressionPart(association.getTarget().getText()));
                    }
                    copy.setFrom(from);
                    to = (To)BPELParser.createImplementation(To.class);
                    to.createDOMElement((Document)this.decoration.document, "", true);
                    to.setVariable(this.getVariablePart(association.getTarget().getText()));
                    if (this.getExpressionPart(association.getTarget().getText()) != null) {
                        to.setQuery(this.getExpressionPart(association.getTarget().getText()));
                    }
                    copy.setTo(to);
                    assign.addCopyRule(copy);
                }
                if (assign.getCopyRules().size() > 0) {
                    sequence.appendChild((Node)assign.getDOMElement());
                }
            }
        }
        if (node.isActivity() && ((oracle.bpm.project.model.processes.Activity)node).isBusinessRuleTask()) {
            File decsWsdl;
            String decsWsdlName = ((oracle.bpm.project.model.processes.Activity)node).toBusinessRuleTask().getFunctionName() + ".wsdl";
            String ruleName = ((oracle.bpm.project.model.processes.Activity)node).toBusinessRuleTask().getBusinessRuleName();
            if (this.projectDirectory != null && (decsWsdl = new File(this.projectDirectory.getAbsolutePath(), decsWsdlName)).exists()) {
                String decsWsdlURI = decsWsdl.toURI().toString();
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader reader = factory.newWSDLReader();
                Definition wsdlInstance = reader.readWSDL(null, decsWsdlURI);
                XMLDocument wsdlDoc = new XMLDocument();
                Element elemPLNK = wsdlDoc.createElement("plnk:partnerLinkType");
                elemPLNK.setAttribute("name", "IDecisionService_PL");
                Element elemRole = wsdlDoc.createElement("plnk:role");
                elemRole.setAttribute("name", "IDecisionService_Role");
                Element elemPortType = wsdlDoc.createElement("plnk:portType");
                elemPortType.setAttribute("name", "tns:IDecisionService");
                elemRole.appendChild(elemPortType);
                elemPLNK.appendChild(elemRole);
                UnknownExtensibilityElement unElem = new UnknownExtensibilityElement();
                unElem.setElement(elemPLNK);
                unElem.setElementType(new QName("http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "partnerLinkType"));
                wsdlInstance.addExtensibilityElement((ExtensibilityElement)unElem);
                WSDLUtil.saveWSDLFile((URL)decsWsdl.toURL(), (Definition)wsdlInstance);
            }
            InputDataAssociationEnabled input2 = (InputDataAssociationEnabled)node;
            DataAssociationSet associationSet2 = input2.getInputDataAssociationSet();
            Assign varToFactsAssign = (Assign)BPELParser.createImplementation(Assign.class);
            varToFactsAssign.createDOMElement((Document)this.decoration.document, "", true);
            varToFactsAssign.setName("BPEL_Var_To_Rule_Facts");
            for (DataAssociation association : associationSet2.getDataAssociations()) {
                Copy copy2 = (Copy)BPELParser.createImplementation(Copy.class);
                copy2.createDOMElement((Document)this.decoration.document, "", true);
                From from2 = (From)BPELParser.createImplementation(From.class);
                from2.createDOMElement((Document)this.decoration.document, "", true);
                from2.setVariable(this.getVariablePart(association.getSource().getText()));
                if (this.getExpressionPart(association.getSource().getText()) != null) {
                    from2.setQuery(this.getExpressionPart(association.getSource().getText()));
                }
                copy2.setFrom(from2);
                To to2 = (To)BPELParser.createImplementation(To.class);
                to2.createDOMElement((Document)this.decoration.document, "", true);
                String realFact = this.getRealFactFromAlias(ruleName, this.getVariablePart(association.getTarget().getText()), true);
                to2.setVariable(realFact);
                if (this.getExpressionPart(association.getTarget().getText()) != null) {
                    to2.setQuery(this.getExpressionPart(association.getTarget().getText()));
                }
                copy2.setTo(to2);
                varToFactsAssign.addCopyRule(copy2);
            }
            varToFactsAssign.saveToDOMElement();
            try {
                sequence.insertBefore((Node)varToFactsAssign.getDOMElement(), sequence.getFirstChild());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            OutputDataAssociationEnabled output = (OutputDataAssociationEnabled)node;
            associationSet2 = output.getOutputDataAssociationSet();
            Assign factsToVarAssign = (Assign)BPELParser.createImplementation(Assign.class);
            factsToVarAssign.createDOMElement((Document)this.decoration.document, "", true);
            factsToVarAssign.setName("Facts_To_BPEL_Var");
            for (DataAssociation association : associationSet2.getDataAssociations()) {
                Copy copy3 = (Copy)BPELParser.createImplementation(Copy.class);
                copy3.createDOMElement((Document)this.decoration.document, "", true);
                From from3 = (From)BPELParser.createImplementation(From.class);
                from3.createDOMElement((Document)this.decoration.document, "", true);
                String factName = this.getRealFactFromAlias(ruleName, this.getVariablePart(association.getSource().getText()), false);
                from3.setVariable(factName);
                if (this.getExpressionPart(association.getSource().getText()) != null) {
                    from3.setQuery(this.getExpressionPart(association.getSource().getText()));
                }
                copy3.setFrom(from3);
                To to3 = (To)BPELParser.createImplementation(To.class);
                to3.createDOMElement((Document)this.decoration.document, "", true);
                to3.setVariable(this.getVariablePart(association.getTarget().getText()));
                if (this.getExpressionPart(association.getTarget().getText()) != null) {
                    to3.setQuery(this.getExpressionPart(association.getTarget().getText()));
                }
                copy3.setTo(to3);
                factsToVarAssign.addCopyRule(copy3);
            }
            factsToVarAssign.saveToDOMElement();
            try {
                sequence.appendChild((Node)factsToVarAssign.getDOMElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (node.isActivity() && ((oracle.bpm.project.model.processes.Activity)node).isUserTask()) {
            input = (InputDataAssociationEnabled)node;
            associationSet = input.getInputDataAssociationSet();
            Assign assign2 = (Assign)BPELParser.createImplementation(Assign.class);
            assign2.createDOMElement((Document)this.decoration.document, "", true);
            assign2.setName("");
            XMLElement frm = (XMLElement)this.decoration.document.createElement("from");
            XMLElement payload2 = (XMLElement)this.decoration.document.createElement("taskservice:payload");
            frm.appendChild((Node)payload2);
            HashSet<String> parts = new HashSet<String>();
            for (DataAssociation association : associationSet.getDataAssociations()) {
                if (this.getSchemaPart(association.getSource().getText()) == null || parts.contains(this.getSchemaPart(association.getSource().getText()))) continue;
                XMLElement c = (XMLElement)this.decoration.document.createElement(this.getExpressionPart(association.getSource().getText()).split("/")[1]);
                payload2.appendChild((Node)c);
                parts.add(this.getExpressionPart(association.getSource().getText()).split("/")[1]);
            }
            copy = (Copy)BPELParser.createImplementation(Copy.class);
            copy.createDOMElement((Document)this.decoration.document, "", true);
            from = (From)BPELParser.createImplementation(From.class);
            from.setDOMElement((Element)frm);
            copy.setFrom(from);
            to = (To)BPELParser.createImplementation(To.class);
            to.createDOMElement((Document)this.decoration.document, "", true);
            to.setVariable("initiateTaskInput");
            to.setPart("payload");
            to.setQuery("/taskservice:initiateTask/task:task/task:payload");
            copy.setTo(to);
            assign2.addCopyRule(copy);
            for (DataAssociation association : associationSet.getDataAssociations()) {
                copy = (Copy)BPELParser.createImplementation(Copy.class);
                copy.createDOMElement((Document)this.decoration.document, "", true);
                from = (From)BPELParser.createImplementation(From.class);
                from.createDOMElement((Document)this.decoration.document, "", true);
                from.setVariable(this.getVariablePart(association.getSource().getText()));
                if (this.getExpressionPart(association.getSource().getText()) != null) {
                    from.setQuery(this.getExpressionPart(association.getSource().getText()));
                }
                copy.setFrom(from);
                to = (To)BPELParser.createImplementation(To.class);
                to.createDOMElement((Document)this.decoration.document, "", true);
                to.setVariable("initiateTaskInput");
                to.setPart("payload");
                if (this.getExpressionPart(association.getSource().getText()) != null) {
                    to.setQuery("/taskservice:initiateTask/task:task/task:payload" + this.getExpressionPart(association.getSource().getText()));
                } else {
                    to.setQuery("/taskservice:initiateTask/task:task/task:payload");
                }
                copy.setTo(to);
                assign2.addCopyRule(copy);
            }
            if (assign2.getCopyRules().size() > 0) {
                sequence.insertBefore((Node)assign2.getDOMElement(), sequence.getFirstChild());
            }
            OutputDataAssociationEnabled output = (OutputDataAssociationEnabled)node;
            associationSet = output.getOutputDataAssociationSet();
            assign2 = (Assign)BPELParser.createImplementation(Assign.class);
            assign2.createDOMElement((Document)this.decoration.document, "", true);
            assign2.setName("");
            for (DataAssociation association : associationSet.getDataAssociations()) {
                copy = (Copy)BPELParser.createImplementation(Copy.class);
                copy.createDOMElement((Document)this.decoration.document, "", true);
                from = (From)BPELParser.createImplementation(From.class);
                from.createDOMElement((Document)this.decoration.document, "", true);
                from.setVariable(node.getDefaultLabel() + "_1_globalVariable");
                from.setPart("payload");
                if (this.getExpressionPart(association.getTarget().getText()) != null) {
                    from.setQuery("/task:task/task:payload" + this.getExpressionPart(association.getTarget().getText()));
                } else {
                    from.setQuery("/task:task/task:payload");
                }
                copy.setFrom(from);
                to = (To)BPELParser.createImplementation(To.class);
                to.createDOMElement((Document)this.decoration.document, "", true);
                to.setVariable(this.getVariablePart(association.getTarget().getText()));
                if (this.getExpressionPart(association.getTarget().getText()) != null) {
                    to.setQuery(this.getExpressionPart(association.getTarget().getText()));
                }
                copy.setTo(to);
                assign2.addCopyRule(copy);
            }
            if (assign2.getCopyRules().size() > 0) {
                Scope scope = (Scope)BPELParser.createImplementation(Scope.class);
                scope.createDOMElement((Document)this.decoration.document, "", true);
                Annotation annotation = (Annotation)BPELParser.createImplementation(Annotation.class);
                annotation.createDOMElement((Document)this.decoration.document, "", true);
                scope.setAnnotation(annotation);
                Analysis analysis = (Analysis)BPELParser.createImplementation(Analysis.class);
                analysis.createDOMElement((Document)this.decoration.document, "", true);
                annotation.setAnalysis(analysis);
                Property annotationProperty = (Property)BPELParser.createImplementation(Property.class);
                annotationProperty.createDOMElement((Document)this.decoration.document, "", true);
                annotationProperty.setName("BusinessId");
                annotationProperty.setValue(node.getId() + "_assign");
                analysis.addProperty(annotationProperty);
                scope.addActivity((Activity)assign2);
                if (container != null) {
                    container.appendChild((Node)scope.getDOMElement());
                }
            }
        }
    }

    private String getRealFactFromAlias(String ruleName, String alias, boolean isInput) {
        String relativeDictPath = ruleName.toLowerCase().replaceAll("\\.", System.getProperty("file.separator"));
        String dictFilePathName = this.projectDirectory.getAbsolutePath() + System.getProperty("file.separator") + "oracle" + System.getProperty("file.separator") + relativeDictPath + ".rules";
        String dictPath = dictFilePathName.substring(0, dictFilePathName.lastIndexOf(System.getProperty("file.separator")));
        String dictFileName = dictFilePathName.substring(dictFilePathName.lastIndexOf(System.getProperty("file.separator")) + 1, dictFilePathName.length());
        File dictFile = null;
        File rulesDir = new File(dictPath);
        String[] rulesFileList = rulesDir.list();
        for (int k = 0; k < rulesFileList.length; ++k) {
            if (!rulesFileList[k].equalsIgnoreCase(dictFileName)) continue;
            dictFile = new File(dictPath, rulesFileList[k]);
            break;
        }
        RuleDictionary dict = null;
        try {
            if (dictFile.exists()) {
                dict = MetadataHelper.loadDictionary((File)dictFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dict != null) {
            for (FactType ft : dict.getDataModel().getFactTypeTable()) {
                if (!ft.getAlias().equals(alias)) continue;
                String factName = ft.getName();
                factName = isInput ? factName.replaceAll("\\.", "_") + "_i" : factName.replaceAll("\\.", "_") + "_o";
                return factName;
            }
        }
        return alias;
    }

    private void log(String message) {
        BpaDiagnosticService.log((int)5, (Level)BpaDiagnosticService.INFORMATION, (String)message);
    }

    private boolean isSynchronous(NodeContainer process, Event event) {
        return ((ThrowEvent)event).isSync();
    }

    static {
        BpaDiagnosticService.setLogger((int)5, (Level)BpaDiagnosticService.ALL, (IBpaLogger)logger);
        Name = "name";
    }

    private class Decoration {
        public XMLDocument document;

        public Decoration() {
            this.document = new XMLDocument();
            this.document.setVersion("1.0");
            this.document.setEncoding(BPELWriter.UTF8);
        }

        public Decoration(XMLDocument document) {
            this.document = document;
            document.setVersion("1.0");
            document.setEncoding(BPELWriter.UTF8);
        }
    }

    private static enum Construct {
        None,
        Sequence,
        Switch,
        Flow,
        Pick,
        While,
        Fault,
        OR,
        SICycle,
        MICycle;

    }
}

