/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.net.URL;
import oracle.bpm.fusion.internal.views.AbstractEventsViewer;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;

public class UrlFileSystemSpyView
extends BaseView {
    private static UrlFileSystemSpyView instance;
    static final String VIEW_ID = "UrlSystemEventsSpyWindow";

    private UrlFileSystemSpyView() {
        super(VIEW_ID);
    }

    public static UrlFileSystemSpyView getInstance() {
        if (instance == null) {
            instance = new UrlFileSystemSpyView();
        }
        return instance;
    }

    @Override
    protected Msg getMsg() {
        return Msg.QUOTE("Url File System Events Spy");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        FileEventsViewer fileEventsViewer = new FileEventsViewer(parent);
        return UiComponent.get((Object)((Object)fileEventsViewer));
    }

    private static class FileEventsViewer
    extends AbstractEventsViewer {
        FileEventsViewer(UiContainer parent) {
            super(parent);
        }

        @Override
        protected void addListener(Workspace workspace, Project project) {
            URLFileSystemListener urlFileSystemListener = new URLFileSystemListener(){

                public void notifyEvent(URLFileSystemEvent event) {
                    FileEventsViewer.this.show("Event:[" + event.toString() + "]");
                }
            };
            URLFileSystem.addURLFileSystemListener((URL)project.getURL(), (URLFileSystemListener)urlFileSystemListener);
        }
    }
}

