/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.ide.Ide;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;

public class SelectionSpyView
extends BaseView {
    private static SelectionSpyView instance;
    static final String VIEW_ID = "SelectionSpyWindow";

    private SelectionSpyView() {
        super(VIEW_ID);
    }

    public static SelectionSpyView getInstance() {
        if (instance == null) {
            instance = new SelectionSpyView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("Selection Spy");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("FCP ActiveView", null, SelectionSpyView.buildFcpSelectionTab());
        tabbedPane.addTab("Workbech SelectionProvider", null, SelectionSpyView.buildWorkbechSelectionProviderTab());
        return UiComponent.get((Object)tabbedPane);
    }

    private static Component buildFcpSelectionTab() {
        final TextAreaViewer textArea = new TextAreaViewer();
        Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

            public void activeViewChanged(ActiveViewEvent e) {
                View view = e.getNewView();
                textArea.show(view.getId() + " has been activated");
            }
        });
        return textArea;
    }

    private static Component buildWorkbechSelectionProviderTab() {
        final TextAreaViewer textArea = new TextAreaViewer();
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        SelectionProvider selectionProvider = workbench.getSelectionProvider();
        selectionProvider.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                DebugSelectionEvent event = new DebugSelectionEvent(newSelection);
                textArea.show(event.toString());
            }
        });
        return textArea;
    }

    private static class TextAreaViewer
    extends JScrollPane {
        private JTextArea textArea;

        TextAreaViewer() {
            this.init();
        }

        public void show(String text) {
            String newText = this.textArea.getText() + "\n" + text;
            this.textArea.setText(newText);
        }

        private void init() {
            this.textArea = new JTextArea("Listening....");
            this.setViewportView(this.textArea);
            this.textArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TextAreaViewer.this.clear();
                    }
                }
            });
            this.textArea.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (e.getX() <= 10 && e.getY() <= 10) {
                        TextAreaViewer.this.clear();
                    }
                }
            });
        }

        private void clear() {
            this.textArea.setText("");
        }
    }

    private static class DebugSelectionEvent {
        private Selection selection;

        public DebugSelectionEvent(Selection value) {
            this.selection = value;
        }

        public String toString() {
            return DebugSelectionEvent.getDebugString(this.getSelection());
        }

        private static String getDebugString(Selection selection) {
            Object object;
            ProjectObject projectObject;
            XFormSelection presentationSelection;
            TypeRef typeRef;
            CatalogObjectImpl catalogObject = (CatalogObjectImpl)selection.as(CatalogObjectImpl.class);
            String result = catalogObject != null ? catalogObject.getClass().getSimpleName() + " [TypeRef=" + catalogObject.getName() + "]" : ((typeRef = (TypeRef)selection.as(TypeRef.class)) != null ? typeRef.getClass().getSimpleName() + " [TypeRef=" + typeRef.getName() + "]" : ((presentationSelection = (XFormSelection)selection.as(XFormSelection.class)) != null ? presentationSelection.getClass().getSimpleName() + " [XFormSelection=" + presentationSelection.getSelection().getId() + " hc=" + presentationSelection.getSelection().hashCode() + "]" : ((projectObject = (ProjectObject)selection.as(ProjectObject.class)) != null ? projectObject.getClass().getSimpleName() + " [Id=" + projectObject.getId() + "]" : ((object = selection.as(Object.class)) != null ? object.getClass().getSimpleName() : selection.toString()))));
            String debug = "";
            Object object2 = selection.as(Object.class);
            if (object2 != null) {
                debug = " [hc= " + object2.hashCode() + "]";
            }
            return result + debug;
        }

        private Selection getSelection() {
            return this.selection;
        }
    }
}

