/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.net.URL;
import javax.swing.JOptionPane;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.workflow.projectwizard.JDevProjectBuilder;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;

public class HumanTaskIntegrationView
extends BaseView {
    private static HumanTaskIntegrationView instance;
    static final String VIEW_ID = "HumanTaskIntegrationWindow";

    private HumanTaskIntegrationView() {
        super(VIEW_ID);
    }

    public static HumanTaskIntegrationView getInstance() {
        if (instance == null) {
            instance = new HumanTaskIntegrationView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("Human Task Integration");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        Panel panel = new Panel(parent);
        MigLayout layout = new MigLayout("wrap 2");
        panel.setLayout((Layout)layout);
        final TextField textField = new TextField((UiContainer)panel, "MyHumanTask", 30);
        BaseAction createAction = new BaseAction(Msg.QUOTE("Create Humnan Task")){

            public void run() {
                Workspace workspace = Ide.getActiveWorkspace();
                Project project = Ide.getActiveProject();
                HumanTaskIntegrationView.this.createHumanTask(workspace, project, textField.getText());
            }
        };
        Button createRuleButton = new Button((UiContainer)panel, createAction);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)Msg.QUOTE("Name")));
        panel.add((UiComponent)textField);
        panel.add((UiComponent)createRuleButton);
        return panel;
    }

    private void createHumanTask(Workspace workspace, Project project, String taskName) {
        JDevProjectBuilder builder = new JDevProjectBuilder(workspace);
        WizardData data = new WizardData();
        data.setProjectName(taskName);
        URL projectUrl = project.getURL();
        data.setProjectDirectory(URLFileSystem.getParent((URL)projectUrl));
        data.setWorkflowName(taskName);
        data.setNamespace(builder.getNamespace() + "/" + taskName);
        data.setOpenEditor(false);
        data.m_bExportAsService = true;
        try {
            builder.createIDEProject(data);
            JDevHelper.refreshProjectInAppNavigator((Project)project);
            URL url = URLFactory.newURL((URL)data.getProjectDirectory(), (String)(data.getWorkflowName() + ".task"));
            JOptionPane.showMessageDialog(null, "HumanTask '" + taskName + "' CREATED OK in Project '" + project.getShortLabel() + "' URL=" + url);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "ERROR creating HumanTask '" + taskName + "' in Project '" + project.getShortLabel());
        }
    }
}

