/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.draw.Color;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.TextField;
import oracle.ide.help.HelpSystem;

public class HelpIntegrationView
extends BaseView {
    private ScannerPanel scannerPanel;
    private static HelpIntegrationView instance;
    static final String VIEW_ID = "HelpIntegrationWindow";
    private static final String DEFAULT_ID = "f1_bpm_dataobjsnewprojectdataobjectd_html";

    private HelpIntegrationView() {
        super(VIEW_ID);
    }

    public static HelpIntegrationView getInstance() {
        if (instance == null) {
            instance = new HelpIntegrationView();
        }
        return instance;
    }

    public void stateChange(int i) {
        if (i == 3) {
            this.scannerPanel.stop();
        }
        super.stateChange(i);
    }

    public void show() {
        if (this.scannerPanel != null) {
            this.scannerPanel.start();
        }
        super.show();
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("Help Integration");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent);
        this.scannerPanel = new ScannerPanel((UiContainer)tabbedPane);
        tabbedPane.addTab(Msg.QUOTE("Help IDs Scanner"), (UiComponent)this.scannerPanel);
        tabbedPane.addTab(Msg.QUOTE("Contextual Help Tester"), (UiComponent)new LauncherPanel((UiContainer)tabbedPane));
        this.scannerPanel.start();
        return tabbedPane;
    }

    private static Point getMousePointer(Component c) {
        PointerInfo info = MouseInfo.getPointerInfo();
        Point pt = info.getLocation();
        SwingUtilities.convertPointFromScreen(pt, c);
        return pt;
    }

    private static class ScannerPanel
    extends Panel {
        private String previousId;
        private Timer timer;
        private static final int DELAY = 250;
        private static String[] SOME_KEYS = new String[]{"f1_bpm_dataobjsnewprojectdataobjectd_html", "f1_bpm_evtsnonecatchevtpropsbasicd_html", "f1_bpm_dataassociationssimpled_html", "f1_bpm_buscatnewmoduled_html", "f1_bpm_evtsnonecatchevtpropsimpld_html", "f1_bpm_bpmprojectnavigator_html", "f1_bpm_bpmprefsactivityd_html", "f1_bpm_dataassociationstranformationd_html", "f1_bpm_mdswindow_html", "f1_bpm_evtserrorcatchevtpropsimpld_html", "f1_bpm_actguidesnewmilestoned_html", "f1_bpm_evtsnonethrowevtpropsimpld_html", "f1_bpm_actsmanualtaskpropsbasicd_html", "f1_bpm_processeditore_html", "f1_bpm_actssendtaskpropsimpld_html", "f1_bpm_actsreceivetaskpropsimpld_html", "f1_bpm_expprojexportprojectw_html", "f1_bpm_gatwysparallgatewaypropsbasicd_html", "f1_bpm_dataobjsnewdataobjectd_html", "f1_bpm_orgrolese_html", "f1_bpm_simnewprojectsimulationd_html", "f1_bpm_actguidesaddtomilestoned_html", "f1_bpm_buscatcustomizew_html", "f1_bpm_expprojprojectlocationw_html", "f1_bpm_actsusertaskpropsimpld_html", "f1_bpm_actsreceivetaskpropsbasicd_html", "f1_bpm_projprefeventsd_html", "f1_bpm_actssendtaskpropsbasicd_html", "f1_bpm_projpreflanguaged_html", "f1_bpm_actsservicetaskpropsbasicd_html", "f1_bpm_evtstimercatchevtpropsbasicd_html", "f1_bpm_busobjecteditore_html", "f1_bpm_orgcalendarrulese_html", "f1_bpm_actsusertaskpropsbasicd_html", "f1_bpm_simsimulationwindow_html", "f1_bpm_evtsmsgthrowevtpropsbasicd_html", "f1_bpm_busobjectnewatt_html", "f1_bpm_expprojfinishedw_html", "f1_bpm_humantaskgenerald_html", "f1_bpm_actsservicetaskpropsimpld_html", "f1_bpm_procsnewprocessgenerald_html", "f1_bpm_evtsmsgcatchevtpropsimpld_html", "f1_bpm_bpmprefsgenerald_html", "f1_bpm_simnewprocesssimulationd_html", "f1_bpm_dataassociationsargumentsd_html", "f1_bpm_actsmanualtaskpropsimpld_html", "f1_bpm_simprocesssimulatione_html", "f1_bpm_evtsmsgcatchevtpropsbasicd_html", "f1_bpm_projprefprocessesd_html", "f1_bpm_gatwysexclusgatewaypropsbasicd_html", "f1_bpm_orgholidayrulese_html", "f1_bpm_orgorganitzationalunite_html", "f1_bpm_procsnewprocessadvanced_html", "f1_bpm_humantaskadvancedd_html", "f1_bpm_evtserrorcatchevtpropsbasicd_html", "f1_bpm_evtstimercatchevtpropsimpld_html", "f1_bpm_procsnewfolderd_html", "f1_bpm_simprojectsimulatione_html", "f1_bpm_gatwysinclusgatewaypropsbasicd_html", "f1_bpm_evtsmsgthrowevtpropsimpld_html", "f1_bpm_actsbusrulestaskpropsimpld_html", "f1_bpm_actsbusrulestaskpropsbasicd_html", "f1_bpm_dataassociationsxpathd_html", "f1_bpm_busobjectnew_html", "f1_bpm_actssubprocesspropsbasicd_html", "f1_bpm_evtsnonethrowevtpropsbasicd_html", "f1_bpm_buscatnewbusexceptiond_html", "f1_bpm_projprefgenerald_html"};

        public ScannerPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        public void stop() {
            this.timer.stop();
        }

        public void start() {
            this.timer.start();
        }

        private static String getContextualHelp() {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            Component c = null;
            if (w != null) {
                Point pt = HelpIntegrationView.getMousePointer(w);
                c = SwingUtilities.getDeepestComponentAt(w, pt.x, pt.y);
            }
            return c != null ? ScannerPanel.getContextualHelp(c) : null;
        }

        private static String getContextualHelp(Component component) {
            for (Component current = component; current != null; current = current.getParent()) {
                UiComponent uiComponent = UiComponent.get((Object)current);
                if (uiComponent.isWrapper()) continue;
                return uiComponent.getHelpId();
            }
            return null;
        }

        private static String getHelpDescription(String id) {
            String result = "";
            if (id != null) {
                String realHelpId = Ui.getHelpService().getRealHelpId(id);
                realHelpId = realHelpId != null ? realHelpId : "";
                result = id + " -> " + realHelpId + " -> " + (Object)((Object)Entry.getStatus(id));
            }
            return result;
        }

        private static String[] getAvailableIdsFromBpmHelp() {
            return SOME_KEYS;
        }

        private void init() {
            final TextField textField = new TextField((UiContainer)this);
            final IdsTablePanel tablePanel = new IdsTablePanel((UiContainer)this);
            BaseAction timerAction = new BaseAction(){

                public void run() {
                    String newId = ScannerPanel.getContextualHelp();
                    if (newId != null && !newId.equals(ScannerPanel.this.previousId) && !"DialogAdapter".equals(newId) || newId == null && ScannerPanel.this.previousId != null) {
                        textField.setText(ScannerPanel.getHelpDescription(newId));
                        ScannerPanel.this.previousId = newId;
                        if (newId != null) {
                            tablePanel.addId(newId);
                        }
                    }
                }
            };
            this.timer = new Timer(250, (ActionListener)timerAction);
            this.timer.setInitialDelay(250);
            this.timer.setCoalesce(true);
            this.timer.stop();
            this.setLayout((Layout)new BorderLayout());
            this.add((UiComponent)textField, "North");
            this.add((UiComponent)tablePanel, "Center");
        }

        static /* synthetic */ String[] access$500() {
            return ScannerPanel.getAvailableIdsFromBpmHelp();
        }

        private static class IdsTablePanel
        extends BaseTablePanel {
            public IdsTablePanel(UiContainer parent) {
                super(parent, Msg.QUOTE("Contextual Help - Helps Ids"), null, (TableModel)new IdsModel());
                this.init();
            }

            public void addId(String id) {
                this.getModel().addRow(id);
            }

            protected void addAction() {
                MessageDialog.showError((UiContainer)this, (Msg)Msg.QUOTE("Create contextual help id"), (Msg)Msg.QUOTE("Pending..."));
            }

            protected IdsModel getModel() {
                return (IdsModel)super.getModel();
            }

            protected BaseAction[] getUserActions() {
                BaseAction exportAction = new BaseAction(UIMsg.PREFERENCES){

                    public void run() {
                        Collection<Entry> invalidEntries;
                        IdsTablePanel.this.stopCellEditor();
                        Collection<Entry> entries = IdsTablePanel.this.getModel().getStatusOkEntries();
                        if (!entries.isEmpty()) {
                            this.header("Replace");
                            for (Entry entry : entries) {
                                if (!entry.getType().isUpdated()) continue;
                                System.out.println(entry.getId() + "=" + entry.getRealId());
                            }
                            this.header("Append");
                            for (Entry entry : entries) {
                                if (!entry.getType().isNew()) continue;
                                System.out.println(entry.getId() + "=" + entry.getRealId());
                            }
                        }
                        if (!(invalidEntries = IdsTablePanel.this.getModel().getStatusInvalidEntries()).isEmpty()) {
                            this.header("Invalid Entries (New or Updated)");
                            for (Entry entry : invalidEntries) {
                                System.out.println(entry.getId() + "=" + entry.getRealId());
                            }
                        }
                    }

                    private void header(String text) {
                        System.out.println("#");
                        System.out.println("# " + text + " these entries in '/main/modules/fusion/studio/src/help.properties' file");
                        System.out.println("#");
                    }
                };
                return new BaseAction[]{exportAction};
            }

            private void init() {
                Table table = this.getTable();
                table.setRelativeSizes(new double[]{0.5, 0.5, 0.25, 0.25});
                table.setAutoResizeMode(AutoResizeMode.NEXT_COLUMN);
                TableColorProvider.Default<Object> colorProvider = new TableColorProvider.Default<Object>(){

                    public Color getBackground(Object element) {
                        int row = this.getRow();
                        Entry entry = (Entry)IdsTablePanel.this.getModel().getRow(row);
                        return entry.getStatus().getColor();
                    }

                    public Color getForeground(Object element) {
                        return null;
                    }
                };
                table.setDefaultColorProvider(String.class, (ColorProvider)colorProvider);
                table.getColumn(1).setCellEditor((TableCellEditor)new RealIdEditor());
            }

            private static class RealIdEditor
            extends AbstractCellEditor
            implements TableCellEditor {
                private ComboBox<String> comboBox;
                private List<String> list = Arrays.asList(ScannerPanel.access$500());

                public RealIdEditor() {
                    Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
                }

                public Object getCellEditorValue() {
                    return this.comboBox != null ? this.comboBox.getText() : "";
                }

                public UiComponent createEditor(UiContainer parent, Object value) {
                    this.comboBox = UiFactory.createMutableComboBox((UiContainer)parent, (boolean)true, this.list);
                    this.comboBox.setText((String)value);
                    return this.comboBox;
                }

                public UiComponent getTableCellEditor(Table component, Object value, boolean isSelected, int row, int column) {
                    return this.createEditor((UiContainer)component, value);
                }
            }

            private static class IdsModel
            extends ProviderTableModel<Entry> {
                private Map<String, Entry> entriesMap = new HashMap<String, Entry>();
                private static final int COLUMN_ID = 0;
                private static final int COLUMN_REALID = 1;
                private static final int COLUMN_TYPE = 2;
                private static final int COLUMN_STATUS = 3;

                public IdsModel() {
                    super(MsgList.create(Msg.QUOTE("ID"), Msg.QUOTE("Real ID"), Msg.QUOTE("Type Entry"), Msg.QUOTE("Status")));
                }

                public Class getColumnClass(int column) {
                    return String.class;
                }

                public Object getValueAt(int row, int column) {
                    Entry entry = (Entry)this.getRow(row);
                    switch (column) {
                        case 0: {
                            return entry.getId();
                        }
                        case 1: {
                            return entry.getRealId();
                        }
                        case 2: {
                            return entry.getType().toString();
                        }
                        case 3: {
                            return entry.getStatus().toString();
                        }
                    }
                    return "";
                }

                public boolean isCellEditable(int row, int column) {
                    return column == 1;
                }

                public void setValueAt(Object value, int row, int column) {
                    Entry entry;
                    String oldValue;
                    String newValue;
                    if (column == 1 && !Str.isEmpty((String)value) && !(newValue = (String)value).equals(oldValue = (entry = (Entry)this.getRow(row)).getRealId())) {
                        entry.setRealId((String)value);
                        this.fireTableDataChanged();
                    }
                }

                public void addRow(String id) {
                    if (id != null && !this.existeEntry(id)) {
                        Entry entry = Entry.create(id);
                        this.entriesMap.put(id, entry);
                        super.addRow((Object)entry);
                    }
                }

                Collection<Entry> getStatusInvalidEntries() {
                    ArrayList<Entry> result = new ArrayList<Entry>();
                    List entries = this.getData();
                    for (Entry entry : entries) {
                        boolean isNewOrUpdated = entry.getType().isNew() || entry.getType().isUpdated();
                        if (!isNewOrUpdated || !entry.getStatus().isInvalid()) continue;
                        result.add(entry);
                    }
                    return result;
                }

                Collection<Entry> getStatusOkEntries() {
                    ArrayList<Entry> result = new ArrayList<Entry>();
                    List entries = this.getData();
                    for (Entry entry : entries) {
                        if (!entry.getStatus().isOk()) continue;
                        result.add(entry);
                    }
                    return result;
                }

                private boolean existeEntry(String id) {
                    return this.entriesMap.get(id) != null;
                }
            }
        }

        private static class Entry {
            private String id;
            private Status status;
            private Type type;

            private Entry(String id) {
                this.id = id;
                String realId = Ui.getHelpService().getRealHelpId(id);
                this.type = realId == null ? Type.NEW : Type.EXIST;
                this.updateStatus();
            }

            public static Entry create(String id) {
                return new Entry(id);
            }

            public static Status getStatus(String id) {
                String realHelpId = Ui.getHelpService().getRealHelpId(id);
                return realHelpId == null ? Status.MISSING : (Ui.getHelpService().isValidHelpId(id) ? Status.OK : Status.INVALID);
            }

            public void setRealId(String realId) {
                if (this.type.isExist()) {
                    this.type = Type.UPDATED;
                }
                Ui.getHelpService().setRealHelpId(this.id, realId == null ? "" : realId);
                this.updateStatus();
            }

            public Status getStatus() {
                return this.status;
            }

            public String getId() {
                return this.id;
            }

            public Type getType() {
                return this.type;
            }

            public String getRealId() {
                return Ui.getHelpService().getRealHelpId(this.id);
            }

            private void updateStatus() {
                this.status = Entry.getStatus(this.id);
            }

            private static enum Type {
                EXIST,
                NEW,
                UPDATED;


                public boolean isExist() {
                    return this.equals((Object)EXIST);
                }

                public boolean isNew() {
                    return this.equals((Object)NEW);
                }

                public boolean isUpdated() {
                    return this.equals((Object)UPDATED);
                }
            }

            private static enum Status {
                OK(Color.GREEN),
                MISSING(Color.RED),
                INVALID(Color.YELLOW);

                private Color color;

                private Status(Color color) {
                    this.color = color;
                }

                public Color getColor() {
                    return this.color;
                }

                public boolean isOk() {
                    return this.equals((Object)OK);
                }

                public boolean isInvalid() {
                    return this.equals((Object)INVALID);
                }
            }
        }
    }

    private static class LauncherPanel
    extends Panel {
        public LauncherPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private static Panel createContextualPanel(UiContainer parent, String name, String helpTopicId) {
            Panel panel = new Panel(parent, Msg.QUOTE(name));
            MigLayout layout = new MigLayout("gap 5, ins 0");
            panel.setLayout((Layout)layout);
            final TextField helpTopicTextField = new TextField((UiContainer)panel, helpTopicId, 40);
            BaseAction showHelpAction = new BaseAction(Msg.QUOTE("Show Help")){

                public void run() {
                    String id = helpTopicTextField.getText();
                    HelpSystem.getHelpSystem().goTo(id);
                }
            };
            Button showHelpButton = new Button((UiContainer)panel, showHelpAction);
            panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)Msg.QUOTE("Help Topic")));
            panel.add((UiComponent)helpTopicTextField);
            panel.add((UiComponent)showHelpButton, (Object)"wrap");
            return panel;
        }

        private void init() {
            MigLayout layout = new MigLayout("gap 5, ins 5, wrap 1");
            this.setLayout((Layout)layout);
            Button button = new Button((UiContainer)this, Msg.QUOTE("Launch Help from Dialog"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MyDialog d = new MyDialog(LauncherPanel.this.getOwnerWindow());
                    d.setVisible(true);
                }
            });
            this.add((UiComponent)button);
            this.add((UiComponent)LauncherPanel.createContextualPanel((UiContainer)this, "Help Id:", HelpIntegrationView.DEFAULT_ID));
        }

        private static class MyDialog
        extends OkCancelDialog {
            public MyDialog(UiWindow parent) {
                super(parent, Msg.QUOTE("Launch Help form Dialog"));
                this.init();
            }

            public void ok() {
                this.close();
            }

            private void init() {
                UiContainer container = this.getContentPane();
                final TextField textField = new TextField(container, HelpIntegrationView.DEFAULT_ID);
                Button button = new Button(container, "Show Help");
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        HelpSystem.getHelpSystem().goTo(textField.getText());
                    }
                });
                container.add((UiComponent)textField, (Object)"North");
                container.add((UiComponent)button, (Object)"South");
                this.pack();
                this.setLocationRelativeTo((UiComponent)this.getParent());
            }
        }
    }
}

