/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.util.Collection;
import oracle.bpm.fusion.internal.views.AbstractEventsViewer;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileChangeListener;
import oracle.ide.index.file.FileChangeManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public class FileSystemEventsSpyView
extends BaseView {
    private static FileSystemEventsSpyView instance;
    static final String VIEW_ID = "FileSystemEventsSpyWindow";

    private FileSystemEventsSpyView() {
        super(VIEW_ID);
    }

    public static FileSystemEventsSpyView getInstance() {
        if (instance == null) {
            instance = new FileSystemEventsSpyView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("File System Events Spy");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        FileEventsViewer fileEventsViewer = new FileEventsViewer(parent);
        return UiComponent.get((Object)((Object)fileEventsViewer));
    }

    private static class FileEventsViewer
    extends AbstractEventsViewer {
        FileEventsViewer(UiContainer parent) {
            super(parent);
        }

        @Override
        protected void addListener(Workspace workspace, Project project) {
            FileChangeManager mgr = FileChangeManager.getFileChangeManager();
            if (mgr != null) {
                FileChangeListener fileChangeListener = new FileChangeListener(){

                    public void filesChanged(Workspace workspace, Project project, Collection<FileChange> changes) {
                        FileEventsViewer.this.show("Workspace:" + workspace.getShortLabel() + " Project: " + project.getShortLabel());
                        for (FileChange change : changes) {
                            FileEventsViewer.this.show("  " + change.toString());
                        }
                        FileEventsViewer.this.show("");
                    }
                };
                mgr.addFileChangeListener(workspace, project, fileChangeListener);
            } else {
                this.show("ERROR: FileChangeManager is NULL");
            }
        }
    }
}

