/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;

abstract class BaseTimerPanel
extends Panel {
    private static final int DELAY = 500;

    public BaseTimerPanel(UiContainer parent, boolean isAppend) {
        super(parent);
        this.init(isAppend);
    }

    protected abstract String getText();

    protected TextComponent createTextComponent(UiContainer parent) {
        TextArea textArea = new TextArea(parent);
        textArea.setText("Click the start button on the right side to run it.");
        textArea.setAutoscrolls(false);
        return textArea;
    }

    private void init(final boolean isAppend) {
        final TextComponent textComponent = this.createTextComponent((UiContainer)this);
        textComponent.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClicked(MouseEvent e) {
                textComponent.setText("");
            }
        });
        BaseAction timerAction = new BaseAction(){

            public void run() {
                String newText = BaseTimerPanel.this.getText();
                String previousText = textComponent.getText();
                if (newText != null && !newText.equals(previousText) || newText == null && previousText != null) {
                    if (isAppend) {
                        if (newText != null) {
                            textComponent.setText(previousText + "\n" + newText);
                        }
                    } else {
                        textComponent.setText(newText);
                    }
                }
            }
        };
        final Timer timer = new Timer(500, (ActionListener)timerAction);
        timer.setInitialDelay(500);
        timer.setCoalesce(true);
        timer.stop();
        ToolBar toolBar = new ToolBar((UiContainer)this, ToolBar.Orientation.VERTICAL);
        BaseAction startStopAction = new BaseAction(UIMsg.ARROW){

            public void run() {
                if (timer.isRunning()) {
                    timer.stop();
                } else {
                    textComponent.setText("");
                    timer.start();
                }
            }
        };
        toolBar.addToggleButton(startStopAction);
        this.setLayout((Layout)new BorderLayout());
        this.add((UiComponent)toolBar, "East");
        this.add((UiComponent)textComponent, "Center");
    }
}

