/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.fusion.repository.JdevRepositoryChangeEvent;
import oracle.bpm.fusion.repository.JdevRepositoryEventType;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.fusion.repository.JdevRepositoryServiceListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.Ide;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;

public class ApplicationNavigatorSpy
extends BaseView {
    private Observer activeWorkspaceListener;
    private JdevRepositoryServiceListener jdevRepositoryListener;
    private Panel panel;
    static final String VIEW_ID = "ApplicationSpy";
    private static ApplicationNavigatorSpy instance;

    private ApplicationNavigatorSpy() {
        super(VIEW_ID);
    }

    public static synchronized ApplicationNavigatorSpy getInstance() {
        if (instance == null) {
            instance = new ApplicationNavigatorSpy();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return UIMsg.TO_MSG((String)"Application Spy");
    }

    public void close() {
        JdevRepositoryService.getInstance().removeObserver(this.jdevRepositoryListener);
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        this.panel = new Panel(parent);
        Label label = Label.create((UiContainer)this.panel, (Msg)Msg.QUOTE("Estoy escuchando el IT Navigator!"));
        this.panel.add((UiComponent)label);
        this.activeWorkspaceListener = this.createWorkspaceListener();
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null) {
            activeWorkspace.attach(this.activeWorkspaceListener);
        }
        JdevRepositoryService.getInstance().addObserver(this.getJdevRepositoryServiceListener());
        return this.panel;
    }

    private Observer createWorkspaceListener() {
        return new Observer(){

            public void update(Object object, UpdateMessage updateMessage) {
                Project jdevProject;
                if (updateMessage.getMessageID() == UpdateMessage.CHILD_ADDED) {
                    jdevProject = (Project)updateMessage.getAddObjects().iterator().next();
                    ApplicationNavigatorSpy.this.showMessage("Workspace Observer: " + object + " PROJECT ADDED=" + jdevProject);
                }
                if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
                    jdevProject = (Project)updateMessage.getRemoveObjects().iterator().next();
                    ApplicationNavigatorSpy.this.showMessage("Workspace Observer: " + object + " PROJECT REMOVED=" + jdevProject);
                }
            }
        };
    }

    private JdevRepositoryServiceListener getJdevRepositoryServiceListener() {
        if (this.jdevRepositoryListener == null) {
            this.jdevRepositoryListener = new JdevRepositoryServiceListener(){

                public void repositoryAdded(JdevRepositoryChangeEvent event) {
                    ApplicationNavigatorSpy.this.showMessage(event.getType().name() + event.getApplication().getShortLabel());
                }

                public void repositoryChanged(JdevRepositoryChangeEvent event) {
                    if (event.getType() == JdevRepositoryEventType.REPOSITORY_DESELECTED) {
                        event.getApplication().detach(ApplicationNavigatorSpy.this.activeWorkspaceListener);
                    }
                    if (event.getType() == JdevRepositoryEventType.REPOSITORY_SELECTED) {
                        ApplicationNavigatorSpy.this.activeWorkspaceListener = ApplicationNavigatorSpy.this.createWorkspaceListener();
                        event.getApplication().attach(ApplicationNavigatorSpy.this.activeWorkspaceListener);
                    }
                    ApplicationNavigatorSpy.this.showMessage(event.getType().name() + event.getApplication().getShortLabel());
                }

                public void repositoryRemoved(JdevRepositoryChangeEvent event) {
                    ApplicationNavigatorSpy.this.showMessage(event.getType().name() + event.getApplication().getShortLabel());
                }
            };
        }
        return this.jdevRepositoryListener;
    }

    private void showMessage(String message) {
        Label label = Label.create((UiContainer)this.panel, (Msg)Msg.QUOTE(message));
        this.panel.add((UiComponent)label);
    }
}

