/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

abstract class AbstractEventsViewer
extends Panel {
    private TextArea textArea;

    AbstractEventsViewer(UiContainer parent) {
        super(parent);
        this.init();
    }

    public void show(String text) {
        String newText = (this.textArea.getText().length() > 0 ? this.textArea.getText() + "\n" : "") + text;
        this.textArea.setText(newText);
    }

    protected abstract void addListener(Workspace var1, Project var2);

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        this.textArea = new TextArea((UiContainer)this);
        this.textArea.setAutoscrolls(false);
        this.show("Click the Add button on the right side to add a listener for the current project...");
        ToolBar toolBar = new ToolBar((UiContainer)this, ToolBar.Orientation.VERTICAL);
        BaseAction startAction = new BaseAction(UIMsg.ADD){

            public void run() {
                AbstractEventsViewer.this.addListenerToActiveProject();
            }
        };
        BaseAction clearAction = new BaseAction(UIMsg.CLEAR){

            public void run() {
                AbstractEventsViewer.this.clear();
            }
        };
        ToolBarItem toolBarItem = toolBar.add(startAction, ToolBar.OPTIONS);
        toolBarItem.setToolTipText("Add listener");
        toolBarItem = toolBar.add(clearAction, ToolBar.OPTIONS);
        toolBarItem.setToolTipText("Clear log");
        this.add((UiComponent)toolBar, "East");
        this.add((UiComponent)this.textArea, "Center");
    }

    private void clear() {
        this.textArea.setText("");
    }

    private void addListenerToActiveProject() {
        Workspace workspace = Ide.getActiveWorkspace();
        Project project = Ide.getActiveProject();
        if (workspace != null && project != null) {
            this.show("Now Listening to Workspace:" + workspace.getShortLabel() + " - Project: " + project.getShortLabel());
            this.addListener(workspace, project);
        } else {
            String w = workspace == null ? "NULL" : workspace.getShortLabel();
            String p = project == null ? "NULL" : project.getShortLabel();
            this.show("ERROR Listening to Workspace: " + w + " - Project: " + p);
        }
    }
}

