/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.methodeditor.language;

import fuego.parser.FuegoToken;
import fuego.parser.Token;
import fuego.parser.TokenStreamException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.editor.EditorLexer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public class LexerAdapter
implements Lexer {
    ReadTextBuffer textBuffer;
    private EditorLexer fuegoLexer;

    public LexerAdapter(LanguageSpec langSpec) {
        this.fuegoLexer = new EditorLexer(langSpec);
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        this.textBuffer = readTextBuffer;
        if (this.textBuffer != null) {
            this.fuegoLexer.setCode(this.textBuffer.getString(0, this.textBuffer.getLength()));
        }
    }

    public ReadTextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    public void setPosition(int i) {
    }

    public LexerToken createLexerToken() {
        return new TokenAdapter();
    }

    public int lex(LexerToken lexedToken) {
        try {
            assert (lexedToken instanceof TokenAdapter) : "Expected a TokenAdapter instance";
            Token token = this.fuegoLexer.nextToken();
            assert (token instanceof FuegoToken) : "Expected a FuegoToken instance";
            FuegoToken fuegoToken = (FuegoToken)token;
            TokenAdapter tokenAdapter = (TokenAdapter)lexedToken;
            tokenAdapter.setFuegoToken(fuegoToken);
            return tokenAdapter.getToken();
        }
        catch (TokenStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void backup() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private class TokenAdapter
    implements LexerToken {
        private FuegoToken fuegoToken;

        private TokenAdapter() {
        }

        public void setFuegoToken(FuegoToken token) {
            this.fuegoToken = token;
        }

        public FuegoToken getFuegoToken() {
            return this.fuegoToken;
        }

        public int getToken() {
            int result = this.fuegoToken.getType();
            switch (result) {
                case 1: {
                    result = 0;
                    break;
                }
                case 0: {
                    result = -1;
                }
            }
            return result;
        }

        public int getStartOffset() {
            return this.fuegoToken.getOffset();
        }

        public int getEndOffset() {
            return this.fuegoToken.getOffset() + this.fuegoToken.getLength();
        }
    }
}

