/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.swing;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.utils.ColorUtils;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.runtime.swing.DottedBorder;

public class XObjectBorderFactory {
    public static Border getBorder(BorderProperties borderProperties) {
        if (borderProperties instanceof SimpleBorderProperties) {
            SimpleBorderProperties properties = (SimpleBorderProperties)borderProperties;
            return (Border)XObjectBorderFactory.createBorder(properties.getBorderstyle(), properties.getBorderwidth(), properties.getBordercolor());
        }
        if (borderProperties instanceof FullBorderProperties) {
            FullBorderProperties properties = (FullBorderProperties)borderProperties;
            CompositeBorder border = new CompositeBorder();
            int max = 0;
            MaskableBorder bottom = XObjectBorderFactory.createBorder(properties.getBottomStyle(), properties.getBottomWidth(), properties.getBottomColor());
            MaskableBorder top = XObjectBorderFactory.createBorder(properties.getTopStyle(), properties.getTopWidth(), properties.getTopColor());
            MaskableBorder left = XObjectBorderFactory.createBorder(properties.getLeftStyle(), properties.getLeftWidth(), properties.getLeftColor());
            MaskableBorder right = XObjectBorderFactory.createBorder(properties.getRightStyle(), properties.getRightWidth(), properties.getRightColor());
            if (properties.getBottomWidth() > max) {
                border.setMasterBorder(bottom);
                max = properties.getBottomWidth();
            }
            if (properties.getTopWidth() > max) {
                border.setMasterBorder(top);
                max = properties.getTopWidth();
            }
            if (properties.getLeftWidth() > max) {
                border.setMasterBorder(left);
                max = properties.getLeftWidth();
            }
            if (properties.getRightWidth() > max) {
                border.setMasterBorder(right);
            }
            border.setBottomBorder(bottom);
            border.setTopBorder(top);
            border.setLeftBorder(left);
            border.setRightBorder(right);
            return border;
        }
        return null;
    }

    private static void addLabel(Panel panel, Label label) {
        label.setBorder((Border)XObjectBorderFactory.createBorder(BorderStyle.valueOf(label.getText()), 5, "#B4B4B4"));
        label.setBackground(Color.WHITE);
        Panel temp = new Panel((UiContainer)panel);
        temp.setLayout((Layout)new BorderLayout());
        temp.add((UiComponent)label, (Object)"Center");
        temp.add((UiComponent)new Panel((UiContainer)temp), (Object)"North");
        temp.add((UiComponent)new Panel((UiContainer)temp), (Object)"South");
        temp.add((UiComponent)new Panel((UiContainer)temp), (Object)"East");
        temp.add((UiComponent)new Panel((UiContainer)temp), (Object)"West");
        panel.add((UiComponent)temp);
    }

    private static MaskableBorder createBorder(BorderStyle borderStyle, int borderWidth, String borderColor) {
        if (borderStyle == null || borderStyle.equals(BorderProperties.BORDER_STYLE_NULL)) {
            return null;
        }
        Color color = ColorUtils.getColor((String)borderColor);
        if (borderStyle == BorderStyle.NONE) {
            return new MyEmptyBorder(borderWidth);
        }
        if (borderStyle == BorderStyle.OUTSET || borderStyle == BorderStyle.INSET) {
            boolean outset = borderStyle == BorderStyle.OUTSET;
            return new MyBevelBorder(outset, color, Color.BLACK, borderWidth);
        }
        if (borderStyle == BorderStyle.DOTTED) {
            return new DottedBorder(color, borderWidth, true);
        }
        if (borderStyle == BorderStyle.DASHED) {
            return DottedBorder.createDashedBorder(color, borderWidth);
        }
        if (borderStyle == BorderStyle.SOLID) {
            return new PlainBorder(color, borderWidth);
        }
        if (borderStyle == BorderStyle.GROOVE || borderStyle == BorderStyle.RIDGE) {
            boolean groove = borderStyle == BorderStyle.GROOVE;
            return new GrooveBorder(groove, color, Color.BLACK, borderWidth);
        }
        if (borderStyle == BorderStyle.DOUBLE) {
            return new DoubleBorder(color, borderWidth);
        }
        return null;
    }

    public static class PlainBorder
    extends XObjectBorder {
        private Color color;
        static final long serialVersionUID = -8726481333689109043L;
        static final long serialCheck = -8486725712886866225L;

        public PlainBorder(Color color, int borderWidth) {
            this.color = color;
            this.setBorderWidth(borderWidth);
        }

        @Override
        public void doPaintBorder(UiComponent c, Graphics g, int xStart, int yStart, int XEnd, int yEnd) {
            g.setForeground(this.color);
            for (int i = 0; i < this.getBorderWidth(); ++i) {
                if (this.doShowTop()) {
                    g.drawLine(0, i, XEnd, i);
                }
                if (this.doShowBottom()) {
                    g.drawLine(0, yEnd - i, XEnd, yEnd - i);
                }
                if (this.doShowLeft()) {
                    g.drawLine(i, 0, i, yEnd);
                }
                if (!this.doShowRight()) continue;
                g.drawLine(XEnd - i, 0, XEnd - i, yEnd);
            }
        }
    }

    public static class MyEmptyBorder
    extends EmptyBorder
    implements MaskableBorder {
        int width = 0;

        public MyEmptyBorder(int width) {
            super(width, width, width, width);
            this.width = width;
        }

        @Override
        public void show(int wich) {
            int top = (wich & 1) != 0 ? this.width : 0;
            int left = (wich & 4) != 0 ? this.width : 0;
            int right = (wich & 8) != 0 ? this.width : 0;
            int bottom = (wich & 2) != 0 ? this.width : 0;
            this.setSizes(top, left, bottom, right);
        }
    }

    public static class MyBevelBorder
    extends XObjectBorder {
        private Color highlight;
        private boolean raised;
        private Color shadow;
        static final long serialVersionUID = -4620140744113648156L;
        static final long serialCheck = 9007410534732277452L;

        public MyBevelBorder(boolean outset, Color highlight, Color shadow, int width) {
            this.highlight = highlight;
            this.shadow = shadow;
            this.setBorderWidth(width);
            this.raised = outset;
        }

        @Override
        public void doPaintBorder(UiComponent c, Graphics g, int xStart, int yStart, int xEnd, int yEnd) {
            int i;
            g.setForeground(this.raised ? this.highlight : this.shadow);
            for (i = 0; i < this.getBorderWidth(); ++i) {
                if (this.doShowTop()) {
                    g.drawLine(0, i, xEnd - i, i);
                }
                if (!this.doShowLeft()) continue;
                g.drawLine(i, 0, i, yEnd - i);
            }
            g.setForeground(!this.raised ? this.highlight : this.shadow);
            for (i = 0; i < this.getBorderWidth(); ++i) {
                if (this.doShowBottom()) {
                    g.drawLine(i, yEnd - i, xEnd, yEnd - i);
                }
                if (!this.doShowRight()) continue;
                g.drawLine(xEnd - i, i, xEnd - i, yEnd);
            }
        }
    }

    public static class GrooveBorder
    extends XObjectBorder {
        private Color highlight;
        private boolean raised;
        private Color shadow;
        static final long serialVersionUID = -123653486084910914L;
        static final long serialCheck = 2333588057465913492L;

        public GrooveBorder(boolean groove, Color highlight, Color shadow, int width) {
            this.highlight = highlight;
            this.shadow = shadow;
            this.setBorderWidth(width);
            this.raised = groove;
        }

        @Override
        public void doPaintBorder(UiComponent c, Graphics g, int xStart, int yStart, int xEnd, int yEnd) {
            int i;
            g.setForeground(this.raised ? this.highlight : this.shadow);
            for (i = 0; i < this.getBorderWidth() / 2; ++i) {
                if (this.doShowTop()) {
                    g.drawLine(i, i, xEnd - i, i);
                }
                if (!this.doShowLeft()) continue;
                g.drawLine(i, i, i, yEnd - i);
            }
            g.setForeground(this.raised ? this.shadow : this.highlight);
            for (i = this.getBorderWidth() / 2; i < this.getBorderWidth(); ++i) {
                if (this.doShowTop()) {
                    g.drawLine(i, i, xEnd - i, i);
                }
                if (!this.doShowLeft()) continue;
                g.drawLine(i, i, i, yEnd - i);
            }
            for (i = 0; i < this.getBorderWidth() / 2; ++i) {
                if (this.doShowBottom()) {
                    g.drawLine(i, yEnd - i, xEnd - i, yEnd - i);
                }
                if (!this.doShowRight()) continue;
                g.drawLine(xEnd - i, i, xEnd - i, yEnd - i);
            }
            g.setForeground(this.raised ? this.highlight : this.shadow);
            for (i = this.getBorderWidth() / 2; i < this.getBorderWidth(); ++i) {
                if (this.doShowBottom()) {
                    g.drawLine(i, yEnd - i, xEnd - i, yEnd - i);
                }
                if (!this.doShowRight()) continue;
                g.drawLine(xEnd - i, i, xEnd - i, yEnd - i);
            }
        }
    }

    public static class DoubleBorder
    extends XObjectBorder {
        private int blankSpace;
        private Color color;
        private int innerSize;
        private int outerSize;
        static final long serialVersionUID = 5332642324850473239L;
        static final long serialCheck = 526038609341001706L;

        public DoubleBorder(Color color, int borderWidth) {
            this.color = color;
            int rem = borderWidth % 3;
            this.innerSize = borderWidth / 3;
            this.setBorderWidth(borderWidth);
            this.blankSpace = this.innerSize + (rem > 1 ? 1 : 0);
            this.outerSize = this.innerSize + (rem > 0 ? 1 : 0);
        }

        @Override
        public void doPaintBorder(UiComponent c, Graphics g, int startX, int startY, int endX, int endY) {
            int i;
            g.setForeground(this.color);
            for (i = 0; i < this.outerSize; ++i) {
                if (this.doShowTop()) {
                    g.drawLine(0, i, endX, i);
                }
                if (this.doShowBottom()) {
                    g.drawLine(0, endY - i, endX, endY - i);
                }
                if (this.doShowLeft()) {
                    g.drawLine(i, 0, i, endY);
                }
                if (!this.doShowRight()) continue;
                g.drawLine(endX - i, 0, endX - i, endY);
            }
            for (i = this.outerSize + this.blankSpace; i < this.getBorderWidth(); ++i) {
                if (this.doShowTop()) {
                    g.drawLine(this.outerSize + this.blankSpace, i, endX - (this.outerSize + this.blankSpace), i);
                }
                if (this.doShowBottom()) {
                    g.drawLine(this.outerSize + this.blankSpace, endY - i, endX - (this.outerSize + this.blankSpace), endY - i);
                }
                if (this.doShowLeft()) {
                    g.drawLine(i, this.outerSize + this.blankSpace, i, endY - (this.outerSize + this.blankSpace));
                }
                if (!this.doShowRight()) continue;
                g.drawLine(endX - i, this.outerSize + this.blankSpace, endX - i, endY - (this.outerSize + this.blankSpace));
            }
        }
    }

    public static class CompositeBorder
    extends Border {
        private MaskableBorder bottomBorder;
        private MaskableBorder leftBorder;
        private Border masterBorder;
        private MaskableBorder rightBorder;
        private MaskableBorder topBorder;

        public CompositeBorder() {
            super(null);
        }

        public Insets getBorderInsets(UiComponent c) {
            if (this.masterBorder != null) {
                return this.masterBorder.getBorderInsets(c);
            }
            return Insets.EMPTY;
        }

        public Insets getBorderInsets(UiComponent c, Insets insets) {
            if (this.masterBorder != null) {
                return this.masterBorder.getBorderInsets(c);
            }
            return Insets.EMPTY;
        }

        public boolean isBorderOpaque() {
            if (this.masterBorder != null) {
                return this.masterBorder.isBorderOpaque();
            }
            return false;
        }

        public void paintBorder(UiComponent c, Graphics g, int x, int y, int w, int h) {
            if (this.bottomBorder != null) {
                ((Border)this.bottomBorder).paintBorder(c, g, x, y, w, h);
            }
            if (this.topBorder != null) {
                ((Border)this.topBorder).paintBorder(c, g, x, y, w, h);
            }
            if (this.rightBorder != null) {
                ((Border)this.rightBorder).paintBorder(c, g, x, y, w, h);
            }
            if (this.leftBorder != null) {
                ((Border)this.leftBorder).paintBorder(c, g, x, y, w, h);
            }
        }

        public void setBottomBorder(MaskableBorder bottomBorder) {
            this.bottomBorder = bottomBorder;
            if (bottomBorder != null) {
                this.bottomBorder.show(2);
            }
        }

        public void setLeftBorder(MaskableBorder leftBorder) {
            this.leftBorder = leftBorder;
            if (leftBorder != null) {
                this.leftBorder.show(4);
            }
        }

        public void setMasterBorder(MaskableBorder masterBorder) {
            this.masterBorder = (Border)masterBorder;
        }

        public void setRightBorder(MaskableBorder rightBorder) {
            this.rightBorder = rightBorder;
            if (rightBorder != null) {
                this.rightBorder.show(8);
            }
        }

        public void setTopBorder(MaskableBorder topBorder) {
            this.topBorder = topBorder;
            if (topBorder != null) {
                this.topBorder.show(1);
            }
        }
    }

    public static abstract class XObjectBorder
    extends Border
    implements MaskableBorder {
        private int shown = 15;
        private int thisBorderWidth;

        public XObjectBorder() {
            super(null);
        }

        public abstract void doPaintBorder(UiComponent var1, Graphics var2, int var3, int var4, int var5, int var6);

        public boolean doShow(int wich) {
            return (this.shown & wich) != 0;
        }

        public boolean doShowBottom() {
            return this.doShow(2);
        }

        public boolean doShowLeft() {
            return this.doShow(4);
        }

        public boolean doShowRight() {
            return this.doShow(8);
        }

        public boolean doShowTop() {
            return this.doShow(1);
        }

        public final Insets getBorderInsets(UiComponent c) {
            return new Insets(this.thisBorderWidth, this.thisBorderWidth, this.thisBorderWidth, this.thisBorderWidth);
        }

        public final Insets getBorderInsets(UiComponent c, Insets insets) {
            return new Insets(this.thisBorderWidth, this.thisBorderWidth, this.thisBorderWidth, this.thisBorderWidth);
        }

        public int getBorderWidth() {
            return this.thisBorderWidth;
        }

        public final boolean isBorderOpaque() {
            return true;
        }

        public final void paintBorder(UiComponent component, Graphics graphics, int x, int y, int w, int h) {
            Color oldColor = graphics.getForeground();
            graphics.translate(x, y);
            int startx = 0;
            int starty = 0;
            int endX = w - 1;
            int endY = h - 1;
            this.doPaintBorder(component, graphics, startx, starty, endX, endY);
            graphics.translate(-x, -y);
            graphics.setForeground(oldColor);
        }

        public void setBorderWidth(int borderWidth) {
            this.thisBorderWidth = borderWidth;
        }

        @Override
        public final void show(int wich) {
            this.shown = wich;
        }
    }

    public static interface MaskableBorder {
        public static final int BOTTOM_BORDER = 2;
        public static final int LEFT_BORDER = 4;
        public static final int RIGHT_BORDER = 8;
        public static final int TOP_BORDER = 1;
        public static final int ALL_BORDERS = 15;

        public void show(int var1);
    }
}

