/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.swing;

import oracle.bpm.data.html.BackgroundPositionX;
import oracle.bpm.data.html.BackgroundPositionY;
import oracle.bpm.data.html.BackgroundRepeat;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.xobject.presentationmodel.XFormBackground;

public final class XObjectBackgroundPanel {
    public static void paint(Panel panel, Graphics g, Image theImage, XFormBackground backGround) {
        Color background = panel.getBackground();
        g.setForeground(background);
        g.fillRect(0, 0, panel.getWidth(), panel.getHeight());
        if (backGround != null && theImage != null) {
            panel.setOpaque(false);
            BackgroundRepeat backgroundRepeat = backGround.getImageLayout();
            BackgroundPositionX xpos = backGround.getImageXPosition();
            BackgroundPositionY ypos = backGround.getImageYPosition();
            if (backgroundRepeat == null) {
                g.drawImage(theImage, 0, 0, background, (UiComponent)panel);
            } else if (backgroundRepeat == BackgroundRepeat.NO_REPEAT) {
                int x = 0;
                int y = 0;
                if (xpos == BackgroundPositionX.LEFT) {
                    x = 0;
                } else if (xpos == BackgroundPositionX.CENTER) {
                    x = (panel.getWidth() - theImage.getWidth()) / 2;
                } else if (xpos == BackgroundPositionX.RIGHT) {
                    x = panel.getWidth() - theImage.getWidth();
                }
                if (ypos == BackgroundPositionY.TOP) {
                    y = 0;
                } else if (ypos == BackgroundPositionY.CENTER) {
                    y = (panel.getHeight() - theImage.getHeight()) / 2;
                } else if (ypos == BackgroundPositionY.BOTTOM) {
                    y = panel.getHeight() - theImage.getHeight();
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                g.drawImage(theImage, x, y, background, (UiComponent)panel);
            } else if (backgroundRepeat == BackgroundRepeat.REPEAT) {
                int currentx = 0;
                for (int currenty = 0; currenty < panel.getHeight(); currenty += theImage.getHeight()) {
                    while (currentx < panel.getWidth()) {
                        g.drawImage(theImage, currentx, currenty, background, (UiComponent)panel);
                        currentx += theImage.getWidth();
                    }
                    currentx = 0;
                }
            } else if (backgroundRepeat == BackgroundRepeat.REPEAT_X) {
                int x = 0;
                int y = 0;
                if (ypos == BackgroundPositionY.TOP) {
                    y = 0;
                } else if (ypos == BackgroundPositionY.CENTER) {
                    y = (panel.getHeight() - theImage.getHeight()) / 2;
                } else if (ypos == BackgroundPositionY.BOTTOM) {
                    y = panel.getHeight() - theImage.getHeight();
                }
                if (y < 0) {
                    y = 0;
                }
                while (x < panel.getWidth()) {
                    g.drawImage(theImage, x, y, background, (UiComponent)panel);
                    x += theImage.getWidth();
                }
            } else if (backgroundRepeat == BackgroundRepeat.REPEAT_Y) {
                int x = 0;
                int y = 0;
                if (xpos == BackgroundPositionX.LEFT) {
                    x = 0;
                } else if (xpos == BackgroundPositionX.CENTER) {
                    x = (panel.getWidth() - theImage.getWidth()) / 2;
                } else if (xpos == BackgroundPositionX.RIGHT) {
                    x = panel.getWidth() - theImage.getWidth();
                }
                if (x < 0) {
                    x = 0;
                }
                while (y < panel.getHeight()) {
                    g.drawImage(theImage, x, y, background, (UiComponent)panel);
                    y += theImage.getHeight();
                }
            } else {
                int x = (panel.getWidth() - theImage.getWidth()) / 2;
                int y = (panel.getHeight() - theImage.getHeight()) / 2;
                g.drawImage(theImage, x, y, background, (UiComponent)panel);
            }
        }
    }
}

