/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.compiler;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ComputeHashException;
import oracle.bpm.util.JarWrapper;
import oracle.bpm.xobject.compiler.XObjectCompilationException;
import oracle.bpm.xobject.lib.Checker;
import oracle.bpm.xobject.lib.CheckerListener;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XObjectCompilationManager
implements MessageListener,
CheckerListener {
    private ComponentCatalog catalog;
    private CheckerListener checkerListener = this;
    private File rootDir;
    private List<ObjectTypeDescription> typesToCompile;
    private static final String XO_XML_EXT = ".xcdl";
    private static final String XO_PRES_EXT = ".ser";

    public XObjectCompilationManager(ComponentCatalog catalog, File baseDir) throws XObjectCompilationException {
        this.getClass().getClassLoader().setPackageAssertionStatus("oracle.bpm.xobject", true);
        if (catalog == null) {
            throw new XObjectCompilationException(XObjectCompilationException.NULL_CATALOG);
        }
        this.catalog = catalog;
        this.rootDir = baseDir;
        this.loadTypesToCompile();
    }

    public void setCheckerListener(CheckerListener checkerListener) {
        this.checkerListener = checkerListener;
    }

    public void error(ObjectTypeDescription owner, String err, XFormXMLObject where, XFormPresentationXMLObject presentation) {
        System.out.println("XObjectCompilationManager.error");
        System.out.println("err = " + err);
        System.out.println("where = " + where);
    }

    public void error(ObjectTypeDescription xo, String err, String where) {
        System.out.println("XObjectCompilationManager.error");
        System.out.println("err = " + err);
        System.out.println("where = " + where);
    }

    public long generateCatalogJar(File jarPath) throws XObjectCompilationException, IOException, ComputeHashException {
        long result;
        if (jarPath == null) {
            throw new XObjectCompilationException(XObjectCompilationException.NULL_JARPATH);
        }
        JarWrapper jar = JarWrapper.createJar(jarPath.getAbsolutePath());
        StringList a = StringList.create(".class", XO_PRES_EXT);
        StringList b = StringList.create(XO_XML_EXT);
        jar.computeHash(a, b);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class") || name.endsWith(XObjectCompilationManager.XO_XML_EXT) || name.endsWith(XObjectCompilationManager.XO_PRES_EXT) || name.endsWith(".fuegoclass");
            }
        };
        System.out.println(">>>>> --- rootDir = " + this.rootDir);
        for (File file : this.rootDir.listFiles()) {
            if (file.isDirectory()) {
                jar.addDirectoryTree(file, filter, true);
                continue;
            }
            if (!filter.accept(this.rootDir, file.getName())) continue;
            jar.addFile(file);
        }
        if (jar.getFiles().length == 0) {
            result = -1L;
        } else {
            jar.close();
            result = jar.getJarHashValue();
        }
        this.cleanXOJavaClassesFromCompilationTree();
        return result;
    }

    public void nonFatalError(ObjectTypeDescription owner, String err, XFormXMLObject where, XFormPresentationXMLObject presentation) {
        this.error(null, err, where, presentation);
    }

    @Override
    public void reportError(CilException exception) {
        MethodTypeDescription member;
        if (exception.isInternal()) {
            exception.printStackTrace(System.out);
        }
        if ((member = (MethodTypeDescription)exception.getMember()) != null && member.getCode() != null) {
            System.err.println(member.getCode().getLineForError(exception));
        }
    }

    @Override
    public void reportWarning(CilException exception) {
    }

    public void resetErrAndWarn() {
    }

    public void warning(ObjectTypeDescription owner, String err, XFormXMLObject where, XFormPresentationXMLObject presentation) {
        System.out.println("XObjectCompilationManager.warning");
        System.out.println("err = " + err);
        System.out.println("where = " + where);
    }

    public void cleanXOCompilationTree() {
        FileFilter noFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        };
        XObjectCompilationManager.deleteDir(new File(this.rootDir + File.separator + "xobject"), noFilter);
    }

    public void checkXO() {
        int len = this.getXOCount();
        for (int i = 0; i < len; ++i) {
            XObjectTypeDescription xotd = (XObjectTypeDescription)this.typesToCompile.get(i);
            xotd.setCatalog(this.catalog);
            Checker checker = new Checker((ObjectTypeDescription)xotd);
            checker.setListener(this.checkerListener);
            checker.checkDataModel((ObjectTypeDescription)xotd);
            if (!Modifier.isPresentable(xotd.getModifiers())) continue;
            XFormPresentationModel[] presentations = xotd.getPModels();
            if (xotd.getProperty("legacy") != null && xotd.getPModels().length == 0) {
                try {
                    XObjectTypeDescriptionHelper.addDefaultPresentationModel((XObjectTypeDescription)xotd);
                }
                catch (ConstructionException e) {
                    this.checkerListener.error((ObjectTypeDescription)xotd, e.getMessage(), "defaultPres");
                }
            }
            if (presentations == null) continue;
            int length = presentations.length;
            for (int j = 0; j < length; ++j) {
                checker.checkPresentationModel(presentations[j], (ObjectTypeDescription)xotd);
            }
        }
    }

    private static void deleteDir(File root, FileFilter filter) {
        File[] listFiles = root.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    XObjectCompilationManager.deleteDir(file, filter);
                    continue;
                }
                if (!filter.accept(file)) continue;
                file.delete();
            }
        }
        if (filter.accept(root)) {
            root.delete();
        }
    }

    private int getXOCount() {
        List<ObjectTypeDescription> list = this.typesToCompile;
        return list == null ? 0 : list.size();
    }

    private void cleanXOJavaClassesFromCompilationTree() {
        FileFilter classFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        };
        XObjectCompilationManager.deleteDir(new File(this.rootDir + File.separator + "xobject"), classFilter);
    }

    private void loadTypesToCompile() {
        this.typesToCompile = new ArrayList<ObjectTypeDescription>();
        ObjectTypeDescription type = this.catalog.getRoot();
        if (type != null) {
            this.loadTypesToCompile(type.get().asObject());
        }
    }

    private void loadTypesToCompile(ObjectTypeDescription root) {
        for (TypeRef ref : root.getInnerTypeRefs()) {
            TypeDescription td = ref.get();
            String componentType = td.getComponentType();
            if (ComponentType.XOBJECT.getText().equals(componentType)) {
                ObjectTypeDescription otd = td.asObject();
                if (Modifier.isPUnitSuite(otd.getModifiers())) continue;
                this.typesToCompile.add(otd);
                continue;
            }
            if (!ComponentType.OBJECT.getText().equals(componentType) && !this.catalog.hasChildren(td)) continue;
            this.loadTypesToCompile(td.asObject());
        }
    }
}

