/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.compiler;

import java.util.Vector;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.xobject.lib.CheckerListener;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class FuegoObjectCheckerListenerImpl
implements CheckerListener {
    private Vector presentationErr = new Vector();
    private Vector presentationWarn = new Vector();
    private boolean showNonFatalErrorsAsWarnings = false;

    public FuegoObjectCheckerListenerImpl() {
    }

    public FuegoObjectCheckerListenerImpl(boolean showNonFatalErrorsAsWarnings) {
        this();
        this.showNonFatalErrorsAsWarnings = showNonFatalErrorsAsWarnings;
    }

    public Vector getPresentationErr() {
        return this.presentationErr;
    }

    public Vector getPresentationWarn() {
        return this.presentationWarn;
    }

    public void error(ObjectTypeDescription owner, String error, XFormXMLObject where, XFormPresentationXMLObject model) {
        this.add(error, where, this.presentationErr, model.getId(), model.getReference());
    }

    public void error(ObjectTypeDescription xo, String error, String where) {
        this.add(error, where, this.presentationErr, xo.getText(), xo.getText());
    }

    public void nonFatalError(ObjectTypeDescription owner, String error, XFormXMLObject where, XFormPresentationXMLObject model) {
        if (this.showNonFatalErrorsAsWarnings) {
            this.warning(owner, error, where, model);
        } else {
            this.error(owner, error, where, model);
        }
    }

    public void resetErrAndWarn() {
        this.presentationErr.clear();
        this.presentationWarn.clear();
        this.showNonFatalErrorsAsWarnings = false;
    }

    public void warning(ObjectTypeDescription owner, String error, XFormXMLObject where, XFormPresentationXMLObject model) {
        this.add(error, where, this.presentationWarn, model.getId(), model.getReference());
    }

    private void add(String error, Object where, Vector toAdd, String whatObject, String xoName) {
        Object[] errArray = new Object[]{whatObject, error, where, xoName};
        toAdd.add(errArray);
    }
}

