/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.toolkit;

import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.layouts.Layout;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.presentation.views.ViewAdapter;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.Locales;
import oracle.bpm.view.ViewType;

public class ProjectObjects {
    private static int count = 1;

    public static ProjectObjectHandle<ProjectObject>[] createHandles(Project project) {
        return new ProjectObjectHandle[]{new ProcessHandle(project), new RoleHandle(project), new ProjectSimulationHandle(project)};
    }

    static class ScreenflowHandle
    extends ModelHandle {
        public ScreenflowHandle(Project project) {
            super(project, SchemaType.SCREENFLOW);
        }
    }

    static class RoleHandle
    extends ProjectObjectHandleImpl<Role> {
        public RoleHandle(Project project) {
            super(project, "Role");
        }

        @Override
        public Role create(String name) throws ProjectException {
            return this.project.getOrganization().createRole(name, name);
        }

        @Override
        public void addToModel(Role object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }

        @Override
        public void updateData(Role object) {
            object.setDescription("New Description");
        }
    }

    static class ProjectSimulationHandle
    extends ProjectObjectHandleImpl<ProjectSimulation> {
        public ProjectSimulationHandle(Project project) {
            super(project, "ProjectSimulation");
        }

        @Override
        public ProjectSimulation create(String name) throws ProjectException {
            return this.project.getSimulations().createProjectSimulation(name);
        }

        @Override
        public void addToModel(ProjectSimulation object) throws ProjectException {
            this.project.getSimulations().addProjectSimulation(object);
        }

        @Override
        public void updateData(ProjectSimulation object) {
            object.setDuration(Interval.valueOf(10000L));
        }
    }

    static class ProcessHandle
    extends ModelHandle {
        public ProcessHandle(Project project) {
            super(project, SchemaType.PROCESS);
        }
    }

    static class ProcedureHandle
    extends ModelHandle {
        public ProcedureHandle(Project project) {
            super(project, SchemaType.PROCEDURE);
        }
    }

    static class ParticipantHandle
    extends ProjectObjectHandleImpl<Participant> {
        public ParticipantHandle(Project project) {
            super(project, "Participant");
        }

        @Override
        public void initData(Participant object) {
            object.asMutable().setMail("aa@bb.com");
            super.initData(object);
        }

        @Override
        public void updateData(Participant object) {
            object.asMutable().setMail("cc@bb.com");
        }

        @Override
        public Participant create(String name) throws ProjectException {
            return this.project.getOrganization().createParticipant(name);
        }

        @Override
        public void addToModel(Participant object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }
    }

    static class OUHandle
    extends ProjectObjectHandleImpl<OrganizationalUnit> {
        public OUHandle(Project project) {
            super(project, "OU");
        }

        @Override
        public OrganizationalUnit create(String name) throws ProjectException {
            OrganizationalUnit root = this.project.getOrganization().getRootOrganizationalUnit();
            return this.project.getOrganization().createOrganizationalUnit(name, root);
        }

        @Override
        public void addToModel(OrganizationalUnit object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }

        @Override
        public void updateData(OrganizationalUnit object) {
            object.asMutable().setDescription("New Description");
        }
    }

    static class ModelContainerHandle
    extends ProjectObjectHandleImpl<FolderContainer> {
        public ModelContainerHandle(Project project) {
            super(project, "Folder");
        }

        @Override
        public FolderContainer create(String name) throws ProjectException {
            FolderContainer root = this.project.getModelsRoot();
            return root.createContainer(name);
        }

        @Override
        public void addToModel(FolderContainer object) throws ProjectException {
            this.project.getModelsRoot().addChild((ProjectObject)object);
        }

        @Override
        public boolean hasEditor() {
            return false;
        }

        @Override
        public boolean isUpdatable() {
            return false;
        }

        @Override
        public void updateData(FolderContainer object) {
        }
    }

    static class LayoutHandle
    extends ProjectObjectHandleImpl<Layout> {
        public LayoutHandle(Project project) {
            super(project, "Layout");
        }

        @Override
        public boolean hasEditor() {
            return false;
        }

        @Override
        public boolean isUpdatable() {
            return false;
        }

        @Override
        public void updateData(Layout object) {
            object.asMutable().setReadOnly(true);
        }
    }

    static class InstancesViewHandle
    extends ViewHandle {
        public InstancesViewHandle(Project project) {
            super(project, ViewType.INSTANCES);
        }
    }

    static class HolidayRuleHandle
    extends ProjectObjectHandleImpl<HolidayRule> {
        public HolidayRuleHandle(Project project) {
            super(project, "HolidayRule");
        }

        @Override
        public HolidayRule create(String name) throws ProjectException {
            return this.project.getOrganization().createHolidayRule(name);
        }

        @Override
        public void addToModel(HolidayRule object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }

        @Override
        public void updateData(HolidayRule object) {
            object.asMutable().setHolidayCalendar(HolidayCalendar.valueOf("", ""));
        }
    }

    static class GroupHandle
    extends ProjectObjectHandleImpl<Group> {
        public GroupHandle(Project project) {
            super(project, "Group");
        }

        @Override
        public Group create(String name) throws ProjectException {
            return this.project.getOrganization().createGroup(name);
        }

        @Override
        public void addToModel(Group object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }

        @Override
        public void updateData(Group object) {
            object.asMutable().setDescription("New Description");
        }
    }

    static class FolderViewHandle
    extends ViewHandle {
        public FolderViewHandle(Project project) {
            super(project, ViewType.FOLDER);
        }
    }

    static class ExternalResourceHandle
    extends ProjectObjectHandleImpl<ExternalResource> {
        public ExternalResourceHandle(Project project) {
            super(project, "ExternalResource");
        }

        @Override
        public boolean hasEditor() {
            return false;
        }

        @Override
        public boolean isUpdatable() {
            return false;
        }

        @Override
        public void updateData(ExternalResource object) {
            object.asMutable().setProperty("key", "value");
        }
    }

    static class CatalogObjectHandle
    extends ProjectObjectHandleImpl<CatalogObject> {
        public CatalogObjectHandle(Project project) {
            super(project, "BpmObject");
        }

        @Override
        public CatalogObject create(String name) throws ProjectException {
            MutableComponentCatalog catalog = (MutableComponentCatalog)this.project.getComponentCatalog();
            ObjectTypeDescription module = new ObjectTypeDescription(name + "Module");
            try {
                catalog.add(module);
                XObjectTypeDescription type = BpmObjectFactory.createXObjectTypeDescription(name, module.getText(), catalog);
                module.addInnerType(type);
                catalog.add(type);
                return this.project.createCatalogObject((TypeRef)type);
            }
            catch (TypeCatalogException e) {
                throw ProjectException.wrap((ProjectObject)this.project, (Throwable)e);
            }
        }

        @Override
        public void addToModel(CatalogObject object) throws ProjectException {
        }

        @Override
        public boolean isAddable() {
            return false;
        }

        @Override
        public boolean isUpdatable() {
            return false;
        }

        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public void updateData(CatalogObject object) {
        }
    }

    static class CalendarRuleHandle
    extends ProjectObjectHandleImpl<CalendarRule> {
        public CalendarRuleHandle(Project project) {
            super(project, "CalendarRule");
        }

        @Override
        public CalendarRule create(String name) throws ProjectException {
            return this.project.getOrganization().createCalendarRule(name);
        }

        @Override
        public void addToModel(CalendarRule object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }

        @Override
        public void updateData(CalendarRule object) {
            object.asMutable().setTimeZone("GMT-2");
        }
    }

    static class BusinessParameterHandle
    extends ProjectObjectHandleImpl<BusinessParameter> {
        public BusinessParameterHandle(Project project) {
            super(project, "BusinessParameter");
        }

        @Override
        public BusinessParameter create(String name) throws ProjectException {
            return this.project.createBusinessParameter(name);
        }

        @Override
        public void addToModel(BusinessParameter object) throws ProjectException {
            this.project.getOrganization().addOrganizationalObject((ProjectObject)object);
        }

        @Override
        public void initData(BusinessParameter object) {
            object.asMutable().setTypeDescription(CatalogType.Default.getString());
        }

        @Override
        public void updateData(BusinessParameter object) {
            object.asMutable().setTypeDescription(CatalogType.Default.getInt());
        }
    }

    static class AttachmentsViewHandle
    extends ViewHandle {
        public AttachmentsViewHandle(Project project) {
            super(project, ViewType.ATTACHMENTS);
        }
    }

    static class ApplicationsViewHandle
    extends ViewHandle {
        public ApplicationsViewHandle(Project project) {
            super(project, ViewType.APPLICATIONS);
        }
    }

    static class ActivitiesInstancesViewHandle
    extends ViewHandle {
        public ActivitiesInstancesViewHandle(Project project) {
            super(project, ViewType.ACTIVITY_INSTANCES);
        }
    }

    static abstract class ViewHandle
    extends ProjectObjectHandleImpl<View> {
        private ViewType viewType;

        public ViewHandle(Project project, ViewType viewType) {
            super(project, "View");
            this.viewType = viewType;
        }

        @Override
        public void updateData(View object) {
            object.setLabel("MyLabel", Locales.getDefaultLocale());
        }

        @Override
        public boolean isUpdatable() {
            return false;
        }

        @Override
        public View create(String name) throws ProjectException {
            return ViewAdapter.create((ViewType)this.viewType, (String)name, (Project)this.project);
        }

        @Override
        public void addToModel(View object) throws ProjectException {
        }
    }

    static abstract class ProjectObjectHandleImpl<T extends ProjectObject>
    implements ProjectObjectHandle<T> {
        protected String prefix;
        protected Project project;

        public ProjectObjectHandleImpl(Project project, String prefix) {
            this.project = project;
            this.prefix = prefix;
        }

        @Override
        public void addToModel(T object) throws ProjectException {
        }

        @Override
        public T create() throws ProjectException {
            return this.create("My" + this.prefix + count++);
        }

        @Override
        public T create(String name) throws ProjectException {
            return null;
        }

        @Override
        public void initData(T object) {
        }

        @Override
        public void removeFromModel(T object) throws ProjectException {
            object.delete();
        }

        @Override
        public boolean hasEditor() {
            return true;
        }

        @Override
        public boolean isUpdatable() {
            return true;
        }

        @Override
        public boolean isAddable() {
            return true;
        }

        @Override
        public boolean isRemovable() {
            return true;
        }

        public String toString() {
            String simpleName = this.getClass().getSimpleName();
            simpleName = simpleName.substring(0, simpleName.length() - "Handle".length());
            return simpleName.toLowerCase();
        }
    }

    static abstract class PresentationHandle
    extends ProjectObjectHandleImpl<Presentation> {
        public PresentationHandle(Project project) {
            super(project, "Presentation");
        }

        @Override
        public Presentation create(String name) throws ProjectException {
            return this.project.getPresentationManager().createPresentation(name);
        }

        @Override
        public void addToModel(Presentation object) throws ProjectException {
            this.project.getPresentationManager().addPresentation(object);
        }
    }

    static abstract class ModelHandle
    extends ProjectObjectHandleImpl<Process> {
        private SchemaType schemaType;

        public ModelHandle(Project project, SchemaType schemaType) {
            super(project, Identifier.capitalize(schemaType.toString().toLowerCase()));
            this.schemaType = schemaType;
        }

        @Override
        public Process create(String name) throws ProjectException {
            Process process = this.project.getModelsRoot().createModel(name);
            process.setDefaultLabel(name);
            return process;
        }

        @Override
        public void addToModel(Process object) throws ProjectException {
            this.project.addProcess(object);
        }

        @Override
        public void updateData(Process object) {
            object.setAuthor("NewAuthor");
        }
    }

    public static interface ProjectObjectHandle<T extends ProjectObject> {
        public T create() throws ProjectException;

        public T create(String var1) throws ProjectException;

        public void initData(T var1);

        public void updateData(T var1);

        public void addToModel(T var1) throws ProjectException;

        public void removeFromModel(T var1) throws ProjectException;

        public boolean hasEditor();

        public boolean isUpdatable();

        public boolean isAddable();

        public boolean isRemovable();
    }

    public static interface ProjectObjectFactory<T extends ProjectObject> {
        public ProjectObjectHandle<T> create(String var1);
    }
}

