/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.process;

import fuego.jdev.test.I18n;
import fuego.jdev.test.tests.process.BaseProcessTest;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.action.ModelActions;
import oracle.bpm.project.command.design.ChangeActivityTypeCommand;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;

public class ProcessTest
extends BaseProcessTest {
    private static final String PROCESS_NAME = I18n.msg("ProcessTest");
    private static final ActivityTemplate ABSTRACT_ACTIVITY = ActivityTemplate.create(I18n.msg("Activity"), BpmnType.ABSTRACT_ACTIVITY);
    private static final ActivityTemplate SERVICE_TASK_NAME = ActivityTemplate.create(I18n.msg("Service Task"), BpmnType.SERVICE_TASK);
    private static final ActivityTemplate RECEIVE_TASK_NAME = ActivityTemplate.create(I18n.msg("Receive Task"), BpmnType.RECEIVE_TASK);
    private static final ActivityTemplate BUSINESS_RULE_TASK_NAME = ActivityTemplate.create(I18n.msg("Business Rule"), BpmnType.BUSINESS_RULE_TASK);
    private static final ActivityTemplate MANUAL_TASK_NAME = ActivityTemplate.create(I18n.msg("Manual"), BpmnType.MANUAL_TASK);
    private static final ActivityTemplate USER_TASK_NAME = ActivityTemplate.create(I18n.msg("User"), BpmnType.USER_TASK);
    private static final ActivityTemplate[] ACTIVITIES = new ActivityTemplate[]{ABSTRACT_ACTIVITY, SERVICE_TASK_NAME, RECEIVE_TASK_NAME, BUSINESS_RULE_TASK_NAME};
    private static final ActivityTemplate[] INTERACTIVE_ACTIVITIES = new ActivityTemplate[]{MANUAL_TASK_NAME, USER_TASK_NAME};

    public void testNewActivity() throws ProjectException {
        Process process = this.createProcess(PROCESS_NAME);
        this.workbench().openEditorForObject(process);
        StartEvent startEvent = ProcessTest.getStartEvent(process);
        ProcessTest.assertNotNull((String)"Activity startEvent should exist in process", (Object)startEvent);
        EndEvent endEvent = ProcessTest.getEndEvent(process);
        ProcessTest.assertNotNull((String)"Activity endEvent should exist in process", (Object)endEvent);
        SequenceFlow startEndSequenceFlow = ProcessTest.getStartEndSequenceFlow(process);
        if (startEndSequenceFlow != null) {
            this.removeFlowElement((FlowElement)startEndSequenceFlow);
        }
        StartEvent previous = startEvent;
        for (ActivityTemplate template : ACTIVITIES) {
            Activity activity = process.createActivity();
            activity.setDefaultLabel(template.getName());
            ChangeActivityTypeCommand.change((Activity)activity, (BpmnType)template.getType());
            this.addActivity(activity);
            this.addSequenceFlow((NodeContainer)process, (FlowNode)previous, (FlowNode)activity);
            previous = activity;
        }
        this.addSequenceFlow((NodeContainer)process, (FlowNode)previous, (FlowNode)endEvent);
        ActionRunner.getInstance().run((Command)ModelActions.getLayoutCommand((Process)process, (boolean)false));
        ProcessTest.assertEquals((String)"Activities in Process.", (int)ACTIVITIES.length, (int)process.getActivities().toArray().length);
        ProcessTest.assertEquals((String)"Events in Process.", (int)2, (int)process.getEvents().toArray().length);
        ProcessTest.assertEquals((String)"Sequence Flows in Process.", (int)(ACTIVITIES.length + 1), (int)process.getSequenceFlows().toArray().length);
        ProcessTest.assertTrue((String)("process Node should be dirty after changes: " + process), (boolean)ProcessTest.isResourceObjectDirty((ResourceObject)process));
    }

    private static class ActivityTemplate {
        private String name;
        private BpmnType type;

        private ActivityTemplate(String name, BpmnType type) {
            this.name = name;
            this.type = type;
        }

        public static ActivityTemplate create(String name, BpmnType type) {
            return new ActivityTemplate(name, type);
        }

        public String getName() {
            return this.name;
        }

        public BpmnType getType() {
            return this.type;
        }
    }
}

