/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.process;

import fuego.jdev.test.tests.BaseProjectTest;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.RemoveObjectsCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.ui.ModelObjectSelection;

abstract class BaseProcessTest
extends BaseProjectTest {
    BaseProcessTest() {
    }

    protected static EndEvent getEndEvent(Process process) {
        Sequence events = process.getEvents(EndEvent.class);
        for (EndEvent event : events) {
            if (!event.isEnd()) continue;
            return event;
        }
        return null;
    }

    protected static StartEvent getStartEvent(Process process) {
        Sequence events = process.getEvents(StartEvent.class);
        for (StartEvent event : events) {
            if (!event.isStart()) continue;
            return event;
        }
        return null;
    }

    protected static SequenceFlow getStartEndSequenceFlow(Process process) {
        Sequence sequenceFlows = process.getSequenceFlows();
        return (SequenceFlow)sequenceFlows.iterator().next();
    }

    protected Process createProcess(String name) throws ProjectException {
        Project project = this.getProject();
        FolderContainer processContainer = project.getModelsRoot();
        Process process = processContainer.createModel(name);
        processContainer.addChild((ProjectObject)process);
        return process;
    }

    protected void removeFlowElement(FlowElement flowElement) {
        ActionRunner.getInstance().run((Command)new RemoveObjectsCommand(ModelObjectSelection.create((FlowElement[])new FlowElement[]{flowElement})));
    }

    protected void addSequenceFlow(NodeContainer container, FlowNode from, FlowNode to) {
        ActionRunner.getInstance().run((Command)new AddTransitionCommand(container, from, to));
    }

    protected void addActivity(Activity activity) throws ProjectException {
        ActionRunner.getInstance().run((Command)new AddActivityCommand((FlowNode)activity, new Point(0, 0)));
    }
}

