/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests;

import fuego.jdev.test.I18n;
import fuego.jdev.test.tests.BaseProjectTest;
import java.net.URL;
import oracle.bpm.fusion.soa.humantask.HumanTaskUtils;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;

public class HumanTaskTest
extends BaseProjectTest {
    private static final String HUMAN_TASK_NAME = I18n.msg("MyHumanTask");

    public void testNewHumanTask() throws Exception {
        oracle.bpm.project.model.Project project = this.getProject();
        Project jdevProject = HumanTaskTest.adaptTo(project, Project.class);
        WizardData data = HumanTaskTest.createDefaultWizardData(jdevProject, HUMAN_TASK_NAME);
        WFEditorData editorData = HumanTaskTest.createDefaultWFEditorData(project.getId());
        URL url = HumanTaskUtils.createHumanTask((Project)jdevProject, (WizardData)data, (WFEditorData)editorData, (HumanTaskType)HumanTaskType.DEFAULT);
        HumanTaskTest.assertNotNull((String)"Human Task URL is Null", (Object)url);
    }

    private static WizardData createDefaultWizardData(Project jdevProject, String taskName) {
        WizardData data = new WizardData();
        data.setProjectName(taskName);
        data.setWorkflowName(taskName);
        URL projectUrl = jdevProject.getURL();
        URL parent = URLFileSystem.getParent((URL)projectUrl);
        System.out.println("HumanTaskTest.createDefaultWizardData project=" + projectUrl + " parent=" + parent);
        data.setProjectDirectory(parent);
        data.setNamespace("MyNameSpace");
        return data;
    }

    private static WFEditorData createDefaultWFEditorData(String name) {
        WFEditorData data = HumanTaskUtils.createDefaultWFEditorData((String)name);
        data.setPriority(3);
        return data;
    }
}

