/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.themes;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.ColorBPMNTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.draw.themes.ThemeProvider;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ThemeMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.ScaledPolygon;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.utils.ImageIOFacade;
import org.jetbrains.annotations.NotNull;

public class DefaultTheme
implements ThemeProvider {
    protected Color backgroundColor = Color.valueOf((int)250, (int)250, (int)252);
    protected String label;
    protected String name;
    protected int ordinal;
    private Font activityFont = UiManager.font((String)"Button.font");
    private Color activityFontColor = Color.BLACK;
    private transient ScaledPolygon[] bpmnElementPolygons;
    private transient EnumMap<ImageType, Image[]> bpmnElements;
    private Image newTransitionImage;
    private Font roleFont = UiManager.font((String)"Button.font").bold();
    private Color roleFontColor = Color.BLACK;
    private Font selectedActivityFont = UiManager.font((String)"Button.font").bold();
    private Color selectedActivityFontColor = Color.BLACK;
    private Font selectedRoleFont = UiManager.font((String)"Button.font").bold();
    private Color selectedRoleFontColor = Color.WHITE;
    private Image[] transitionImages;
    private static final String IMAGES = "images";
    protected static int ordinalCount;
    protected static ArrayList<DefaultTheme> themes;
    private static DefaultTheme instance;

    public DefaultTheme() {
        this.ordinal = ordinalCount++;
    }

    public static DefaultTheme getDefault() {
        if (instance == null) {
            ColorBPMNTheme theme = new ColorBPMNTheme();
            theme.setName("ColorBPMN");
            theme.setLabel("");
            theme.initImagesArrays();
            instance = theme;
        }
        return instance;
    }

    public static DefaultTheme[] getThemes() {
        if (themes == null) {
            themes = new ArrayList();
            ExtensionService service = Platform.getExtensionService();
            List<Extension<ThemeMetadata>> extensions = service.getExtensionsByPoint(ThemeMetadata.class);
            for (Extension<ThemeMetadata> extension : extensions) {
                try {
                    themes.add(DefaultTheme.getTheme(extension));
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Log.logWarning(e);
                }
            }
        }
        return themes.toArray(new DefaultTheme[themes.size()]);
    }

    public static DefaultTheme valueOf(String theme) {
        for (DefaultTheme builtInTheme : DefaultTheme.getThemes()) {
            if (!builtInTheme.name.toLowerCase().equals(theme.toLowerCase())) continue;
            return builtInTheme;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Image getImageFor(@NotNull TransitionType transitionType) {
        return this.getImage(transitionType);
    }

    public Image getImageFor(@NotNull FlowElement element, @NotNull ImageType imageType) {
        return this.getImageFor(FlowFigureUtils.fromElement(element), imageType);
    }

    @Override
    public Image getImageFor(@NotNull FlowFigureType type, @NotNull ImageType imageType) {
        imageType = this.checkImageType(imageType);
        return this.getOrLoadImage(type, imageType, this.bpmnElements.get(imageType));
    }

    public Image getImageFor(@NotNull FlowElement element) {
        FlowFigureType type = FlowFigureUtils.fromElement(element);
        return this.getImageFor(type, ImageType.NORMAL);
    }

    public String getIconImageRelativePath(@NotNull FlowNode node) {
        FlowFigureType type = FlowFigureUtils.fromElement(node);
        return this.getImageRelativePath(type, ImageType.ICON);
    }

    public String getImageRelativePath(@NotNull FlowNode node) {
        FlowFigureType type = FlowFigureUtils.fromElement(node);
        return this.getImageRelativePath(type, ImageType.NORMAL);
    }

    public Image getNewTransitionImage() {
        if (this.newTransitionImage == null) {
            this.newTransitionImage = this.loadImage(ImageType.TRANSITION, "NEW");
        }
        return this.newTransitionImage;
    }

    public ScaledPolygon getPolygon(@NotNull FlowFigureType type) {
        ScaledPolygon result = this.bpmnElementPolygons[type.ordinal()];
        if (result == null) {
            ScaledPolygon scaledPolygon = new ScaledPolygon(this.getImage(type).surroundingPolygon());
            this.bpmnElementPolygons[type.ordinal()] = scaledPolygon;
            result = scaledPolygon;
        }
        return result;
    }

    public Font getLaneFont(boolean selected) {
        return selected ? this.selectedRoleFont : this.roleFont;
    }

    public Color getRoleFontColor() {
        return this.roleFontColor;
    }

    public Color getSelectedActivityFontColor() {
        return this.selectedActivityFontColor;
    }

    public Color getSelectedRoleFontColor() {
        return this.selectedRoleFontColor;
    }

    public Font getActivityFont(boolean selected) {
        return selected ? this.selectedActivityFont : this.activityFont;
    }

    public Color getActivityFontColor() {
        return this.activityFontColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }

    public boolean isAnyBPMN() {
        return false;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void initImagesArrays() {
        if (this.bpmnElements == null) {
            int length = FlowFigureType.values().length;
            this.initMapArrays(length);
            this.bpmnElementPolygons = new ScaledPolygon[length];
            this.transitionImages = new Image[TransitionType.values().length];
        }
    }

    private static DefaultTheme getTheme(Extension<ThemeMetadata> extension) throws InstantiationException {
        DefaultTheme themeProvider = (DefaultTheme)extension.instantiateAs(ThemeProvider.class);
        themeProvider.setName(extension.getMetadata().name());
        themeProvider.setLabel(extension.getMetadata().label());
        themeProvider.initImagesArrays();
        return themeProvider;
    }

    private Image getOrLoadImage(FlowFigureType type, ImageType imageType, Image[] images) {
        Image result = images[type.ordinal()];
        if (result == null) {
            Image loaded;
            images[type.ordinal()] = loaded = this.loadImage(imageType, type.name());
            result = loaded;
        }
        return result;
    }

    private ImageType checkImageType(ImageType imageType) {
        if (imageType == ImageType.TRANSITION) {
            throw new IllegalArgumentException("This method should be only used for activity icons");
        }
        return imageType;
    }

    private String getImageRelativePath(@NotNull FlowFigureType type, @NotNull ImageType imageType) {
        String fullName = this.name + "/" + imageType + "/" + type;
        return fullName.toLowerCase();
    }

    private Image getImage(@NotNull FlowFigureType type) {
        return this.getImageFor(type, ImageType.NORMAL);
    }

    private Image getImage(@NotNull TransitionType type) {
        Image result = null;
        if (type != TransitionType.UNCONDITIONAL && type != TransitionType.DEPENDENCY) {
            this.initImagesArrays();
            result = this.transitionImages[type.ordinal()];
            if (result == null) {
                Image image = this.loadImage(ImageType.TRANSITION, type.toString());
                this.transitionImages[type.ordinal()] = image;
                result = image;
            }
        }
        return result;
    }

    private void initMapArrays(int length) {
        this.bpmnElements = new EnumMap(ImageType.class);
        this.bpmnElements.put(ImageType.MINI_ICON, new Image[length]);
        this.bpmnElements.put(ImageType.ICON, new Image[length]);
        this.bpmnElements.put(ImageType.NORMAL, new Image[length]);
        this.bpmnElements.put(ImageType.SELECTED, new Image[length]);
    }

    private Image loadImage(@NotNull ImageType imageType, @NotNull String imageName) {
        String fullName = "images/" + this.name + "/" + imageType + "/" + imageName;
        Image img = ImageIOFacade.readImageResource(this.getClass(), (String)fullName);
        if (img == null) {
            if (imageType == ImageType.MINI_ICON) {
                fullName = "images/" + this.name + "/" + ImageType.ICON + "/" + imageName;
                img = ImageIOFacade.readImageResource(this.getClass(), (String)fullName);
            }
            if (img == null) {
                IllegalArgumentException argumentException = new IllegalArgumentException("Cannot load image: " + fullName);
                argumentException.printStackTrace(System.out);
                Log.logSevere(argumentException);
                img = this.loadImage(imageType, "unknown");
            }
        }
        return img;
    }

    static {
        themes = null;
    }
}

