/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.LineStyle;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.renderer.DebugContainerRenderer;
import oracle.bpm.draw.renderer.DefaultRenderer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class SubprocessRenderer
extends DefaultRenderer
implements Renderer {
    private DebugContainerRenderer debug;
    private static final int ARC_SIZE = 20;

    private SubprocessRenderer(@NotNull Drawable<Subprocess> drawable) {
        super(drawable);
        if (drawable instanceof DrawableNodeContainer) {
            this.debug = DebugContainerRenderer.create((DrawableNodeContainer)drawable);
        }
    }

    public static SubprocessRenderer create(@NotNull Drawable<Subprocess> container) {
        return new SubprocessRenderer(container);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        Graphics graphics = context.getGraphics();
        this.renderBackground(context, graphics);
        super.render(context);
        this.renderBorder(context, graphics);
        if (this.debug != null) {
            this.debug.render(context);
        }
    }

    @Override
    protected DrawableFlowElement getDrawable() {
        return (DrawableFlowElement)super.getDrawable();
    }

    private void renderBorder(DrawContext context, Graphics graphics) {
        Stroke originalStroke = graphics.getStroke();
        Color originalForeground = graphics.getForeground();
        AntialiasingMode originalAntialiasing = graphics.getAntialiasing();
        boolean selected = this.getDrawable().isShowSelection();
        boolean triggered = this.getModelObject().isTriggeredByEvent();
        if (context.isHighlighted(this.getDrawable())) {
            graphics.setStroke(triggered ? new Stroke(4, LineStyle.DOT) : Stroke.FOUR_SOLID);
            graphics.setForeground(Color.DARK_GREEN);
            graphics.setAntialiasing(AntialiasingMode.ON);
            this.drawRounded(context, graphics);
        }
        graphics.setStroke(selected ? (triggered ? Stroke.TWO_DOTTED : Stroke.TWO_SOLID) : (triggered ? Stroke.ONE_DOTTED : Stroke.ONE_SOLID));
        graphics.setForeground(selected ? Color.BLACK : Color.valueOf((Color)Color.BLACK, (int)140));
        graphics.setAntialiasing(AntialiasingMode.ON);
        this.drawRounded(context, graphics);
        graphics.setAntialiasing(originalAntialiasing);
        graphics.setForeground(originalForeground);
        graphics.setStroke(originalStroke);
    }

    private void renderBackground(DrawContext context, Graphics graphics) {
        AntialiasingMode originalAntialiasing = graphics.getAntialiasing();
        Color originalForeground = graphics.getForeground();
        graphics.setForeground(Color.valueOf((Color)Color.FUEGO_LIGHT_BLUE, (int)(this.getDrawable().isShowSelection() ? 80 : 130)));
        graphics.setAntialiasing(AntialiasingMode.ON);
        this.fillRounded(context, graphics);
        graphics.setAntialiasing(originalAntialiasing);
        graphics.setForeground(originalForeground);
    }

    private void fillRounded(DrawContext context, Graphics graphics) {
        this.transformRounded(context, graphics, true);
    }

    private void drawRounded(DrawContext context, Graphics graphics) {
        this.transformRounded(context, graphics, false);
    }

    private void transformRounded(DrawContext context, Graphics graphics, boolean fill) {
        Rectangle bounds = context.scaleRectangle(this.getDrawable().getBounds(context));
        int scaledArc = context.scale(20);
        if (fill) {
            graphics.fillRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), scaledArc, scaledArc);
        } else {
            graphics.drawRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), scaledArc, scaledArc);
        }
    }

    private Subprocess getModelObject() {
        return (Subprocess)this.getDrawable().getModelObject();
    }
}

