/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.renderer.DebugContainerRenderer;
import oracle.bpm.draw.renderer.DefaultRenderer;
import oracle.bpm.draw.renderer.ProcessTemplateRenderer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ProcessRenderer
extends DefaultRenderer
implements Renderer {
    private final DebugContainerRenderer debug;
    private final ProcessTemplateRenderer template;
    private static final int GRID_SIZE = 10;

    private ProcessRenderer(@NotNull DrawableProcess process) {
        super(process);
        this.debug = DebugContainerRenderer.create(process);
        this.template = ProcessTemplateRenderer.create(process);
    }

    public static ProcessRenderer create(@NotNull DrawableProcess container) {
        return new ProcessRenderer(container);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        Graphics graphics = context.getGraphics();
        Rectangle rectangle = context.getRectangle();
        graphics.setBackground(Color.WHITE);
        graphics.setForeground(Color.WHITE);
        graphics.fill(rectangle);
        graphics.setForeground(Color.BLACK);
        int translateX = context.getStartX();
        int translateY = context.getStartY();
        context.getGraphics().translate(-translateX, -translateY);
        this.renderGrid(context);
        this.template.render(context);
        super.render(context);
        this.debug.render(context);
        context.getGraphics().translate(translateX, translateY);
    }

    @Override
    protected DrawableProcess getDrawable() {
        return (DrawableProcess)super.getDrawable();
    }

    private void renderGrid(@NotNull DrawContext context) {
        if (context.getShowGrid()) {
            Rectangle bounds = context.getRectangle();
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            Color dark = Color.FUEGO_LIGHT_BLUE;
            Color light = Color.valueOf((Color)Color.FUEGO_LIGHT_BLUE, (int)160);
            int x = bounds.getX();
            int y = bounds.getY();
            int w = bounds.getWidth();
            int h = bounds.getHeight();
            int step = context.scale(10);
            boolean skip = step < 5;
            for (int i = x / step; i <= (x + w) / step + 1; ++i) {
                if (i % 8 == 0) {
                    graphics.setForeground(dark);
                } else {
                    if (skip) continue;
                    graphics.setForeground(light);
                }
                int xStep = i * step;
                graphics.drawLine(xStep, y, xStep, y + h);
            }
            for (int j = y / step; j <= (y + h) / step + 1; ++j) {
                if (j % 8 == 0) {
                    graphics.setForeground(dark);
                } else {
                    if (skip) continue;
                    graphics.setForeground(light);
                }
                int yStep = j * step;
                graphics.drawLine(x, yStep, x + w, yStep);
            }
            graphics.setForeground(original);
        }
    }
}

