/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DefaultRenderer
implements Renderer {
    private final Drawable drawable;

    protected DefaultRenderer(@NotNull Drawable drawable) {
        this.drawable = drawable;
    }

    public static DefaultRenderer create(@NotNull Drawable drawable) {
        return new DefaultRenderer(drawable);
    }

    @Override
    public void render(@NotNull DrawContext context) {
        Rectangle visible = context.unscaleRectangle(context.getRectangle());
        Collection<Drawable> children = CollectionUtils.createCopy(this.drawable.getDrawables());
        for (Drawable child : children) {
            if (!context.isPrinting() && !child.intersects(visible, context)) continue;
            child.draw(context);
        }
    }

    protected Drawable getDrawable() {
        return this.drawable;
    }
}

