/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.diagram;

import java.util.Iterator;
import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableChildPopulator;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.draw.diagram.DiagramEvent;
import oracle.bpm.draw.diagram.ProcessDiagrammer;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.utils.ImageIOFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuditProcessDiagrammer
implements ProcessDiagrammer {
    private final DrawContext context = new DrawContext();
    private final DrawableSingleProcessRoot root;

    public AuditProcessDiagrammer(@NotNull Process process) {
        this.context.setShowNotes(false);
        this.root = DrawableSingleProcessRoot.create(null);
        this.expandSubprocesses(process);
        this.addProcessToRoot(process);
    }

    @Override
    public void highlight(@NotNull Iterable<DiagramEvent> events) {
        this.context.clearHighlightedActivities();
        this.context.clearHighlightedTransitions();
        for (DiagramEvent event : events) {
            switch (event.getType()) {
                case FLOW_NODE_IN: {
                    this.highlightFlowNode(event);
                    break;
                }
                case SEQUENCE_FLOW: {
                    this.highlightSequenceFlow(event);
                }
            }
        }
    }

    @Override
    @NotNull
    public String getImage() {
        Image image = DrawableHelper.createImageForDrawable(this.root.getSingleProcess(), this.context);
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    @Override
    @NotNull
    public Rectangle getBoundsForFlowElement(@NotNull String flowElementId) {
        FlowElement flowElement = this.findFlowElement(flowElementId);
        return this.getDrawable(flowElement).getBounds(this.context);
    }

    @Override
    @NotNull
    public String getImageForFlowElement(@NotNull String flowElementId) {
        FlowElement flowElement = this.findFlowElement(flowElementId);
        Image image = flowElement != null ? DrawableHelper.createImageForDrawable(this.getDrawable(flowElement), this.context) : Image.create((int)1, (int)1);
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    @Override
    @NotNull
    public String getIconForFlowElement(@NotNull String flowElementId) {
        FlowElement flowElement = this.findFlowElement(flowElementId);
        Image image = flowElement != null ? this.context.getTheme().getImageFor(flowElement, ImageType.ICON) : Image.create((int)1, (int)1);
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    @Override
    @Deprecated
    @NotNull
    public String getImageForFlowNode(@NotNull String flowNodeId) {
        return this.getImageForFlowElement(flowNodeId);
    }

    @Override
    @Deprecated
    @NotNull
    public String getIconForFlowNode(@NotNull String flowNodeId) {
        return this.getIconForFlowElement(flowNodeId);
    }

    @Override
    @Deprecated
    @NotNull
    public Rectangle getBoundsForFlowNode(@NotNull String flowNodeId) {
        return this.getBoundsForFlowElement(flowNodeId);
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        this.context.setLocale(locale);
    }

    @Override
    public void setScale(float scale) {
        this.context.setScale(scale);
    }

    public Process getProcess() {
        return (Process)this.root.getSingleProcess().getModelObject();
    }

    private void expandSubprocesses(Process process) {
        Sequence<Subprocess> subprocessSequence = process.getDescendants(Subprocess.class);
        for (Subprocess subprocess : subprocessSequence) {
            subprocess.getFeature(IsCollapsedFeature.class).setValue(false);
        }
    }

    private void highlightSequenceFlow(@NotNull DiagramEvent event) {
        SequenceFlow flow = this.findSequenceFlow(event.getFlowElementId());
        this.context.addHighlightedTransition(flow);
    }

    private void highlightFlowNode(@NotNull DiagramEvent event) {
        this.context.addHighlightedActivity(event.getFlowElementId());
    }

    private DrawableFlowElement<?> getDrawable(@NotNull FlowElement element) {
        return DrawableHelper.findDrawableRecursively(this.root.getSingleProcess(), element);
    }

    private FlowElement findFlowElement(final @NotNull String flowNodeId) {
        return this.findFlowElement(this.getProcess(), new Function<NodeContainer, FlowElement>(){

            @Override
            public FlowElement eval(NodeContainer container) {
                return CollectionUtils.findFirst(container.getChildrenByType(FlowElement.class), new Predicate<FlowElement>(){

                    @Override
                    public boolean check(@Nullable FlowElement value) {
                        return value != null && value.getId().equalsIgnoreCase(flowNodeId);
                    }
                });
            }
        });
    }

    private SequenceFlow findSequenceFlow(final @NotNull String sequenceFlowId) {
        return this.findFlowElement(this.getProcess(), new Function<NodeContainer, SequenceFlow>(){

            @Override
            public SequenceFlow eval(NodeContainer container) {
                return container.findSequenceFlow(sequenceFlowId);
            }
        });
    }

    private <T extends FlowElement> T findFlowElement(@NotNull NodeContainer container, @NotNull Function<NodeContainer, T> finder) {
        FlowElement result;
        block1: {
            NodeContainer inner;
            result = (FlowElement)finder.eval(container);
            if (result != null) break block1;
            Iterator<NodeContainer> i$ = container.getChildrenByType(NodeContainer.class).iterator();
            while (i$.hasNext() && (result = this.findFlowElement(inner = i$.next(), finder)) == null) {
            }
        }
        return (T)result;
    }

    private void addProcessToRoot(@NotNull Process process) {
        BpmnDrawableFactory factory = BpmnDrawableFactory.getInstance();
        DrawableChildPopulator.populateChild(factory, this.root, process, this.context);
    }
}

