/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.draw.debug.Debugable;
import oracle.bpm.geom.Point;
import oracle.bpm.project.LaneImpl;
import org.jetbrains.annotations.NotNull;

class LaneColumnDebugable
extends Debugable.Default
implements Debugable.LocatedDebugable {
    private final DrawContext context;

    public LaneColumnDebugable(@NotNull DrawContext context) {
        this.context = context;
    }

    @Override
    public void attachDebugInfo(@NotNull Drawable original, @NotNull StringList info) {
        DrawableLaneColumn drawable = (DrawableLaneColumn)original;
        this.attachKeyValue(info, "width", drawable.getWidth(this.context));
        this.attachKeyValue(info, "height", drawable.getHeight(this.context));
        this.attachKeyValue(info, "loc", drawable.getLocation().toString());
    }

    @Override
    public boolean accepts(@NotNull Drawable flowElement) {
        return flowElement instanceof DrawableLaneColumn;
    }

    @Override
    @NotNull
    public Point getSpecificLocation(@NotNull DrawContext context, @NotNull Drawable drawable) {
        DrawableLaneColumn column = (DrawableLaneColumn)drawable;
        return column.getLocation().translate(0, ((LaneImpl)column.getModelObject()).getSize() / 2);
    }
}

