/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import java.util.Map;
import java.util.NavigableMap;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.debug.DebugableAppender;
import oracle.bpm.draw.debug.DebugableFactory;
import oracle.bpm.geom.Point;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class DebugableDrawer {
    public static void drawDebugInfo(@NotNull DrawContext context, @NotNull DrawableNodeContainer<?> container) {
        for (Drawable drawable : container.getDrawables()) {
            DebugableAppender debugable = DebugableFactory.create(context, drawable);
            if (!debugable.accepts(drawable)) continue;
            DebugableDrawer.drawDebugInfo(context, drawable, debugable);
        }
        if (container instanceof DrawableSubprocess) {
            DebugableAppender debugable = DebugableFactory.create(context, container);
            DebugableDrawer.drawDebugInfo(context, container, debugable);
        } else {
            DebugableDrawer.drawProcessInfo(context, ((NodeContainer)container.getModelObject()).getProcess());
        }
    }

    private static void drawDebugInfo(@NotNull DrawContext context, @NotNull Drawable drawable, @NotNull DebugableAppender debugable) {
        StringList info = StringList.create(5);
        debugable.attachDebugInfo(drawable, info);
        if (!info.isEmpty()) {
            Point location = debugable.getSpecificLocation(context, drawable);
            Color color = debugable.getSpecificColor(context, drawable);
            DebugableDrawer.drawList(context, info, location, color);
        }
    }

    private static int getWidestStringForInfo(DrawContext context, StringList list) {
        String max = "";
        for (String string : list) {
            if (string.length() <= max.length()) continue;
            max = string;
        }
        int result = -1;
        if (max.length() != 0) {
            FontMetrics metrics = context.getFontMetrics();
            result = metrics.stringWidth(max);
        }
        return result;
    }

    private static void drawProcessInfo(@NotNull DrawContext context, @NotNull Process process) {
        DebugableDrawer.drawLanesInfo(process, context);
    }

    private static void drawLanesInfo(@NotNull Process process, @NotNull DrawContext context) {
        NavigableMap lanes = ((ProcessContent)process).getLanesInternal();
        StringList result = StringList.create(lanes.size());
        for (Map.Entry entry : lanes.entrySet()) {
            Lane lane = (Lane)entry.getValue();
            result.add("[" + entry.getKey() + "] > {" + lane.getOffset() + "," + lane.getSize() + "} " + lane.getId());
        }
        Point location = new Point(450 + context.getDeltaX(), 50 + context.getDeltaY());
        DebugableDrawer.drawList(context, result, location, Color.valueOf((int)65, (int)105, (int)160, (int)150));
    }

    private static void drawList(@NotNull DrawContext context, @NotNull StringList list, @NotNull Point location, Color color) {
        int fontHeight = context.scale(context.getFontMetrics().getHeight());
        location = context.scalePoint(location);
        int rounded = context.scale(10);
        int width = context.scale((int)((float)DebugableDrawer.getWidestStringForInfo(context, list) * 1.1f) + rounded);
        int height = context.scale((fontHeight + rounded / 2) * list.size() + rounded);
        Graphics graphics = context.getGraphics();
        graphics.setForeground(color);
        graphics.fillRoundRect(location.getX() - rounded / 2, location.getY() - rounded / 2 - fontHeight, width, height, rounded, rounded);
        graphics.setForeground(Color.BLACK);
        graphics.drawRoundRect(location.getX() - rounded / 2, location.getY() - rounded / 2 - fontHeight, width, height, rounded, rounded);
        graphics.setForeground(Color.WHITE);
        for (int i = 0; i < list.size(); ++i) {
            String str = (String)list.get(i);
            graphics.drawString(str, location.getX(), location.getY() + (fontHeight + rounded / 2) * i);
        }
    }
}

