/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import java.util.LinkedList;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.debug.Debugable;
import oracle.bpm.geom.Point;
import org.jetbrains.annotations.NotNull;

final class DebugableAppender
extends LinkedList<Debugable>
implements Debugable.LocatedDebugable,
Debugable.ColoredDebugable {
    DebugableAppender() {
    }

    @Override
    public boolean accepts(@NotNull Drawable drawable) {
        return !this.isEmpty();
    }

    @Override
    public void attachDebugInfo(@NotNull Drawable drawable, @NotNull StringList info) {
        for (Debugable debugable : this) {
            debugable.attachDebugInfo(drawable, info);
        }
    }

    @Override
    @NotNull
    public Point getSpecificLocation(@NotNull DrawContext context, @NotNull Drawable drawable) {
        for (Debugable debugable : this) {
            if (!(debugable instanceof Debugable.LocatedDebugable)) continue;
            return ((Debugable.LocatedDebugable)debugable).getSpecificLocation(context, drawable);
        }
        return drawable.getLocation().translate(10, 10);
    }

    @Override
    @NotNull
    public Color getSpecificColor(@NotNull DrawContext context, @NotNull Drawable drawable) {
        for (Debugable debugable : this) {
            if (!(debugable instanceof Debugable.ColoredDebugable)) continue;
            return ((Debugable.ColoredDebugable)debugable).getSpecificColor(context, drawable);
        }
        return Color.valueOf((int)100, (int)210, (int)110, (int)200);
    }
}

