/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableRoot;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;

public class DrawableSingleProcessRoot
extends DrawableRoot {
    private DrawableProcess single;

    private DrawableSingleProcessRoot(PaintCanvas canvas) {
        super(canvas);
    }

    public static DrawableSingleProcessRoot create(PaintCanvas canvas) {
        return new DrawableSingleProcessRoot(canvas);
    }

    @Override
    public void addChild(@NotNull Drawable drawable) {
        if (drawable.getLayer().equals((Object)DesignerLayer.PROCESS)) {
            this.single = (DrawableProcess)drawable;
        }
        super.addChild(drawable);
    }

    @Override
    public void removeChild(@NotNull Drawable drawable) {
        if (drawable.getLayer().equals((Object)DesignerLayer.PROCESS) && drawable.equals(this.single)) {
            this.single = null;
        }
        super.removeChild(drawable);
    }

    @NotNull
    public DrawableProcess getSingleProcess() {
        if (this.single == null) {
            throw new IllegalStateException("Uuuuuups!! It's an empty root! No process attached!\n DrawableProcess in Root hasn't been initialized!");
        }
        return this.single;
    }

    public boolean hasSingleProcess() {
        return this.single != null;
    }

    @Override
    @NotNull
    public Rectangle getBounds(@NotNull DrawContext context) {
        return this.getSingleProcess().getBounds(context);
    }
}

