/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import oracle.bpm.adapter.DefaultAdaptable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableConnectionImpl;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.util.LoggingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableSequenceFlow
extends DrawableConnectionImpl<SequenceFlow>
implements DrawableFlowElement<SequenceFlow> {
    @Nullable
    private transient Point[] cachedPoints;
    private Color color = Color.BLACK;
    private static final int RHOMB_LENGTH = 18;
    private static final int RHOMB_WIDTH = 5;
    private static final Color RHOMB_FILL_NORMAL = Color.FUEGO_LIGHT_BLUE;
    private static final Color RHOMB_FILL_RULE = RHOMB_FILL_NORMAL.darker();
    private static final int SLASH_SEPARATION = 9;
    private static final int SLASH_LENGTH = 6;
    private static final int ARROW_LENGTH = 10;
    private static final int ARROW_WIDTH = 4;
    private static final int SELECTION_SIZE = 8;
    private static final int INTERSECTION_TOLERANCE = 8;
    private static final int HALF_INTERSECTION_TOLERANCE = 4;
    public static Image collapseMessageIcon = Image.create((Msg)ProjectDrawMsg.COLLAPSE_TRANSITION);
    public static Image expandMessageIcon = Image.create((Msg)ProjectDrawMsg.EXPAND_TRANSITION);
    static final long serialVersionUID = 1304599150200886359L;
    static final long serialCheck = 3323604635912220762L;

    protected DrawableSequenceFlow(@NotNull DrawableNodeContainer container, @NotNull SequenceFlow sequenceFlow) {
        super(container, sequenceFlow, DesignerLayer.TRANSITION);
        this.setup();
    }

    @Override
    @NotNull
    public DrawableNodeContainer getContainer() {
        return (DrawableNodeContainer)super.getContainer();
    }

    @NotNull
    public String getShortMessage(@NotNull DrawContext context) {
        SequenceFlow transition = (SequenceFlow)this.getModelObject();
        String result = null;
        switch (context.getTransitionMessageType()) {
            case NAME: {
                result = transition.getDefaultLabel();
                break;
            }
            case DESCRIPTION: {
                result = transition.getDefaultDescription();
                break;
            }
            case CONDITION: {
                if (!transition.isConditionalFlow()) break;
                ConditionalFlow conditionalFlow = transition.asConditionalFlow();
                result = conditionalFlow.getCondition().getExpressionValue();
                break;
            }
            default: {
                result = "";
            }
        }
        return result == null ? "" : result;
    }

    @NotNull
    public FlowNode getFrom() {
        return ((SequenceFlow)this.getModelObject()).getSource();
    }

    @NotNull
    public FlowNode getTo() {
        return ((SequenceFlow)this.getModelObject()).getTarget();
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public int getRightBound(@NotNull DrawContext context) {
        return 0;
    }

    @Override
    public int getUnderBound(@NotNull DrawContext context) {
        return 0;
    }

    @Deprecated
    public boolean contains(DrawContext context, oracle.bpm.geom.Rectangle r) {
        return !this.isHidden(context) && (this.isShowSelection() && (this.intersectsSource(r) || this.intersectsTarget(r)) || this.getPath().intersects(r));
    }

    @Override
    @NotNull
    public oracle.bpm.geom.Rectangle getBounds(@NotNull DrawContext context) {
        return AwtConverter.fromAwt((Rectangle)this.getPath().getBounds());
    }

    @NotNull
    public Point getControlPoint(DrawContext context) {
        Point point = ((SequenceFlow)this.getModelObject()).getControlPoint();
        return point.equals(SequenceFlow.NULL_CONTROL_POINT) ? point : context.scalePoint(point);
    }

    public Point getToLocation() {
        return this.getTo().getLocation();
    }

    public Point getFromLocation() {
        return this.getFrom().getLocation();
    }

    @Override
    public void refresh(@NotNull DrawContext context, @Nullable ProjectEvent event) {
        super.refresh(context, event);
        this.cachedPoints = null;
        this.setup();
        this.updatePath(context);
    }

    @Override
    public <T> T as(Class<T> targetType) {
        return DefaultAdaptable.create(this.getModelObject()).as(targetType);
    }

    @Override
    protected void drawOtherDecorations(@NotNull DrawContext context, @NotNull Path path) {
        super.drawOtherDecorations(context, path);
        FlowNode from = this.getFrom();
        if (!ModelUtils.isEndEvent(from)) {
            this.drawConditionDecorators(context, path);
        }
        this.drawLabel(context, path);
    }

    @Override
    protected void drawPath(@NotNull DrawContext context, @NotNull Path path) {
        Graphics graphics = context.getGraphics();
        Stroke s = graphics.getStroke();
        Color c = graphics.getForeground();
        Path scaled = path.scaled(context.getScale());
        boolean highlighted = context.isHighlighted((SequenceFlow)this.getModelObject());
        graphics.setForeground(this.getColor());
        if (highlighted) {
            graphics.setStroke(Stroke.FOUR_SOLID);
            graphics.setForeground(Color.DARK_GREEN);
        }
        if (this.isShowSelection()) {
            graphics.setStroke(Stroke.TWO_SOLID);
        }
        graphics.draw((Shape)scaled);
        if (!highlighted || !this.isShowSelection()) {
            graphics.setStroke(s);
        }
        this.drawArrow(context, scaled);
        if (highlighted) {
            graphics.setStroke(Stroke.ONE_SOLID);
            graphics.setForeground(Color.BLACK);
            graphics.draw((Shape)scaled);
            graphics.setForeground(Color.BLACK);
            this.drawArrow(context, scaled);
        }
        if (highlighted || this.isShowSelection()) {
            graphics.setStroke(s);
        }
        graphics.setForeground(c);
        this.drawOtherDecorations(context, scaled);
    }

    private void setup() {
        SequenceFlow sequence = (SequenceFlow)this.getModelObject();
        this.source.setDrawable(this.getContainer().asDrawable(sequence.getSource()));
        this.target.setDrawable(this.getContainer().asDrawable(sequence.getTarget()));
        if (sequence.getRoutingMode() != RoutingMode.STRAIGHT) {
            this.control.setLocation(sequence.getControlPoint());
            if (sequence.getControlPoint().equals(SequenceFlow.NULL_CONTROL_POINT)) {
                LoggingUtils.assertLog("DrawableSequenceFlow.setup", "SequenceFlow " + this.getModelObject() + " not defined as straight with Null Control Point!");
                LoggingUtils.assertDumpStack();
            }
        }
    }

    private boolean intersectsTarget(oracle.bpm.geom.Rectangle rectangle) {
        return false;
    }

    private boolean intersectsSource(oracle.bpm.geom.Rectangle rectangle) {
        return false;
    }

    private void drawConditionDecorators(@NotNull DrawContext context, @NotNull Path path) {
        FlowNode from = this.getFrom();
        if (((SequenceFlow)this.getModelObject()).isConditionalFlow()) {
            if (!from.isGateway()) {
                this.drawRhomb(context, path, RHOMB_FILL_NORMAL);
            }
        } else if (from.isGateway() && !from.getOutgoingConditionalFlows().isEmpty()) {
            this.drawSlash(context, path);
        }
    }

    private void drawLabel(@NotNull DrawContext context, @NotNull Path p) {
        String label = this.getShortMessage(context);
        if (label.length() > 0) {
            Point2D point = this.getPathPoint(p, 0.5);
            Graphics g = context.getGraphics();
            Font original = g.getFont();
            g.setFont(this.getTransitionFont(context).scale(context.getScale()));
            int l = g.getFontMetrics().stringWidth(label);
            int x = (int)point.getX() - l / 2;
            int y = (int)point.getY() + g.getFontMetrics().getAscent() / 2;
            g.drawString(label, x, y, Color.WHITE);
            g.setFont(original);
        }
    }

    private Font getTransitionFont(DrawContext context) {
        return context.getTheme().getActivityFont(this.isShowSelection());
    }

    private void drawRhomb(@NotNull DrawContext context, @NotNull Path path, @NotNull Color fill) {
        Point2D basePoint = this.getPathPoint(path, 0.0);
        Point2D endPoint = path.findPoint(basePoint, context.scale(18), 0.0);
        double y1 = endPoint.getY();
        context.getGraphics().drawRhomb(basePoint.getX(), basePoint.getY(), endPoint.getX(), y1, context.scale(5), fill);
    }

    private void drawSlash(@NotNull DrawContext context, @NotNull Path path) {
        Point2D p1 = this.getPathPoint(path, 0.0);
        Point2D point = path.findPoint(p1, context.scale(9), 0.0);
        int w = context.scale(6);
        double x = point.getX();
        double y = point.getY();
        double slope = Point.angle(p1.getX(), -p1.getY(), x, -y) - 0.7853981633974483;
        double dx = (double)w * Math.cos(slope);
        double dy = (double)w * Math.sin(slope);
        context.getGraphics().drawLine((int)Math.round(x + dx), (int)Math.round(y - dy), (int)Math.round(x - dx), (int)Math.round(y + dy));
    }
}

