/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.NullModelObject;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;

public class DrawableRoot
extends DrawableImpl<NullModelObject> {
    private final PaintCanvas canvas;
    private static int drawableObjectSerial = 0;

    protected DrawableRoot(PaintCanvas canvas) {
        super(null, NullModelObject.getInstance(), DesignerLayer.ROOT);
        this.canvas = canvas;
    }

    public static int nextSerialId() {
        return ++drawableObjectSerial;
    }

    @Override
    public void add() {
        throw new IllegalStateException("Drawable Root cannot be added nor removed!");
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Drawable Root cannot be added nor removed!");
    }

    @Override
    @NotNull
    public Point getLocation() {
        return Point.ORIGIN;
    }

    @Override
    @NotNull
    public Rectangle getBounds(@NotNull DrawContext context) {
        Rectangle result = Rectangle.ZERO;
        for (Drawable child : this.getDrawables()) {
            result = result.union(child.getBounds(context));
        }
        return result;
    }

    public Dimension getCanvasSize() {
        Dimension result = this.canvas != null ? this.canvas.getScrollPaneViewportSize() : Dimension.ZERO;
        return result;
    }

    @Override
    public int getWidth(@NotNull DrawContext context) {
        throw new IllegalStateException("DrawableRoot");
    }

    @Override
    public int getHeight(@NotNull DrawContext context) {
        throw new IllegalStateException("DrawableRoot");
    }
}

