/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Predicate;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainerImpl;
import oracle.bpm.draw.DrawableRoot;
import oracle.bpm.draw.renderer.ProcessRenderer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableProcess
extends DrawableNodeContainerImpl<Process> {
    protected DrawableProcess(@NotNull DrawableRoot root, @NotNull Process process) {
        super(root, process, DesignerLayer.PROCESS);
    }

    @Override
    @NotNull
    public Point getLocation() {
        return Point.ORIGIN;
    }

    @Override
    public int getWidth(@NotNull DrawContext context) {
        return this.getBounds(context).getWidth();
    }

    @Override
    public int getHeight(@NotNull DrawContext context) {
        return this.getBounds(context).getHeight();
    }

    @Override
    @NotNull
    public Rectangle getBounds(@NotNull DrawContext context) {
        return Rectangle.valueOf(this.getLocation(), this.getDimension(context));
    }

    @Override
    protected Renderer createRenderer() {
        return ProcessRenderer.create(this);
    }

    private Dimension getDimension(DrawContext context) {
        int maxX = 0;
        int maxY = 0;
        NotHiddenPredicate notHidden = new NotHiddenPredicate(context);
        for (Drawable child : this.getDrawables().select(notHidden)) {
            if (!(child instanceof DrawableFlowElement)) continue;
            DrawableFlowElement element = (DrawableFlowElement)child;
            int rightBound = element.getRightBound(context);
            maxX = Math.max(maxX, rightBound);
            int underBound = element.getUnderBound(context);
            maxY = Math.max(maxY, underBound);
        }
        return Dimension.valueOf(maxX, maxY);
    }

    private static class NotHiddenPredicate
    implements Predicate<Drawable> {
        private DrawContext context;

        private NotHiddenPredicate(DrawContext context) {
            this.context = context;
        }

        @Override
        public boolean check(@Nullable Drawable drawable) {
            return drawable != null && !drawable.isHidden(this.context) && !DesignerLayer.LABEL.equals((Object)drawable.getLayer());
        }
    }
}

