/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.print.PageFormat;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class DrawableLane
extends DrawableFlowElementImpl<LaneImpl> {
    protected DrawableLaneColumn laneColumn = new DrawableLaneColumn(this);
    private FontMetrics lastFontMetrics;
    public static final int LANE_NAME_SIZE = 25;
    private static Map<String, Image> roleLabels;

    protected DrawableLane(@NotNull DrawableNodeContainer<?> content, @NotNull LaneImpl lane) {
        super(content, lane, DesignerLayer.LANE_NAME);
    }

    public static Font getLaneFont(DrawContext context, boolean selected) {
        if (context == null) {
            context = DrawContext.getDefault();
        }
        return context.getTheme().getLaneFont(selected);
    }

    @Override
    @NotNull
    public Rectangle getBounds(@NotNull DrawContext context) {
        return new Rectangle(this.getLocation(), Dimension.valueOf(this.getWidth(context), this.getHeight(context)));
    }

    public DrawableLaneColumn getDrawableLaneColumn() {
        return this.laneColumn;
    }

    public Font getFont(DrawContext context) {
        Font result = DrawableLane.getLaneFont(context, this.isShowSelection());
        if (context.getScale() != DrawContext.DEFAULT_SCALE) {
            result = result.scale(context.getScale());
        }
        return result;
    }

    @Override
    public int getHeight(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? ((LaneImpl)this.getModelObject()).getSize() : 25;
    }

    @Override
    public boolean isHidden(@NotNull DrawContext context) {
        return ((LaneImpl)this.getModelObject()).getSize() == 1 || context.isRenderFlowOnly();
    }

    @Override
    public int getRightBound(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? 25 : ((LaneImpl)this.getModelObject()).getOffset() + ((LaneImpl)this.getModelObject()).getSize();
    }

    @Override
    public int getUnderBound(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? ((LaneImpl)this.getModelObject()).getOffset() + ((LaneImpl)this.getModelObject()).getSize() : 25;
    }

    @Override
    public int getWidth(@NotNull DrawContext context) {
        return context.isHorizontalDrawing() ? 25 : ((LaneImpl)this.getModelObject()).getSize();
    }

    @Override
    public int compareTo(Drawable d) {
        int ret = this.getSerialId() - d.getSerialId();
        if (ret != 0) {
            if (d.getWidth(DrawContext.getDefault()) == 1 && ((LaneImpl)this.getModelObject()).getSize() != 1) {
                ret = -1;
            } else if (d.getWidth(DrawContext.getDefault()) != 1 && ((LaneImpl)this.getModelObject()).getSize() == 1) {
                ret = 1;
            }
        }
        return ret;
    }

    @Override
    public boolean contains(int unscaledX, int unscaledY, @NotNull DrawContext context) {
        boolean horizontal = context.isHorizontalDrawing();
        unscaledY -= horizontal ? 0 : context.unscale(context.getDeltaY());
        int n = horizontal ? context.unscale(context.getDeltaX()) : 0;
        int x = this.getLocation().getX();
        int y = this.getLocation().getY();
        int w = this.getWidth(context);
        int h = this.getHeight(context);
        return (unscaledX -= n) >= x && unscaledY >= y && unscaledX < x + w && unscaledY < y + h;
    }

    @Override
    @NotNull
    public Point getLocation() {
        Point location = new Point(((LaneImpl)this.getModelObject()).getOffset(), 0);
        if (ModelUtils.isHorizontal(this.getProcess())) {
            location = location.transposed();
        }
        return location;
    }

    @Override
    public void draw(@NotNull DrawContext context) {
        if (context.isHorizontalDrawing()) {
            this.drawHorizontal(context);
        } else {
            this.drawVertical(context);
        }
        super.draw(context);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
        return this.laneColumn.intersects(rectangle, context);
    }

    public String getDisplayName() {
        if (((LaneImpl)this.getModelObject()).isAutomatic()) {
            return ProjectMsg.AUTOMATIC_HANDLER_ROLE.getString();
        }
        if (((LaneImpl)this.getModelObject()).isAll()) {
            return ProjectMsg.ALL_ROLE.getString();
        }
        String label = ((LaneImpl)this.getModelObject()).getDefaultLabel();
        return label == null ? ((LaneImpl)this.getModelObject()).getName() : label;
    }

    public Lane getLane() {
        return (Lane)this.getModelObject();
    }

    @Override
    public void add() {
        super.add();
        this.getDrawableLaneColumn().add();
    }

    protected FontMetrics getFontMetrics(DrawContext context) {
        if (Ui.isHeadless()) {
            return null;
        }
        Graphics graphics = context.getGraphics();
        if (graphics != null && !graphics.isDisposed()) {
            this.lastFontMetrics = graphics.getFontMetrics(this.getFont(context));
        }
        return this.lastFontMetrics;
    }

    protected boolean isPrinting() {
        return false;
    }

    protected Color getRoleBackground() {
        return Color.LIGHT_GRAY;
    }

    private static Color getFontColor(DrawContext context) {
        return context.getTheme().getRoleFontColor();
    }

    private static Color getFontSelectedColor(DrawContext context) {
        return context.getTheme().getSelectedRoleFontColor();
    }

    private static Map<String, Image> getRoleLabels() {
        if (roleLabels == null) {
            roleLabels = new HashMap<String, Image>();
        }
        return roleLabels;
    }

    private void draw3DSq(DrawContext context, int x, int y, int width, int height) {
        Graphics g = context.getGraphics();
        Rectangle rectangle = new Rectangle(x, y, width, height);
        Color color = this.isShowSelection() ? Color.FUEGO_LIGHT_BLUE.darker() : (!((LaneImpl)this.getModelObject()).isAutomatic() ? Color.FUEGO_LIGHT_BLUE : Color.LIGHT_GRAY);
        g.setForeground(color);
        g.fill(rectangle);
        g.setStroke(Stroke.ONE_SOLID);
        g.setForeground(Color.BLACK);
        g.draw(rectangle);
    }

    private Color getRoleFontColor(DrawContext context) {
        Color color = this.isShowSelection() ? DrawableLane.getFontSelectedColor(context) : DrawableLane.getFontColor(context);
        return color;
    }

    private void drawHorizontal(DrawContext context) {
        Graphics g = context.getGraphics();
        if (g == null) {
            return;
        }
        float scale = context.getScale();
        Font oldFont = g.getFont();
        g.setFont(this.getFont(context));
        String titleToShow = this.buildTitleToShow();
        String key = titleToShow + scale + this.isShowSelection();
        Color fontColor = DrawableLane.getFontColor(context);
        Color fontSelectedColor = DrawableLane.getFontSelectedColor(context);
        key = key + fontColor.toString() + fontSelectedColor.toString();
        Image verticalLabelImage = DrawableLane.getRoleLabels().get(key);
        if (verticalLabelImage == null) {
            verticalLabelImage = this.buildVerticalLabelImage(context, key, titleToShow);
        }
        if (((LaneImpl)this.getModelObject()).getName() != null) {
            Color color = this.isShowSelection() ? this.getRoleBackground().darker() : Color.LIGHT_GRAY;
            g.setForeground(color);
            this.drawRoleRectangle(context);
            g.setForeground(this.getRoleFontColor(context));
            if (((LaneImpl)this.getModelObject()).isAutomatic()) {
                return;
            }
            if (verticalLabelImage != null) {
                this.drawVerticalImage(context, fontSelectedColor, verticalLabelImage);
            }
        }
        g.setFont(oldFont);
    }

    private void drawRoleRectangle(DrawContext context) {
        float scale = context.getScale();
        Point location = this.getDrawDeltaLocation(context);
        this.draw3DSq(context, location.getX(), location.getY(), Math.round((float)this.getWidth(context) * scale), Math.round((float)this.getHeight(context) * scale));
    }

    private void drawVerticalImage(DrawContext context, Color fontSelectedColor, Image verticalLabelImage) {
        Graphics g = context.getGraphics();
        float scale = context.getScale();
        if (this.isShowSelection()) {
            g.setForeground(fontSelectedColor);
        }
        UiContainer imageObserver = context.getContainer();
        int x = (Math.round((float)this.getHeight(context) * scale) - verticalLabelImage.getWidth()) / 2;
        Point location = this.getDrawDeltaLocation(context);
        int containerWidth = Math.round((float)this.getWidth(context) * scale);
        int containerHeight = Math.round((float)this.getHeight(context) * scale);
        int deltaX = (containerWidth - verticalLabelImage.getWidth()) / 2;
        int deltaY = (containerHeight - verticalLabelImage.getHeight()) / 2;
        g.drawImage(verticalLabelImage, location.getX() + deltaX, location.getY() + deltaY, (UiComponent)imageObserver);
    }

    private Point getDrawDeltaLocation(@NotNull DrawContext context) {
        int x;
        float scale = context.getScale();
        int n = context.isHorizontalDrawing() ? (context.isPrinting() ? 0 : context.getDeltaX()) : (x = Math.round((float)((LaneImpl)this.getModelObject()).getOffset() * scale));
        int y = context.isHorizontalDrawing() ? Math.round((float)((LaneImpl)this.getModelObject()).getOffset() * scale) : (context.isPrinting() ? 0 : context.getDeltaY());
        return new Point(x, y);
    }

    private String buildTitleToShow() {
        String titleToShow = ((LaneImpl)this.getModelObject()).getParamName() != null && !"".equals(((LaneImpl)this.getModelObject()).getParamName()) ? this.getDisplayName() + " (" + ((LaneImpl)this.getModelObject()).getParamName() + ")" : this.getDisplayName();
        return titleToShow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image buildVerticalLabelImage(DrawContext context, String key, String titleToShow) {
        int labelImageHeight;
        Font f;
        Graphics g = context.getGraphics();
        FontMetrics fm1 = g.getFontMetrics(f = this.getFont(context));
        int labelImageWidth = fm1.stringWidth(titleToShow);
        BufferedImage image = new BufferedImage(labelImageWidth, labelImageHeight = fm1.getMaxAscent() + fm1.getMaxDescent(), 2);
        Image result = Image.create((int)image.getWidth(), (int)image.getHeight());
        if (result == null) {
            try {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gs.getDefaultConfiguration();
                BufferedImage image1 = gc.createCompatibleImage(labelImageWidth, labelImageHeight, 1);
                result = Image.create((int)image1.getWidth(), (int)image1.getHeight());
            }
            catch (UnsupportedOperationException e) {
                return null;
            }
        }
        Graphics g2 = result.getGraphics();
        try {
            g2.setFont(f);
            if (this.isShowSelection()) {
                g2.setForeground(Color.FUEGO_LIGHT_BLUE.darker());
            } else {
                g2.setForeground(Color.FUEGO_LIGHT_BLUE);
            }
            Rectangle rectangle = new Rectangle(0, 0, labelImageWidth, labelImageHeight);
            g2.fill(rectangle);
            g2.draw(rectangle);
            g2.setForeground(Color.BLACK);
            g2.drawString(titleToShow, 0, fm1.getMaxAscent());
        }
        finally {
            g2.dispose();
        }
        result = result.rotate90cc();
        roleLabels.put(key, result);
        return result;
    }

    private void drawVertical(DrawContext context) {
        float scale = context.getScale();
        Point location = this.getLocation();
        int locX = location.getX();
        Graphics g = context.getGraphics();
        if (g == null) {
            return;
        }
        if (((LaneImpl)this.getModelObject()).getName() == null) {
            return;
        }
        g.setForeground(Color.LIGHT_GRAY);
        int width = 0;
        Font f = this.getFont(context);
        FontMetrics fm1 = g.getFontMetrics(f);
        int height = Math.round((float)this.getHeight(context) * scale);
        if (this.isPrinting()) {
            Lane lastLane = LaneUtils.getLastLane(((LaneImpl)this.getModelObject()).getProcess());
            if (locX == lastLane.getOffset() && context.isCompletePageWithLastRole()) {
                PageFormat pf = context.getPageFormat(new PageFormat());
                int pageWidth = (int)pf.getImageableWidth();
                int scaledLastX = Math.round((float)locX * scale) + Math.round((float)((LaneImpl)this.getModelObject()).getSize() * scale);
                int cant = (int)Math.ceil((double)scaledLastX / (double)pageWidth);
                width = Math.round((float)(cant * pageWidth) * scale - (float)locX * scale);
                this.draw3DSq(context, Math.round((float)locX * scale), 0, width, Math.round(height));
            } else {
                this.draw3DSq(context, Math.round((float)locX * scale), 0, Math.round((float)((LaneImpl)this.getModelObject()).getSize() * scale), Math.round(height));
            }
        } else {
            this.draw3DSq(context, Math.round((float)locX * scale), context.getDeltaY(), Math.round((float)((LaneImpl)this.getModelObject()).getSize() * scale), Math.round(height + 5));
        }
        if (((LaneImpl)this.getModelObject()).isAutomatic()) {
            return;
        }
        Color fontColor = this.isShowSelection() ? DrawableLane.getFontSelectedColor(context) : DrawableLane.getFontColor(context);
        g.setForeground(fontColor);
        String titleToShow = this.buildTitleToShow();
        Font originalFont = g.getFont();
        g.setFont(this.getFont(context));
        if (this.isPrinting()) {
            Lane lastLane = LaneUtils.getLastLane(((LaneImpl)this.getModelObject()).getProcess());
            if (locX == lastLane.getOffset()) {
                g.drawString(titleToShow, Math.round((float)locX * scale + (float)(width / 2)) - Math.round(fm1.stringWidth(titleToShow) / 2), Math.round(height / 2 + fm1.getMaxAscent() / 3));
            } else {
                g.drawString(titleToShow, Math.round((float)(locX + ((LaneImpl)this.getModelObject()).getSize() / 2) * scale) - Math.round(fm1.stringWidth(titleToShow) / 2), Math.round(height / 2 + fm1.getMaxAscent() / 3));
            }
        } else {
            g.drawString(titleToShow, Math.round((float)(locX + ((LaneImpl)this.getModelObject()).getSize() / 2) * scale) - Math.round(fm1.stringWidth(titleToShow) / 2), context.getDeltaY() + Math.round(height / 2 + fm1.getAscent() / 2));
        }
        g.setFont(originalFont);
        g.setForeground(Color.BLACK);
    }
}

