/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.Locale;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class DrawableLabel<T extends FlowElement>
extends DrawableFlowElementImpl<T> {
    private LabelAlignment alignment;
    private Rectangle bounds;
    private Insets insets = Insets.EMPTY;
    private String label;
    private LabelLocation location;
    private DrawableFlowElement owner;
    private Point ownerLocation;
    private float scale;
    private boolean wasSelected;
    public static final Insets TOP_BOTTOM_LABEL_INSETS = new Insets(8, 0, 8, 0);

    private DrawableLabel(@NotNull DrawableNodeContainer<?> container, @NotNull DrawableFlowElement<T> owner) {
        super(container, owner.getModelObject(), DesignerLayer.LABEL);
        this.owner = owner;
        this.location = LabelLocation.BOTTOM;
        this.alignment = LabelAlignment.CENTER;
        this.insets = TOP_BOTTOM_LABEL_INSETS;
    }

    public static <E extends FlowElement> DrawableLabel<E> create(@NotNull DrawableNodeContainer<?> conainer, @NotNull DrawableFlowElement<E> owner) {
        return new DrawableLabel<E>(conainer, owner);
    }

    @Override
    @NotNull
    public Point getLocation() {
        return this.getBounds(DrawContext.getDefault()).getOrigin();
    }

    @Override
    public int getWidth(@NotNull DrawContext context) {
        return this.getBounds(context).getWidth();
    }

    @Override
    public int getHeight(@NotNull DrawContext context) {
        return this.getBounds(context).getHeight();
    }

    @Override
    @NotNull
    public Rectangle getBounds(@NotNull DrawContext context) {
        this.updateBounds(context);
        return this.bounds;
    }

    @Override
    public void draw(@NotNull DrawContext context) {
        Rectangle bounds = context.scaleRectangle(this.getBounds(context));
        if (Str.isEmpty(this.label) || this.isBoundaryEvent()) {
            return;
        }
        Font prevFont = this.setupGraphics(context);
        Graphics graphics = context.getGraphics();
        Color prevColor = graphics.getForeground();
        graphics.setForeground(Color.BLACK);
        graphics.drawString(this.label, bounds, Color.TRANSLUCENT);
        graphics.setForeground(prevColor);
        graphics.setFont(prevFont);
    }

    public LabelLocation getLabelLocation() {
        return this.location;
    }

    public void setLabelLocation(@NotNull LabelLocation location) {
        this.location = location;
    }

    public LabelAlignment getLabelAlignment() {
        return this.alignment;
    }

    public void setLabelAlignment(@NotNull LabelAlignment alignment) {
        this.alignment = alignment;
    }

    public void setInsets(@NotNull Insets insets) {
        this.insets = insets;
    }

    private String getModelObjectLabel(@NotNull DrawContext context) {
        Locale locale = context.getLocale();
        String label = null;
        if (locale != null) {
            label = ((FlowElement)this.getModelObject()).getLabel(locale);
        }
        if (Str.isEmpty(label)) {
            label = ((FlowElement)this.getModelObject()).getDefaultLabel();
        }
        return label;
    }

    private void updateBounds(@NotNull DrawContext context) {
        if (this.needsUpdate(context)) {
            Graphics graphics = context.getGraphics();
            Font oldFont = this.setupGraphics(context);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int width = context.unscale(this.calculateLabelWidth(context, fontMetrics));
            int height = context.unscale(this.calculateLabelHeight(context, fontMetrics));
            Point topLeft = this.getTopLeftLocationAtContext(context, width, height);
            this.bounds = Rectangle.valueOf(topLeft, width, height);
            this.scale = context.getScale();
            this.label = this.getModelObjectLabel(context);
            this.ownerLocation = this.owner.getLocation();
            this.wasSelected = this.owner.isShowSelection();
            graphics.setFont(oldFont);
        }
    }

    private boolean needsUpdate(DrawContext context) {
        return this.bounds == null || context.getScale() != this.scale || this.owner.isShowSelection() != this.wasSelected || !this.getModelObjectLabel(context).equals(this.label) || !this.owner.getLocation().equals(this.ownerLocation);
    }

    private int calculateLabelWidth(@NotNull DrawContext context, @NotNull FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(this.getModelObjectLabel(context));
    }

    private int calculateLabelHeight(@NotNull DrawContext context, @NotNull FontMetrics fontMetrics) {
        return fontMetrics.getMaxAscent();
    }

    private Point getTopLeftLocationAtContext(@NotNull DrawContext context, int width, int height) {
        Point result = this.getCenterLocationAtContext(context);
        switch (this.alignment) {
            case LEFT: {
                result = result.translate(0, -height / 2);
                break;
            }
            case CENTER: {
                result = result.translate(-width / 2, -height / 2);
                break;
            }
            case RIGHT: {
                result = result.translate(-width, -height / 2);
            }
        }
        return result;
    }

    private Point getCenterLocationAtContext(@NotNull DrawContext context) {
        Point result = this.location.calculateLocationOnBounds(this.owner.getBounds(context));
        Dimension delta = this.location.calculateDeltaForInsets(this.insets);
        return result.translate(delta);
    }

    private Font setupGraphics(@NotNull DrawContext context) {
        Font oldFont = context.getGraphics().getFont();
        context.getGraphics().setFont(this.getScaledFont(context));
        return oldFont;
    }

    private Font getScaledFont(DrawContext context) {
        return context.getTheme().getActivityFont(this.owner.isShowFocus()).scale(context.getScale());
    }

    private boolean isBoundaryEvent() {
        boolean result = false;
        if (this.getModelObject() instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)this.getModelObject();
            result = ModelUtils.isBoundaryEvent(flowNode);
        }
        return result;
    }

    public static enum LabelAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum LabelLocation {
        TOP_LEFT(0.0, 0.0),
        TOP(0.5, 0.0),
        TOP_RIGHT(1.0, 0.0),
        CENTER_LEFT(0.0, 0.5),
        CENTER(0.5, 0.5),
        CENTER_RIGHT(1.0, 0.5),
        BOTTOM_LEFT(0.0, 1.0),
        BOTTOM(0.5, 1.0),
        BOTTOM_RIGHT(1.0, 1.0);

        private double xFactor;
        private double yFactor;

        private LabelLocation(double xFactor, double yFactor) {
            this.xFactor = xFactor;
            this.yFactor = yFactor;
        }

        protected Point calculateLocationOnBounds(@NotNull Rectangle bounds) {
            return bounds.getOrigin().translate((int)((double)bounds.getWidth() * this.xFactor), (int)((double)bounds.getHeight() * this.yFactor));
        }

        protected Dimension calculateDeltaForInsets(@NotNull Insets insets) {
            int deltaX = 0;
            int deltaY = 0;
            if (this == TOP_LEFT || this == TOP || this == TOP_RIGHT) {
                deltaY -= insets.top;
            }
            if (this == BOTTOM_LEFT || this == BOTTOM || this == BOTTOM_RIGHT) {
                deltaY += insets.bottom;
            }
            if (this == TOP_LEFT || this == CENTER_LEFT || this == BOTTOM_LEFT) {
                deltaX -= insets.left;
            }
            if (this == TOP_RIGHT || this == CENTER_RIGHT || this == BOTTOM_RIGHT) {
                deltaX += insets.right;
            }
            return Dimension.valueOf(deltaX, deltaY);
        }
    }
}

