/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

public class DrawableHelper {
    public static double outbound(@NotNull DrawContext context, @NotNull Drawable drawable, @NotNull Path path, boolean fwd) {
        int low = fwd ? 0 : 100;
        int high = fwd ? 9900 : 10000;
        double result = 0.0;
        while (high > low) {
            int mid = (low + high) / 2;
            result = (double)mid * 1.0E-4;
            Point2D point = path.eval(result);
            boolean inside = drawable.contains((int)point.getX(), (int)point.getY(), context);
            if (fwd ? inside : !inside) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return result + (fwd ? 1.0E-4 : -1.0E-4);
    }

    public static DrawableFlowElement<?> findDrawableRecursively(@NotNull DrawableNodeContainer<?> container, @NotNull FlowElement element) {
        DrawableFlowElement<?> result = null;
        DrawableFlowElement<?> drawable = container.getDrawableFor(element);
        if (drawable != null) {
            result = drawable;
        } else {
            DrawableNodeContainer inner;
            Sequence<DrawableNodeContainer> inners = CollectionUtils.selectInstanceOf(container.getDrawables(), DrawableNodeContainer.class);
            Iterator<DrawableNodeContainer> i$ = inners.iterator();
            while (i$.hasNext() && (result = DrawableHelper.findDrawableRecursively(inner = i$.next(), element)) == null) {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static oracle.bpm.ui.Image createImageForDrawable(@NotNull DrawableFlowElement drawable, @NotNull DrawContext context) {
        Rectangle bounds = drawable.getBounds(context).expand(1);
        BufferedImage buffered = new BufferedImage(bounds.getWidth(), bounds.getHeight(), 2);
        oracle.bpm.ui.Image result = oracle.bpm.ui.Image.create((Image)buffered);
        Graphics graphics = result.getGraphics();
        graphics.translate(-bounds.getX(), -bounds.getY());
        try {
            context.setRectangle(bounds);
            context.setGraphics(graphics);
            context.setAntialiasing(AntialiasingMode.ON);
            drawable.draw(context);
        }
        finally {
            graphics.dispose();
        }
        return result;
    }

    public static enum TransitionAnchor {
        FROM,
        MIDDLE,
        TO,
        NONE;

    }
}

