/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowNodeImpl;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableEvent
extends DrawableFlowNodeImpl<Event> {
    protected DrawableEvent(@NotNull DrawableNodeContainer<?> container, @NotNull Event event) {
        super(container, event, ModelUtils.isBoundaryEvent(event) ? DesignerLayer.BOUNDARY : DesignerLayer.EVENT);
    }

    public static Point calculateLocationFromActivity(@NotNull DrawContext context, @NotNull Drawable drawable, @NotNull Point location) {
        Point begin = drawable.getLocation();
        Point end = location;
        while (drawable.contains(end.getX(), end.getY(), context)) {
            if (!begin.equals(end = new Point(end.getX() + 2 * (end.getX() - begin.getX()), end.getY() + 2 * (end.getY() - begin.getY())))) continue;
            end = begin.translate(drawable.getWidth(context), 0);
            break;
        }
        Line path = new Line(begin, end);
        double point = DrawableHelper.outbound(context, drawable, path, true);
        return new Point(path.eval(point));
    }

    public static void updateBoundaries(@NotNull DrawContext context, @NotNull Drawable container, @NotNull Activity activity) {
        DrawableFlowElement drawable = ((DrawableNodeContainer)container).asDrawable(activity);
        for (BoundaryEvent boundary : activity.getActivityBoundaryEvents()) {
            Point calculated;
            Point original = boundary.getLocation();
            if (!(original.distanceSq(calculated = DrawableEvent.calculateLocationFromActivity(context, drawable, original)) > 2.0)) continue;
            boundary.setLocation(calculated);
        }
    }

    @Override
    public void refresh(@NotNull DrawContext context, @Nullable ProjectEvent event) {
        boolean isBoundary;
        super.refresh(context, event);
        boolean bl = isBoundary = ((Event)this.getModelObject()).isCatchEvent() && ((Event)this.getModelObject()).asAnyNode(CatchEvent.class).isBoundaryEvent();
        if (isBoundary) {
            DrawableFlowElement activity = this.getContainer().asDrawable(this.getBoundaryActivity());
            Point calculated = DrawableEvent.calculateLocationFromActivity(context, activity, ((Event)this.getModelObject()).getLocation());
            this.setLocation(calculated);
        }
    }

    private Activity getBoundaryActivity() {
        return ((Event)this.getModelObject()).asAnyNode(BoundaryEvent.class).getBoundaryActivity();
    }
}

