/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.geom.Point2D;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.draw.ActivityTitle;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.TransitionMessageType;
import oracle.bpm.draw.preferences.DesignerPageFormat;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.print.PageFormat;
import oracle.bpm.print.PaperModel;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import org.jetbrains.annotations.NotNull;

public class DrawContext {
    private TreeMap<String, Image> activityIcons = new TreeMap();
    private TreeMap<String, String> activityLabels = new TreeMap();
    private ActivityTitle activityTitleType = ActivityTitle.NAME_AS_TITLE;
    private Color background = Color.WHITE;
    private DrawableFlowElement centeredObject;
    private float centeredObjectMagnifyScale;
    private boolean completePageWithLastRole = false;
    private UiContainer container;
    private int deltaX;
    private int deltaY;
    private boolean drawableBounds = false;
    private boolean drawableDebug = false;
    private boolean drawableRedrawRegions = false;
    private boolean drawBorder;
    private FontMetrics fontMetrics;
    private Graphics graphics;
    @NotNull
    private Grid grid;
    private boolean groupInheritedMembers = true;
    private boolean headless;
    private HashSet<String> highLightedActivities = new HashSet();
    private HashMap<SequenceFlow, Integer> highLightedTransitions = new HashMap();
    private boolean horizontalDrawing = true;
    private boolean isPrinting;
    private Locale locale = Locale.getDefault();
    private DesignerPageFormat pageFormat;
    private Rectangle rectangle;
    private boolean renderFlowOnly = false;
    private float scale = DEFAULT_SCALE;
    private boolean showConditionalTransitions_d = true;
    private boolean showDueTransitions_d = true;
    private boolean showExceptionTransitions = true;
    private boolean showGrabActivities_d = true;
    private boolean showGrabTransitions_d = true;
    private boolean showGrid_d = false;
    private boolean showMeasurementMarks = true;
    private boolean showNotes = true;
    private boolean showUnconditionalTransitions_d = true;
    private int startX;
    private int startY;
    private DefaultTheme theme = DefaultTheme.getDefault();
    private TransitionMessageType transitionMessageType = TransitionMessageType.NAME;
    public static float DEFAULT_SCALE = 1.0f;
    private static DrawContext defaultContext;

    public DrawContext() {
        this.grid = Grid.createNull();
    }

    public static DrawContext getDefault() {
        if (defaultContext == null) {
            defaultContext = new DrawContext();
        }
        return defaultContext;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setActivityTitleType(ActivityTitle activityTitleType) {
        this.activityTitleType = activityTitleType;
    }

    public ActivityTitle getActivityTitleType() {
        return this.activityTitleType;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setCenteredObject(DrawableFlowElement obj, float scale) {
        if (scale < DEFAULT_SCALE) {
            scale = DEFAULT_SCALE;
        }
        this.centeredObjectMagnifyScale = scale;
        this.centeredObject = obj;
    }

    public DrawableFlowElement getCenteredObject() {
        return this.centeredObject;
    }

    public float getCenteredObjectMagnifyScale() {
        return this.centeredObjectMagnifyScale;
    }

    public void setCompletePageWithLastRole(boolean completePageWithLastRole) {
        this.completePageWithLastRole = completePageWithLastRole;
    }

    public boolean isCompletePageWithLastRole() {
        return this.completePageWithLastRole;
    }

    public void setContainer(UiContainer c) {
        this.container = c;
    }

    public UiContainer getContainer() {
        return this.container;
    }

    public void setDrawBorder(boolean value) {
        this.drawBorder = value;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setGraphics(Graphics g) {
        this.graphics = g;
        if (g != null && !g.isDisposed()) {
            this.fontMetrics = g.getFontMetrics();
        }
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void setGrid(@NotNull Grid grid) {
        this.grid = grid;
    }

    @NotNull
    public Grid getGrid() {
        return this.grid;
    }

    public Point alignPoint(Point p) {
        return this.grid.align(p);
    }

    public void setGroupInherited(boolean doGroup) {
        this.groupInheritedMembers = doGroup;
    }

    public boolean getGroupInherited() {
        return this.groupInheritedMembers;
    }

    public int getHighlightCount(SequenceFlow fuegoSequenceFlow) {
        Integer amount = this.highLightedTransitions.get(fuegoSequenceFlow);
        if (amount == null) {
            return 0;
        }
        return amount;
    }

    public boolean isHighlighted(DrawableFlowElement drawableFlowNode) {
        return this.highLightedActivities.contains(drawableFlowNode.getModelObject().getId());
    }

    public boolean isHighlighted(SequenceFlow trans) {
        return this.highLightedTransitions.get(trans) != null;
    }

    public void setHorizontalDrawing(boolean horizontalDrawing) {
        this.horizontalDrawing = horizontalDrawing;
    }

    public boolean isHorizontalDrawing() {
        return this.horizontalDrawing;
    }

    public void setIconForActivity(String activityId, Image icon) {
        this.activityIcons.put(activityId.toLowerCase(), icon);
    }

    public Image getIconForActivity(String activityId) {
        return this.activityIcons.get(activityId.toLowerCase());
    }

    public void setLabelForActivity(String activityId, String text) {
        this.activityLabels.put(activityId.toLowerCase(), text);
    }

    public String getLabelForActivity(String activityId) {
        return this.activityLabels.get(activityId.toLowerCase());
    }

    public void setLocale(Locale l) {
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setPageFormat(PageFormat pf) {
        if (this.pageFormat == null) {
            this.pageFormat = new DesignerPageFormat();
        }
        this.pageFormat.setOrientation(pf.getOrientation());
        this.pageFormat.setWidth(pf.getPaper().getWidth());
        this.pageFormat.setHeight(pf.getPaper().getHeight());
        this.pageFormat.setImageableX(pf.getPaper().getImageableX());
        this.pageFormat.setImageableY(pf.getPaper().getImageableY());
        this.pageFormat.setImageableWidth(pf.getPaper().getImageableWidth());
        this.pageFormat.setImageableHeight(pf.getPaper().getImageableHeight());
    }

    public PageFormat getPageFormat(PageFormat pf) {
        if (this.pageFormat == null) {
            return pf;
        }
        pf.setOrientation(this.pageFormat.getOrientation());
        PaperModel p = new PaperModel();
        p.setSize(this.pageFormat.getWidth(), this.pageFormat.getHeight());
        p.setImageableArea(this.pageFormat.getImageableX(), this.pageFormat.getImageableY(), this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight());
        pf.setPaper(p);
        return pf;
    }

    public void setPrinting(boolean b) {
        this.isPrinting = b;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void setRectangle(Rectangle rect) {
        this.rectangle = rect;
    }

    public Rectangle getRectangle() {
        if (this.rectangle != null) {
            return this.rectangle;
        }
        if (this.graphics != null) {
            return this.graphics.getClipBounds();
        }
        return null;
    }

    public void setRenderFlowOnly(boolean flowOnly) {
        this.renderFlowOnly = flowOnly;
    }

    public boolean isRenderFlowOnly() {
        return this.renderFlowOnly;
    }

    public void setAntialiasing(AntialiasingMode mode) {
        this.getGraphics().setAntialiasing(mode);
    }

    public void setTextAntialiasing(AntialiasingMode mode) {
        this.getGraphics().setTextAntialiasing(mode);
    }

    public void setScale(float scale) {
        assert (scale > 0.0f) : "Scale cannot be 0 or negative";
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setShowConditionalTransitions(boolean showCond) {
        this.showConditionalTransitions_d = showCond;
    }

    public boolean getShowConditionalTransitions() {
        return this.showConditionalTransitions_d;
    }

    public void setShowDueTransitions(boolean showDue) {
        this.showDueTransitions_d = showDue;
    }

    public boolean getShowDueTransitions() {
        return this.showDueTransitions_d;
    }

    public void setShowExceptionTransitions(boolean b) {
        this.showExceptionTransitions = b;
    }

    public boolean getShowExceptionTransitions() {
        return this.showExceptionTransitions;
    }

    public void setShowGrabActivities(boolean showGrab) {
        this.showGrabActivities_d = showGrab;
    }

    public boolean getShowGrabActivities() {
        return this.showGrabActivities_d;
    }

    public void setShowGrabTransitions(boolean showGrab) {
        this.showGrabTransitions_d = showGrab;
    }

    public boolean getShowGrabTransitions() {
        return this.showGrabTransitions_d;
    }

    public void setShowGrid(boolean b) {
        this.showGrid_d = b;
    }

    public boolean getShowGrid() {
        return this.showGrid_d;
    }

    public void setShowMeasurementMarks(boolean showMeasurementMarks) {
        this.showMeasurementMarks = showMeasurementMarks;
    }

    public boolean isShowMeasurementMarks() {
        return this.showMeasurementMarks;
    }

    public void setShowNotes(boolean showNotes) {
        this.showNotes = showNotes;
    }

    public boolean getShowNotes() {
        return this.showNotes;
    }

    public void setShowUnconditionalTransitions(boolean showUncond) {
        this.showUnconditionalTransitions_d = showUncond;
    }

    public boolean getShowUnconditionalTransitions() {
        return this.showUnconditionalTransitions_d;
    }

    public boolean isDrawableDebug() {
        return this.drawableDebug;
    }

    public void toogleDrawableDebug() {
        this.drawableDebug = !this.drawableDebug;
    }

    public boolean isDrawableRedrawRegions() {
        return this.drawableRedrawRegions;
    }

    public void toogleDrawableRedrawRegions() {
        this.drawableRedrawRegions = !this.drawableRedrawRegions;
    }

    public boolean isDrawableBounds() {
        return this.drawableBounds;
    }

    public void toogleDrawableBounds() {
        this.drawableBounds = !this.drawableBounds;
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartY(int y) {
        this.startY = y;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setTheme(DefaultTheme theme) {
        this.theme = theme;
    }

    public DefaultTheme getTheme() {
        return this.theme;
    }

    public void setTransitionMessageType(TransitionMessageType transitionMessageType) {
        this.transitionMessageType = transitionMessageType;
    }

    public TransitionMessageType getTransitionMessageType() {
        return this.transitionMessageType;
    }

    public void addHighlightedActivity(String activityId) {
        this.highLightedActivities.add(activityId);
    }

    public void addHighlightedTransition(SequenceFlow transition) {
        if (transition != null) {
            Integer amount = this.highLightedTransitions.get(transition);
            amount = amount == null ? Integer.valueOf(1) : Integer.valueOf(amount + 1);
            this.highLightedTransitions.put(transition, amount);
        }
    }

    public void clearHighlightedActivities() {
        this.highLightedActivities.clear();
    }

    public void clearHighlightedTransitions() {
        this.highLightedTransitions.clear();
    }

    public void drawImage(Image img, int xLoc, int yLoc, int width, int height) {
        this.getGraphics().drawImage(img, xLoc, yLoc, width, height, (UiComponent)this.getContainer());
    }

    public void paintComponent(UiComponent component, Rectangle theRectangle) {
        UiUtilities.paintComponent((Graphics)this.getGraphics(), (UiComponent)component, (UiComponent)this.getContainer(), (Rectangle)theRectangle);
    }

    public void repaint() {
        this.getContainer().repaint();
    }

    public int scale(int value) {
        return this.getScale() == DEFAULT_SCALE ? value : Math.round((float)value * this.getScale());
    }

    public int scale(double value) {
        return (int)Math.round(this.getScale() == DEFAULT_SCALE ? value : value * (double)this.getScale());
    }

    public Point scaleAndInvert(int x, int y) {
        return this.invert(new Point(this.scale(x), this.scale(y)));
    }

    public Point scaleAndInvert(Point p) {
        return this.scaleAndInvert(p.getX(), p.getY());
    }

    public Dimension scale(Dimension dim) {
        return this.invert(Dimension.valueOf(this.scale(dim.getWidth()), this.scale(dim.getHeight())));
    }

    public Rectangle scaleAndInvert(Rectangle r) {
        int scaledX0 = this.scale(r.getX());
        int scaledY0 = this.scale(r.getY());
        int scaledW = this.scale(r.getWidth());
        int scaledH = this.scale(r.getHeight());
        return new Rectangle(scaledX0, scaledY0, scaledW, scaledH);
    }

    public Rectangle scaleAndInvertRectangle(Rectangle r) {
        int scaledX = this.scale(r.getX());
        int scaledY = this.scale(r.getY());
        int scaledW = this.scale(r.getWidth());
        int scaledH = this.scale(r.getHeight());
        return this.buildRectangle(scaledX, scaledY, scaledW, scaledH);
    }

    public Point scalePoint(Point point) {
        return this.scalePoint(point.getX(), point.getY());
    }

    public Point scalePoint(int x, int y) {
        return new Point(this.scale(x), this.scale(y));
    }

    public int unscale(int value) {
        return this.getScale() == DEFAULT_SCALE ? value : Math.round((float)value / this.getScale());
    }

    public int unscale(double value) {
        return (int)Math.round(this.getScale() == DEFAULT_SCALE ? value : value / (double)this.getScale());
    }

    public Point unscaleAndInvert(int x, int y) {
        return this.invert(this.unscalePoint(x, y));
    }

    public Rectangle unscaleAndInvertRectangle(Rectangle r) {
        int unscaledX = this.unscale(r.getX());
        int unscaledY = this.unscale(r.getY());
        int unscaledW = this.unscale(r.getWidth());
        int unscaledH = this.unscale(r.getHeight());
        return this.buildRectangle(unscaledX, unscaledY, unscaledW, unscaledH);
    }

    public Point unscalePoint(Point point) {
        return this.unscalePoint(point.getX(), point.getY());
    }

    public Point unscalePoint(Point2D point) {
        return new Point(this.unscale(point.getX()), this.unscale(point.getY()));
    }

    public Point unscalePoint(int x, int y) {
        return new Point(this.unscale(x), this.unscale(y));
    }

    public Rectangle unscaleRectangle(Rectangle r) {
        int unscaledX = this.unscale(r.getX());
        int unscaledY = this.unscale(r.getY());
        int unscaledW = this.unscale(r.getWidth());
        int unscaledH = this.unscale(r.getHeight());
        return new Rectangle(unscaledX, unscaledY, unscaledW, unscaledH);
    }

    public Rectangle scaleRectangle(Rectangle r) {
        int x = this.scale(r.getX());
        int y = this.scale(r.getY());
        int w = this.scale(r.getWidth());
        int h = this.scale(r.getHeight());
        return new Rectangle(x, y, w, h);
    }

    public Font scaleFont(Font font) {
        if (this.isScaled()) {
            return font.scale(this.getScale());
        }
        return font;
    }

    public boolean isScaled() {
        return this.getScale() != DEFAULT_SCALE;
    }

    public void setDeltaY(int value) {
        this.deltaY = value;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public Point invert(Point p) {
        return p;
    }

    public Point unscaleAndInvert(Point point) {
        return this.unscaleAndInvert(point.getX(), point.getY());
    }

    public Point invert(int x, int y) {
        return this.invert(new Point(x, y));
    }

    public void setDeltaX(int value) {
        this.deltaX = value;
    }

    public Rectangle buildRectangle(int scaledX, int scaledY, int scaledW, int scaledH) {
        return new Rectangle(scaledX, scaledY, scaledW, scaledH);
    }

    Set<DesignerLayer> getLayersToDraw() {
        return EnumSet.allOf(DesignerLayer.class);
    }

    private Dimension invert(Dimension dim) {
        return dim;
    }
}

