/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.test;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpel.services.workflow.test.servertest.ServerTestCase;
import oracle.bpm.services.organization.common.ObjectFactory;
import oracle.bpm.services.t2pmigration.config.EndPointType;
import oracle.bpm.services.t2pmigration.config.FileEndPointType;
import oracle.bpm.services.t2pmigration.config.ObjectDetailsType;
import oracle.bpm.services.t2pmigration.config.ObjectTypeEnum;
import oracle.bpm.services.t2pmigration.config.OperationTypeEnum;
import oracle.bpm.services.t2pmigration.config.OrganizationType;
import oracle.bpm.services.t2pmigration.config.ServerEndPointType;
import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.config.UserApplicationDataType;
import oracle.bpm.services.t2pmigration.impl.T2PMigrationService;
import oracle.bpm.services.t2pmigration.impl.Util;

public class T2PMigrationServiceTest
extends TestCase {
    private static oracle.bpm.services.t2pmigration.config.ObjectFactory sT2PMigrationConfigurationFactory = new oracle.bpm.services.t2pmigration.config.ObjectFactory();
    private static ObjectFactory sOrganizationCommonFactory = new ObjectFactory();
    protected static final String REALM = "jazn.com";
    protected static final String httpPortNumber = ServerTestCase.ejbServerUrl;

    public T2PMigrationServiceTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new T2PMigrationServiceTest("testExportOrganizationUnit"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportOrganizationUnit"));
        suite.addTest((Test)new T2PMigrationServiceTest("testExportApplicationData"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportApplicationData"));
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)T2PMigrationServiceTest.suite());
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testExportOrganizationUnit() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        ServerEndPointType serverEndPointType = sT2PMigrationConfigurationFactory.createServerEndPointType();
        serverEndPointType.setServerURL(TestUtil.getWFEJBURL());
        serverEndPointType.setAdminUserLogin(TestUtil.getEJBUser());
        serverEndPointType.setAdminUserPassword(TestUtil.getEJBCred());
        serverEndPointType.setRealm(REALM);
        sourceEndPointType.setServerEndPoint(serverEndPointType);
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        FileEndPointType fileEndPointType = sT2PMigrationConfigurationFactory.createFileEndPointType();
        fileEndPointType.setMigrationFile(File.separator + "tmp" + File.separator + "bpm_organization.xml");
        targetEndPointType.setFileEndPoint(fileEndPointType);
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.EXPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.ORGANIZATION);
        OrganizationType organizationType = sT2PMigrationConfigurationFactory.createOrganizationType();
        ObjectDetailsType objectDetailsType = sT2PMigrationConfigurationFactory.createObjectDetailsType();
        objectDetailsType.setLogin("weblogic");
        objectDetailsType.setPassword("weblogic1");
        objectDetailsType.setIdentityContext(REALM);
        objectDetailsType.setOrganization(organizationType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        String outputFilePathName = File.separator + "tmp" + File.separator + "t2p_migration_config.xml";
        Util.exportTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration, outputFilePathName);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testImportOrganizationUnit() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        FileEndPointType fileEndPointType = sT2PMigrationConfigurationFactory.createFileEndPointType();
        fileEndPointType.setMigrationFile(File.separator + "tmp" + File.separator + "bpm_organization.xml");
        sourceEndPointType.setFileEndPoint(fileEndPointType);
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        ServerEndPointType serverEndPointType = sT2PMigrationConfigurationFactory.createServerEndPointType();
        serverEndPointType.setServerURL(TestUtil.getWFEJBURL());
        serverEndPointType.setAdminUserLogin(TestUtil.getEJBUser());
        serverEndPointType.setAdminUserPassword(TestUtil.getEJBCred());
        serverEndPointType.setRealm(REALM);
        targetEndPointType.setServerEndPoint(serverEndPointType);
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.IMPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.ORGANIZATION);
        OrganizationType organizationType = sT2PMigrationConfigurationFactory.createOrganizationType();
        ObjectDetailsType objectDetailsType = sT2PMigrationConfigurationFactory.createObjectDetailsType();
        objectDetailsType.setLogin("weblogic");
        objectDetailsType.setPassword("weblogic1");
        objectDetailsType.setIdentityContext(REALM);
        objectDetailsType.setOrganization(organizationType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testExportApplicationData() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        ServerEndPointType serverEndPointType = sT2PMigrationConfigurationFactory.createServerEndPointType();
        serverEndPointType.setServerURL(TestUtil.getWFEJBURL());
        serverEndPointType.setAdminUserLogin(TestUtil.getEJBUser());
        serverEndPointType.setAdminUserPassword(TestUtil.getEJBCred());
        serverEndPointType.setRealm(REALM);
        sourceEndPointType.setServerEndPoint(serverEndPointType);
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        FileEndPointType fileEndPointType = sT2PMigrationConfigurationFactory.createFileEndPointType();
        fileEndPointType.setMigrationFile(File.separator + "tmp" + File.separator + "bpm_applicationData.xml");
        targetEndPointType.setFileEndPoint(fileEndPointType);
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.EXPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.DASHBOARD);
        UserApplicationDataType userApplDataType = sT2PMigrationConfigurationFactory.createUserApplicationDataType();
        userApplDataType.setOwnerId("weblogic");
        ObjectDetailsType objectDetailsType = sT2PMigrationConfigurationFactory.createObjectDetailsType();
        objectDetailsType.setLogin("weblogic");
        objectDetailsType.setPassword("weblogic1");
        objectDetailsType.setIdentityContext(REALM);
        objectDetailsType.setUserApplicationData(userApplDataType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        String outputFilePathName = File.separator + "tmp" + File.separator + "t2p_dashboard_migration_config.xml";
        Util.exportTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration, outputFilePathName);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testImportApplicationData() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        FileEndPointType fileEndPointType = sT2PMigrationConfigurationFactory.createFileEndPointType();
        fileEndPointType.setMigrationFile(File.separator + "tmp" + File.separator + "bpm_applicationData.xml");
        sourceEndPointType.setFileEndPoint(fileEndPointType);
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        ServerEndPointType serverEndPointType = sT2PMigrationConfigurationFactory.createServerEndPointType();
        serverEndPointType.setServerURL(TestUtil.getWFEJBURL());
        serverEndPointType.setAdminUserLogin(TestUtil.getEJBUser());
        serverEndPointType.setAdminUserPassword(TestUtil.getEJBCred());
        serverEndPointType.setRealm(REALM);
        targetEndPointType.setServerEndPoint(serverEndPointType);
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.IMPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.DASHBOARD);
        UserApplicationDataType userApplDataType = sT2PMigrationConfigurationFactory.createUserApplicationDataType();
        ObjectDetailsType objectDetailsType = sT2PMigrationConfigurationFactory.createObjectDetailsType();
        objectDetailsType.setLogin("weblogic");
        objectDetailsType.setPassword("weblogic1");
        objectDetailsType.setIdentityContext(REALM);
        objectDetailsType.setUserApplicationData(userApplDataType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }
}

