/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.user.impl.UserMetadataUtil;
import oracle.bpel.services.workflow.user.model.UserApplicationData;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.t2pmigration.config.EndPointType;
import oracle.bpm.services.t2pmigration.config.FileEndPointType;
import oracle.bpm.services.t2pmigration.config.ObjectDetailsType;
import oracle.bpm.services.t2pmigration.config.ObjectTypeEnum;
import oracle.bpm.services.t2pmigration.config.OperationTypeEnum;
import oracle.bpm.services.t2pmigration.config.ServerEndPointType;
import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.data.BpmUserConfigurableData;
import oracle.bpm.services.t2pmigration.data.ObjectFactory;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Util {
    public static BPMServiceClientFactory getBPMServiceClientFactory(String serverURL, String adminUserLogin, String adminUserPassword) {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        if (serverURL != null && serverURL.length() > 0) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, serverURL);
        }
        if (adminUserLogin != null && adminUserLogin.length() > 0) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, adminUserLogin);
        }
        if (adminUserPassword != null && adminUserPassword.length() > 0) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, adminUserPassword);
        }
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        return bpmServiceClientFactory;
    }

    public static IBPMServiceClient getServiceClientConnection(BPMServiceClientFactory bpmServiceClientFactory) {
        return bpmServiceClientFactory.getBPMServiceClient();
    }

    public static IBPMContext getContext(BPMServiceClientFactory bpmServiceClientFactory, String user, String password, String realm) throws Exception {
        return bpmServiceClientFactory.getBPMUserAuthenticationService().authenticate(user, password.toCharArray(), realm);
    }

    public static IBPMUserAuthenticationService getBPMUserAuthenticationService(BPMServiceClientFactory bpmServiceClientFactory) {
        return bpmServiceClientFactory.getBPMUserAuthenticationService();
    }

    public static IBPMOrganizationService getOrganizationService(IBPMServiceClient serviceClient) {
        IBPMOrganizationService organizationService = null;
        if (serviceClient != null) {
            organizationService = serviceClient.getBPMOrganizationService();
        }
        return organizationService;
    }

    public static void exportTestToProductionMigrationConfiguration(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration, String outputFilePathName) throws Exception {
        if (testToProductionMigrationConfiguration == null) {
            throw new Exception(" testToProductionMigrationConfiguration is null");
        }
        if (outputFilePathName == null || outputFilePathName.length() <= 0) {
            throw new Exception(" outputFilePathName is null or empty");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{oracle.bpm.services.t2pmigration.config.ObjectFactory.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream outputFile = new FileOutputStream(new File(outputFilePathName));
        m.marshal((Object)testToProductionMigrationConfiguration, (OutputStream)outputFile);
    }

    public static void exportBpmUserConfigurableData(BpmUserConfigurableData bpmUserConfigurableData, String filePathName) throws Exception {
        if (bpmUserConfigurableData == null) {
            throw new Exception(" bpmUserConfigurableData is null");
        }
        if (filePathName == null || filePathName.length() <= 0) {
            throw new Exception(" filePathName is null or empty");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        FileOutputStream outputFile = new FileOutputStream(new File(filePathName));
        m.marshal((Object)bpmUserConfigurableData, (OutputStream)outputFile);
    }

    public static BpmUserConfigurableData importBpmUserConfigurableData(String filePathName) throws Exception {
        if (filePathName == null || filePathName.length() <= 0) {
            throw new Exception(" filePathName is null or empty");
        }
        BpmUserConfigurableData bpmUserConfigurableData = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller um = context.createUnmarshaller();
        bpmUserConfigurableData = (BpmUserConfigurableData)um.unmarshal((InputStream)new FileInputStream(filePathName));
        return bpmUserConfigurableData;
    }

    public static TestToProductionMigrationConfiguration parseTestToProductionMigrationConfigurationFile(String filePathName) throws Exception {
        if (filePathName == null || filePathName.length() <= 0) {
            throw new Exception(" filePathName is null or empty");
        }
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{oracle.bpm.services.t2pmigration.config.ObjectFactory.class});
        Unmarshaller um = context.createUnmarshaller();
        testToProductionMigrationConfiguration = (TestToProductionMigrationConfiguration)um.unmarshal((InputStream)new FileInputStream(filePathName));
        return testToProductionMigrationConfiguration;
    }

    public static void displayTestToProductionMigrationConfiguration(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration) {
        System.out.println(" displayTestToProductionMigrationConfiguration()");
        if (testToProductionMigrationConfiguration == null) {
            System.out.println(" testToProductionMigrationConfiguration is null");
        } else {
            EndPointType source = testToProductionMigrationConfiguration.getSourceEndPoint();
            Util.displayEndPointType(source);
            EndPointType target = testToProductionMigrationConfiguration.getTargetEndPoint();
            Util.displayEndPointType(target);
            OperationTypeEnum operationType = testToProductionMigrationConfiguration.getOperation();
            System.out.println("\n operationType.toString(): " + operationType.toString());
            List objectTypeList = testToProductionMigrationConfiguration.getObject();
            Util.displayObjectTypeList(objectTypeList);
            ObjectDetailsType objectDetailsType = testToProductionMigrationConfiguration.getObjectDetails();
            Util.displayObjectDetailsType(objectDetailsType, true);
            System.out.println("\n testToProductionMigrationConfiguration.isSkip(): " + testToProductionMigrationConfiguration.isSkip());
            System.out.println(" testToProductionMigrationConfiguration.isOverride(): " + testToProductionMigrationConfiguration.isOverride());
        }
    }

    public static void displayEndPointType(EndPointType endPointType) {
        System.out.println(" displayEndPointType()");
        if (endPointType == null) {
            System.out.println(" endPointType is null");
        } else {
            FileEndPointType fileEndPointType;
            ServerEndPointType serverEndPointType = endPointType.getServerEndPoint();
            if (serverEndPointType != null) {
                Util.displayServerEndPointType(serverEndPointType);
            }
            if ((fileEndPointType = endPointType.getFileEndPoint()) != null) {
                Util.displayFileEndPointType(fileEndPointType);
            }
        }
    }

    public static void displayServerEndPointType(ServerEndPointType serverEndPointType) {
        System.out.println(" displayServerEndPointType()");
        if (serverEndPointType == null) {
            System.out.println(" serverEndPointType is null");
        } else {
            System.out.println(" serverEndPointType.getServerURL(): " + serverEndPointType.getServerURL());
            System.out.println(" serverEndPointType.getAdminUserLogin(): " + serverEndPointType.getAdminUserLogin());
            System.out.println(" serverEndPointType.getAdminUserPassword(): " + serverEndPointType.getAdminUserPassword());
            System.out.println(" serverEndPointType.getRealm(): " + serverEndPointType.getRealm());
        }
    }

    public static void displayFileEndPointType(FileEndPointType fileEndPointType) {
        System.out.println(" displayFileEndPointType()");
        if (fileEndPointType == null) {
            System.out.println(" fileEndPointType is null");
        } else {
            System.out.println("\n fileEndPointType.getMigrationFile(): " + fileEndPointType.getMigrationFile());
        }
    }

    public static void displayObjectTypeList(List<ObjectTypeEnum> objectTypeList) {
        System.out.println(" displayObjectTypeList()");
        if (objectTypeList == null) {
            System.out.println(" objectTypeList is null");
        } else if (objectTypeList.isEmpty()) {
            System.out.println(" objectTypeList is empty");
        } else {
            System.out.println(" objectTypeList.size(): " + objectTypeList.size());
            for (int i = 0; i < objectTypeList.size(); ++i) {
                ObjectTypeEnum objectType = objectTypeList.get(i);
                System.out.println(" (" + i + ") objectType: " + objectType);
            }
        }
    }

    public static void displayObjectDetailsType(ObjectDetailsType objectDetailsType, boolean displaySecureInfo) {
        System.out.println(" displayObjectDetailsType()");
        if (objectDetailsType == null) {
            System.out.println(" objectDetailsType is null");
        } else {
            System.out.println(" objectDetailsType.getLogin(): " + objectDetailsType.getLogin());
            System.out.println(" objectDetailsType.getIdentityContext(): " + objectDetailsType.getIdentityContext());
            if (displaySecureInfo) {
                System.out.println(" objectDetailsType.getPassword(): " + objectDetailsType.getPassword());
            }
            if (objectDetailsType.getBPMContext() != null && objectDetailsType.getBPMContext().getCredential() != null) {
                System.out.println(" objectDetailsType.getBPMContext().getCredential().getLogin(): " + objectDetailsType.getBPMContext().getCredential().getLogin());
                System.out.println(" objectDetailsType.getBPMContext().getCredential().getIdentityContext(): " + objectDetailsType.getBPMContext().getCredential().getIdentityContext());
                if (displaySecureInfo) {
                    System.out.println(" objectDetailsType.getBPMContext().getCredential().getPassword(): " + objectDetailsType.getBPMContext().getCredential().getPassword());
                }
            }
            if (objectDetailsType.getApplicationRole() != null) {
                System.out.println(" objectDetailsType.getApplicationRole().getApplicationRoleName(): " + objectDetailsType.getApplicationRole().getApplicationRoleName());
            }
            if (objectDetailsType.getCalendarRule() != null) {
                System.out.println(" objectDetailsType.getCalendarRule().getName(): " + objectDetailsType.getCalendarRule().getName());
            }
            if (objectDetailsType.getHolidayRule() != null) {
                System.out.println(" objectDetailsType.getHolidayRule().getName(): " + objectDetailsType.getHolidayRule().getName());
            }
            if (objectDetailsType.getLogicalPeopleGroup() != null) {
                System.out.println(" objectDetailsType.getLogicalPeopleGroup().getName(): " + objectDetailsType.getLogicalPeopleGroup().getName());
            }
            if (objectDetailsType.getOrganization() != null) {
                System.out.println(" objectDetailsType.getOrganization().getName(): " + objectDetailsType.getOrganization().getName());
            }
            if (objectDetailsType.getOrganizationalUnit() != null) {
                System.out.println(" objectDetailsType.getOrganizationalUnit().getOrganizationalUnitName(): " + objectDetailsType.getOrganizationalUnit().getOrganizationalUnitName());
            }
            if (objectDetailsType.getParticipantProperty() != null) {
                System.out.println(" objectDetailsType.getParticipantProperty().getName(): " + objectDetailsType.getParticipantProperty().getName());
            }
            if (objectDetailsType.getUserApplicationData() != null) {
                System.out.println(" objectDetailsType.getUserApplicationData().getOwnerId(): " + objectDetailsType.getUserApplicationData().getOwnerId());
            }
        }
    }

    public static UserApplicationData convertJaxb2_0ToJaxb1_0(oracle.bpm.services.t2pmigration.data.UserApplicationData appData2_0) throws Exception {
        Document doc = Util.marshallJaxb2_0(appData2_0);
        Element appDataElem = doc.getDocumentElement();
        UserApplicationData appData1_0 = (UserApplicationData)UserMetadataUtil.getInstance().unmarshal((Node)appDataElem);
        return appData1_0;
    }

    public static oracle.bpm.services.t2pmigration.data.UserApplicationData convertJaxb1_0ToJaxb2_0(UserApplicationData appData1_0) throws Exception {
        XMLElement appDataElem = ((JaxbNode)appData1_0).getDOMNode();
        return Util.unmarshallJaxb2_0((Element)appDataElem);
    }

    public static Document marshallJaxb2_0(oracle.bpm.services.t2pmigration.data.UserApplicationData appData2_0) throws Exception {
        JAXBContext jc = Jaxb20ContextFactory.getJAXBContext(ObjectFactory.class);
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal((Object)appData2_0, (Node)doc);
        return doc;
    }

    public static oracle.bpm.services.t2pmigration.data.UserApplicationData unmarshallJaxb2_0(Element appDataElement) throws Exception {
        JAXBContext jc = Jaxb20ContextFactory.getJAXBContext(ObjectFactory.class);
        Unmarshaller um = jc.createUnmarshaller();
        return (oracle.bpm.services.t2pmigration.data.UserApplicationData)um.unmarshal((Node)appDataElement);
    }
}

