/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.impl;

import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.WorkflowServiceClientException;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.t2pmigration.IT2PMigrationService;
import oracle.bpm.services.t2pmigration.config.EndPointType;
import oracle.bpm.services.t2pmigration.config.ObjectDetailsType;
import oracle.bpm.services.t2pmigration.config.ObjectTypeEnum;
import oracle.bpm.services.t2pmigration.config.OperationTypeEnum;
import oracle.bpm.services.t2pmigration.config.OrganizationalUnitType;
import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.data.BpmUserConfigurableData;
import oracle.bpm.services.t2pmigration.data.ObjectFactory;
import oracle.bpm.services.t2pmigration.data.UserApplicationData;
import oracle.bpm.services.t2pmigration.impl.Util;

public class T2PMigrationService
implements IT2PMigrationService {
    protected TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = null;
    private EndPointType source = null;
    private EndPointType target = null;
    private ObjectDetailsType objectDetailsType = null;
    private OperationTypeEnum operationType = null;
    private OrganizationalUnitType organizationalUnitType = null;
    private boolean skipFlag = false;
    private boolean overrideFlag = false;
    private List<ObjectTypeEnum> objectTypeList = null;
    private static final String WIDGETSTRING = "BAM-WIDGET";
    private static ObjectFactory sT2PMigrationFactory;

    public void setTestToProductionMigrationConfiguration(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration) {
        if (testToProductionMigrationConfiguration != null) {
            this.testToProductionMigrationConfiguration = testToProductionMigrationConfiguration;
            this.source = testToProductionMigrationConfiguration.getSourceEndPoint();
            this.target = testToProductionMigrationConfiguration.getTargetEndPoint();
            this.operationType = testToProductionMigrationConfiguration.getOperation();
            this.objectTypeList = testToProductionMigrationConfiguration.getObject();
            this.objectDetailsType = testToProductionMigrationConfiguration.getObjectDetails();
            if (this.objectDetailsType != null) {
                this.organizationalUnitType = this.objectDetailsType.getOrganizationalUnit();
            }
            this.skipFlag = testToProductionMigrationConfiguration.isSkip();
            this.overrideFlag = testToProductionMigrationConfiguration.isOverride();
        }
    }

    public void migrate(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration) throws Exception {
        Util.displayTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration);
        this.setTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration);
        if (this.operationType == OperationTypeEnum.EXPORT) {
            System.out.println("\n ===>>> migrate()::EXPORT");
            this.exportHandler(this.source, this.target, this.objectDetailsType, this.objectTypeList);
        } else if (this.operationType == OperationTypeEnum.IMPORT) {
            System.out.println("\n ===>>> migrate()::IMPORT");
            this.importHandler(this.source, this.target, this.objectDetailsType, this.skipFlag, this.overrideFlag, this.objectTypeList);
        } else if (this.operationType == OperationTypeEnum.IN_MEMORY_TRANSFER) {
            System.out.println("\n ===>>> migrate()::IN_MEMORY_TRANSFER");
        } else {
            System.out.println("\n ===>>> Unsupported use case: File-to-File");
        }
    }

    private void exportHandler(EndPointType source, EndPointType target, ObjectDetailsType objectDetailsType, List<ObjectTypeEnum> objectTypeList) throws Exception {
        BpmUserConfigurableData bpmUserConfigurableData = sT2PMigrationFactory.createBpmUserConfigurableData();
        if (source != null && source.getServerEndPoint() != null && source.getServerEndPoint().getServerURL() != null && source.getServerEndPoint().getAdminUserLogin() != null && source.getServerEndPoint().getAdminUserPassword() != null && target != null && target.getFileEndPoint() != null && target.getFileEndPoint().getMigrationFile() != null) {
            try {
                BPMServiceClientFactory bpmServiceClientFactory = Util.getBPMServiceClientFactory(source.getServerEndPoint().getServerURL(), source.getServerEndPoint().getAdminUserLogin(), source.getServerEndPoint().getAdminUserPassword());
                IBPMServiceClient serviceClient = Util.getServiceClientConnection(bpmServiceClientFactory);
                Util.displayObjectTypeList(objectTypeList);
                Util.displayObjectDetailsType(objectDetailsType, false);
                if (objectTypeList == null) {
                    System.out.println(" Object type list is null during EXPORT!");
                } else {
                    IBPMContext ctx = Util.getContext(bpmServiceClientFactory, objectDetailsType.getLogin(), objectDetailsType.getPassword(), objectDetailsType.getIdentityContext());
                    for (int i = 0; i < objectTypeList.size(); ++i) {
                        if (ObjectTypeEnum.ORGANIZATION == objectTypeList.get(i)) {
                            IBPMOrganizationService organizationService = Util.getOrganizationService(serviceClient);
                            Organization organization = organizationService.exportOrganization(ctx);
                            if (organization == null) continue;
                            bpmUserConfigurableData.getOrganization().add(organization);
                            continue;
                        }
                        if (ObjectTypeEnum.DASHBOARD != objectTypeList.get(i)) continue;
                        List queriedBpelApplicationDataList = null;
                        String owner = objectDetailsType.getLogin();
                        if (objectDetailsType != null && objectDetailsType.getUserApplicationData() != null && objectDetailsType.getUserApplicationData().isSetOwnerId()) {
                            owner = objectDetailsType.getUserApplicationData().getOwnerId();
                        }
                        if ((queriedBpelApplicationDataList = serviceClient.getUserMetadataService().listUserApplicationData((IWorkflowContext)ctx, WIDGETSTRING, owner)) != null && queriedBpelApplicationDataList.size() > 0) {
                            int ctrUAD = 0;
                            for (UserApplicationDataType bpelUAD : queriedBpelApplicationDataList) {
                                if (bpelUAD != null) {
                                    UserApplicationData bpmUdt = Util.convertJaxb1_0ToJaxb2_0((oracle.bpel.services.workflow.user.model.UserApplicationData)bpelUAD);
                                    bpmUserConfigurableData.getUserApplicationData().add(bpmUdt);
                                    ++ctrUAD;
                                    continue;
                                }
                                System.out.println(" Skip exporting null application data.");
                            }
                            System.out.println(" Exporting " + ctrUAD + " application data(s) ...");
                            continue;
                        }
                        System.out.println(" Queried Application Data List is null");
                    }
                }
                Util.exportBpmUserConfigurableData(bpmUserConfigurableData, target.getFileEndPoint().getMigrationFile());
                System.out.println(" Completed EXPORT");
            }
            catch (Exception e) {
                System.out.println(" Error in EXPORT");
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void importHandler(EndPointType source, EndPointType target, ObjectDetailsType objectDetailsType, boolean skipFlag, boolean overrideFlag, List<ObjectTypeEnum> objectTypeList) throws Exception {
        if (source != null && source.getFileEndPoint() != null && source.getFileEndPoint().getMigrationFile() != null && target.getServerEndPoint() != null && target.getServerEndPoint().getServerURL() != null && target.getServerEndPoint().getAdminUserLogin() != null && target.getServerEndPoint().getAdminUserPassword() != null) {
            boolean validateUsers = !skipFlag;
            System.out.println(" validateUsers: " + validateUsers);
            try {
                BPMServiceClientFactory bpmServiceClientFactory = Util.getBPMServiceClientFactory(target.getServerEndPoint().getServerURL(), target.getServerEndPoint().getAdminUserLogin(), target.getServerEndPoint().getAdminUserPassword());
                IBPMServiceClient serviceClient = Util.getServiceClientConnection(bpmServiceClientFactory);
                IBPMOrganizationService organizationService = Util.getOrganizationService(serviceClient);
                IBPMContext ctx = Util.getContext(bpmServiceClientFactory, objectDetailsType.getLogin(), objectDetailsType.getPassword(), objectDetailsType.getIdentityContext());
                BpmUserConfigurableData importBpmUserConfigurableData = Util.importBpmUserConfigurableData(source.getFileEndPoint().getMigrationFile());
                System.out.println(" Got the BpmUserConfigurableData by parsing the import file ...");
                Util.displayObjectTypeList(objectTypeList);
                Util.displayObjectDetailsType(objectDetailsType, false);
                if (objectTypeList == null) {
                    System.out.println(" No object type available during IMPORT!");
                } else {
                    for (int i = 0; i < objectTypeList.size(); ++i) {
                        if (ObjectTypeEnum.ORGANIZATION == objectTypeList.get(i)) {
                            List organizationList = importBpmUserConfigurableData.getOrganization();
                            System.out.println(" organizationList.size(): " + organizationList.size());
                            if (organizationList != null && organizationList.size() > 0) {
                                for (int j = 0; j < organizationList.size(); ++j) {
                                    Organization organization = (Organization)organizationList.get(j);
                                    System.out.println(" Importing organization unit " + j + " ...");
                                    Organization returnOrganization = organizationService.importOrganization(ctx, organization, validateUsers);
                                    System.out.println(" Import of organization unit completed ...");
                                }
                                continue;
                            }
                            System.out.println(" organizationList is null or empty");
                            continue;
                        }
                        if (ObjectTypeEnum.DASHBOARD != objectTypeList.get(i)) continue;
                        List bpmUADTypeList = importBpmUserConfigurableData.getUserApplicationData();
                        if (bpmUADTypeList == null) {
                            System.out.println("UserApplicationData List is null");
                        } else {
                            System.out.println("UserApplicationData List size is [" + bpmUADTypeList.size() + "]");
                        }
                        if (bpmUADTypeList != null && bpmUADTypeList.size() > 0) {
                            oracle.bpel.services.workflow.user.model.UserApplicationData bpelUAD = null;
                            String owner = objectDetailsType.getLogin();
                            if (objectDetailsType != null && objectDetailsType.getUserApplicationData() != null && objectDetailsType.getUserApplicationData().isSetOwnerId()) {
                                owner = objectDetailsType.getUserApplicationData().getOwnerId();
                            }
                            for (UserApplicationData bpmUADType : bpmUADTypeList) {
                                if (bpmUADType != null) {
                                    System.out.println(" Importing application data with ID [" + bpmUADType.getId() + "] and name [" + bpmUADType.getName() + "] ...");
                                    if (!bpmUADType.getName().equals(owner)) {
                                        System.out.println(" -> Setting owner to " + owner);
                                        bpmUADType.setOwner(owner);
                                        bpmUADType.setCreatedBy(owner);
                                        bpmUADType.setUpdatedBy(owner);
                                    }
                                    bpelUAD = Util.convertJaxb2_0ToJaxb1_0(bpmUADType);
                                    try {
                                        bpelUAD = serviceClient.getUserMetadataService().createUserApplicationData((IWorkflowContext)ctx, (UserApplicationDataType)bpelUAD);
                                        System.out.println(" -> Import of application data with ID [" + bpelUAD.getId() + "] and name [" + bpelUAD.getName() + "] completed ...");
                                    }
                                    catch (WorkflowServiceClientException wsce) {
                                        System.out.println(" -> Application data with ID [" + bpmUADType.getId() + "] and name [" + bpmUADType.getName() + "] already exists ...");
                                        if (overrideFlag || !skipFlag) {
                                            try {
                                                bpelUAD = serviceClient.getUserMetadataService().updateUserApplicationData((IWorkflowContext)ctx, (UserApplicationDataType)bpelUAD);
                                                System.out.println(" -> Import (overriding) application data with ID [" + bpelUAD.getId() + "] and name [" + bpelUAD.getName() + "] completed ...");
                                            }
                                            catch (WorkflowException e) {
                                                if (e.getErrorCode() == 30747) {
                                                    System.out.println(" -> Skiping ...");
                                                    continue;
                                                }
                                                System.out.println(" -> Exception " + e.toString() + " occurs during import ...");
                                            }
                                            continue;
                                        }
                                        System.out.println(" -> Skipping already exist application data.");
                                    }
                                    continue;
                                }
                                System.out.println(" Skip importing null application data.");
                            }
                            continue;
                        }
                        System.out.println(" Skip importing null application data list.");
                    }
                }
                System.out.println(" Completed IMPORT.");
            }
            catch (Exception e) {
                System.out.println(" Error in IMPORT!");
                e.printStackTrace();
                throw e;
            }
        }
        System.out.println(" Error in IMPORT: One or more required parameter(s) missing from import file.");
    }

    static {
        System.setProperty("javax.xml.datatype.DatatypeFactory", "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
        sT2PMigrationFactory = new ObjectFactory();
    }
}

