/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processmetadata.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.runtimeconfig.ejb.RuntimeConfigServiceRemote;
import oracle.bpel.services.workflow.runtimeconfig.ejb.RuntimeConfigServiceRemoteHome;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ObjectFactory;
import oracle.bpm.services.processmetadata.ProcessMetadataServiceException;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.ProcessMetadataSummaryListType;
import oracle.bpm.services.processmetadata.ProjectMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.bpm.services.processmetadata.TaskDisplayInfoType;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMRole;
import oracle.tip.pc.services.identity.BPMUser;

public class ProcessMetadataService
implements IProcessMetadataService {
    private static final String CLASSNAME = "ProcessMetadataService";
    private static ObjectFactory sProcessMetadataFactory = new ObjectFactory();
    private static final String ROLE_BPM_PROCESS_ADMIN = "BPMProcessAdmin";
    private Context context = null;
    private PersistenceQueryService pqs = null;
    private RuntimeConfigServiceRemote remoteRuntimeConfigServiceBean = null;
    private IVerificationService verificationService = null;
    private IBPMUserAuthenticationService bpmUserAuthenticationService = null;
    private IProcessModelService processModelService = null;

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    public IBPMUserAuthenticationService getBpmUserAuthenticationService() {
        return this.bpmUserAuthenticationService;
    }

    public void setBpmUserAuthenticationService(IBPMUserAuthenticationService newBPMUserAuthenticationService) {
        this.bpmUserAuthenticationService = newBPMUserAuthenticationService;
    }

    public IProcessModelService getProcessModelService() {
        return this.processModelService;
    }

    public void setProcessModelService(IProcessModelService newProcessModelService) {
        this.processModelService = newProcessModelService;
    }

    public List<ProjectMetadataSummary> listProjectMetadataSummary(IBPMContext context, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        return this.listProjectMetadataSummary(context, null, keyword, sortAttribute, sortOrder);
    }

    public List<ProjectMetadataSummary> listProjectMetadataSummary(IBPMContext context, String compositeDN, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProjectMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n keyword: " + keyword + "\n sortAttribute: " + sortAttribute + "\n sortOrder: " + sortOrder));
        }
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProjectMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            jpqlString = this.constructProcessQueryString(bpmAdminUserFlag, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList);
            List dataSetObjectList = this.select(jpqlString);
            projectMetadataSummaryList = this.convertToProjectMetadataSummaryList(dataSetObjectList);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70800, (Object[])new String[0], (Throwable)e);
        }
        return projectMetadataSummaryList;
    }

    public ProjectMetadataSummary getProjectMetadataSummary(IBPMContext context, String compositeDN, String projectName) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProjectMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n projectName: " + projectName));
        }
        ProjectMetadataSummary projectMetadataSummary = null;
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        if (!(compositeDN != null && compositeDN.length() > 0 || projectName != null && projectName.length() > 0)) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProjectMetadataSummary", (String)"\n compositeDN and projectName are null or empty.");
            }
            return null;
        }
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProjectMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            jpqlString = this.constructProjectQueryString(bpmAdminUserFlag, compositeDN, projectName, organizationalUnitIdList);
            List dataSetObjectList = this.select(jpqlString);
            projectMetadataSummaryList = this.convertToProjectMetadataSummaryList(dataSetObjectList);
            if (projectMetadataSummaryList != null && !projectMetadataSummaryList.isEmpty()) {
                if (projectMetadataSummaryList.size() > 1) {
                    Object[] objs = new Object[]{compositeDN, projectName};
                    throw new ProcessMetadataServiceException(70809, objs);
                }
                projectMetadataSummary = projectMetadataSummaryList.get(0);
            }
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70801, (Object[])new String[0], (Throwable)e);
        }
        return projectMetadataSummary;
    }

    public List<ProcessMetadataSummary> listProcessMetadataSummary(IBPMContext context, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        return this.listProcessMetadataSummary(context, null, keyword, sortAttribute, sortOrder);
    }

    public List<ProcessMetadataSummary> listProcessMetadataSummary(IBPMContext context, String compositeDN, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProcessMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n keyword: " + keyword + "\n sortAttribute: " + sortAttribute + "\n sortOrder: " + sortOrder));
        }
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProcessMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            jpqlString = this.constructProcessQueryString(bpmAdminUserFlag, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = this.convertToProcessMetadataSummaryList(dataSetObjectList);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70802, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummaryList;
    }

    public ProcessMetadataSummary getProcessMetadataSummary(IBPMContext context, String compositeDN, String processName) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n processName: " + processName));
        }
        ProcessMetadataSummary processMetadataSummary = null;
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        if (!(compositeDN != null && compositeDN.length() > 0 || processName != null && processName.length() > 0)) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessMetadataSummary", (String)"\n compositeDN and processName are null or empty.");
            }
            return null;
        }
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            jpqlString = this.constructProcessQueryString(bpmAdminUserFlag, compositeDN, processName, organizationalUnitIdList);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = this.convertToProcessMetadataSummaryList(dataSetObjectList);
            if (processMetadataSummaryList != null && !processMetadataSummaryList.isEmpty()) {
                if (processMetadataSummaryList.size() > 1) {
                    Object[] objs = new Object[]{compositeDN, processName};
                    throw new ProcessMetadataServiceException(70810, objs);
                }
                processMetadataSummary = processMetadataSummaryList.get(0);
            }
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70803, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummary;
    }

    public List<ProcessMetadataSummary> getInitiatableProcesses(IBPMContext context) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n context: " + context));
        }
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> applicationRoles = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        try {
            String user = context.getUser();
            String identityContext = context.getIdentityContext();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n user: " + user + "\n identityContext: " + identityContext));
            }
            bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
            applicationRoles = this.getApplicationRolesForUser(context);
            if (!bpmAdminUserFlag && applicationRoles.isEmpty()) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n " + user + " is not an admin.  There are no roles for him."));
                }
                return new ArrayList<ProcessMetadataSummary>();
            }
            organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
            jpqlString = this.constructProcessQueryString(applicationRoles, organizationalUnitIdList, bpmAdminUserFlag);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = this.convertToInitiatableProcessMetadataSummaryList(context, dataSetObjectList, applicationRoles);
        }
        catch (BPMIdentityException e) {
            throw new ProcessMetadataServiceException(70805, (Object[])new String[0]);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70805, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummaryList;
    }

    public Map<String, String> getProcessRoles(IBPMContext context, String compositeDN) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessRoles", (String)("\n context: " + context + "\n compositeDN: " + compositeDN));
        }
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        this.validateContext(context);
        return DeploymentDescriptorUtil.getProcessRoles((String)compositeDN);
    }

    public String getOrganizationalUnit(IBPMContext context, String compositeDN) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getOrganizationalUnit", (String)("\n context: " + context + "\n compositeDN: " + compositeDN));
        }
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        this.validateContext(context);
        return DeploymentDescriptorUtil.getOrganizationalUnit((String)compositeDN);
    }

    private List<ProjectMetadataSummary> convertToProjectMetadataSummaryList(List list) {
        Map<String, ProjectMetadataSummary> projectMetadataSummaryMap = Collections.synchronizedMap(new LinkedHashMap());
        if (list != null && !list.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProcessMetadataSummaryList", (String)("\n list.size(): " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object[] objArray = (Object[])list.get(i);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProjectMetadataSummaryList", (String)("\n objArray.getClass(): " + objArray.getClass()));
                }
                if (objArray == null || objArray.length <= 0) continue;
                Long processId = (Long)objArray[0];
                String processName = (String)objArray[1];
                String domainName = (String)objArray[2];
                String compositeName = (String)objArray[3];
                String revision = (String)objArray[4];
                String scaLabel = (String)objArray[5];
                String compositeDN = (String)objArray[6];
                String label = (String)objArray[7];
                String targetNamespace = (String)objArray[8];
                Long status = (Long)objArray[9];
                Object creationDate = objArray[10];
                Object undeployDate = objArray[11];
                String organizationalUnitId = (String)objArray[12];
                String hasGlobalCreationTasks = (String)objArray[13];
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProjectMetadataSummaryList", (String)("\n processId: " + processId + "\n processName: " + processName + "\n domainName: " + domainName + "\n compositeName: " + compositeName + "\n revision: " + revision + "\n scaLabel: " + scaLabel + "\n compositeDN: " + compositeDN + "\n label: " + label + "\n targetNamespace: " + targetNamespace + "\n status: " + status + "\n creationDate: " + creationDate + "\n undeployDate: " + undeployDate + "\n organizationalUnitId: " + organizationalUnitId + "\n hasGlobalCreationTasks: " + hasGlobalCreationTasks));
                }
                ProcessMetadataSummary processMetadataSummary = sProcessMetadataFactory.createProcessMetadataSummary();
                if (processId != null) {
                    processMetadataSummary.setProcessId(String.valueOf(processId));
                }
                processMetadataSummary.setProjectName(compositeName);
                processMetadataSummary.setProcessName(processName);
                processMetadataSummary.setDomainName(domainName);
                processMetadataSummary.setCompositeName(compositeName);
                processMetadataSummary.setRevision(revision);
                processMetadataSummary.setLabel(scaLabel);
                processMetadataSummary.setCompositeDN(compositeDN);
                processMetadataSummary.setTargetNamespace(targetNamespace);
                if (status != null) {
                    if (status == 1L) {
                        processMetadataSummary.setStatus(StatusEnum.ACTIVE);
                    } else if (status == 0L) {
                        processMetadataSummary.setStatus(StatusEnum.RETIRED);
                    } else if (status == -1L) {
                        processMetadataSummary.setStatus(StatusEnum.DELETED);
                    }
                }
                processMetadataSummary.setOrganizationalUnitId(organizationalUnitId);
                if (hasGlobalCreationTasks != null && hasGlobalCreationTasks.equalsIgnoreCase("Y")) {
                    processMetadataSummary.setHasGlobalCreationTasks(new Boolean("true"));
                } else {
                    processMetadataSummary.setHasGlobalCreationTasks(new Boolean("false"));
                }
                ProjectMetadataSummary projectMetadata = projectMetadataSummaryMap.get(processMetadataSummary.getCompositeDN());
                if (projectMetadata == null) {
                    ProjectMetadataSummary projectMetadataSummary = sProcessMetadataFactory.createProjectMetadataSummary();
                    projectMetadataSummary.setProjectName(processMetadataSummary.getCompositeName());
                    projectMetadataSummary.setCompositeDN(processMetadataSummary.getCompositeDN());
                    projectMetadataSummary.setCompositeVersion(processMetadataSummary.getRevision());
                    projectMetadataSummary.setStatus(processMetadataSummary.getStatus());
                    ProcessMetadataSummaryListType processMetadataSummaryListType = projectMetadataSummary.getProcessMetadataSummaryList();
                    if (processMetadataSummaryListType == null) {
                        processMetadataSummaryListType = sProcessMetadataFactory.createProcessMetadataSummaryListType();
                        List processList = processMetadataSummaryListType.getProcessMetadataSummary();
                        if (processList != null) {
                            processList.add(processMetadataSummary);
                        }
                        projectMetadataSummary.setProcessMetadataSummaryList(processMetadataSummaryListType);
                    } else if (processMetadataSummaryListType.getProcessMetadataSummary() != null) {
                        processMetadataSummaryListType.getProcessMetadataSummary().add(processMetadataSummary);
                    }
                    projectMetadataSummaryMap.put(projectMetadataSummary.getCompositeDN(), projectMetadataSummary);
                    continue;
                }
                ProcessMetadataSummaryListType processMetadataSummaryListType = projectMetadata.getProcessMetadataSummaryList();
                if (processMetadataSummaryListType == null) {
                    processMetadataSummaryListType = sProcessMetadataFactory.createProcessMetadataSummaryListType();
                    List processList = processMetadataSummaryListType.getProcessMetadataSummary();
                    if (processList != null) {
                        processList.add(processMetadataSummary);
                    }
                    projectMetadata.setProcessMetadataSummaryList(processMetadataSummaryListType);
                    continue;
                }
                if (processMetadataSummaryListType.getProcessMetadataSummary() == null) continue;
                processMetadataSummaryListType.getProcessMetadataSummary().add(processMetadataSummary);
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProjectMetadataSummaryList", (String)"\n list is null or empty");
        }
        return this.getProjectMetadataSummaryList(projectMetadataSummaryMap);
    }

    private List<ProcessMetadataSummary> convertToProcessMetadataSummaryList(List list) {
        ArrayList<ProcessMetadataSummary> processMetadataSummaryList = new ArrayList<ProcessMetadataSummary>();
        if (list != null && !list.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProcessMetadataSummaryList", (String)("\n list.size(): " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object[] objArray = (Object[])list.get(i);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProcessMetadataSummaryList", (String)("\n objArray.getClass(): " + objArray.getClass()));
                }
                if (objArray == null || objArray.length <= 0) continue;
                Long processId = (Long)objArray[0];
                String processName = (String)objArray[1];
                String domainName = (String)objArray[2];
                String compositeName = (String)objArray[3];
                String revision = (String)objArray[4];
                String scaLabel = (String)objArray[5];
                String compositeDN = (String)objArray[6];
                String label = (String)objArray[7];
                String targetNamespace = (String)objArray[8];
                Long status = (Long)objArray[9];
                Object creationDate = objArray[10];
                Object undeployDate = objArray[11];
                String organizationalUnitId = (String)objArray[12];
                String hasGlobalCreationTasks = (String)objArray[13];
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProcessMetadataSummaryList", (String)("\n processId: " + processId + "\n processName: " + processName + "\n domainName: " + domainName + "\n compositeName: " + compositeName + "\n revision: " + revision + "\n scaLabel: " + scaLabel + "\n compositeDN: " + compositeDN + "\n label: " + label + "\n targetNamespace: " + targetNamespace + "\n status: " + status + "\n creationDate: " + creationDate + "\n undeployDate: " + undeployDate + "\n organizationalUnitId: " + organizationalUnitId + "\n hasGlobalCreationTasks: " + hasGlobalCreationTasks));
                }
                ProcessMetadataSummary processMetadataSummary = sProcessMetadataFactory.createProcessMetadataSummary();
                if (processId != null) {
                    processMetadataSummary.setProcessId(String.valueOf(processId));
                }
                processMetadataSummary.setProjectName(compositeName);
                processMetadataSummary.setProcessName(processName);
                processMetadataSummary.setDomainName(domainName);
                processMetadataSummary.setCompositeName(compositeName);
                processMetadataSummary.setRevision(revision);
                processMetadataSummary.setLabel(scaLabel);
                processMetadataSummary.setCompositeDN(compositeDN);
                processMetadataSummary.setTargetNamespace(targetNamespace);
                if (status != null) {
                    if (status == 1L) {
                        processMetadataSummary.setStatus(StatusEnum.ACTIVE);
                    } else if (status == 0L) {
                        processMetadataSummary.setStatus(StatusEnum.RETIRED);
                    } else if (status == -1L) {
                        processMetadataSummary.setStatus(StatusEnum.DELETED);
                    }
                }
                processMetadataSummary.setOrganizationalUnitId(organizationalUnitId);
                if (hasGlobalCreationTasks != null && hasGlobalCreationTasks.equalsIgnoreCase("Y")) {
                    processMetadataSummary.setHasGlobalCreationTasks(new Boolean("true"));
                } else {
                    processMetadataSummary.setHasGlobalCreationTasks(new Boolean("false"));
                }
                processMetadataSummaryList.add(processMetadataSummary);
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToProcessMetadataSummaryList", (String)"\n list is null or empty");
        }
        return processMetadataSummaryList;
    }

    private List<ProcessMetadataSummary> convertToInitiatableProcessMetadataSummaryList(IBPMContext context, List list, List<String> applicationRoles) throws ProcessMetadataServiceException {
        ArrayList<ProcessMetadataSummary> processMetadataSummaryList = new ArrayList<ProcessMetadataSummary>();
        if (list != null && !list.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToInitiatableProcessMetadataSummaryList", (String)("\n list.size(): " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object[] objArray = (Object[])list.get(i);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToInitiatableProcessMetadataSummaryList", (String)("\n objArray.getClass(): " + objArray.getClass()));
                }
                if (objArray == null || objArray.length <= 0) continue;
                Long processId = (Long)objArray[0];
                String processName = (String)objArray[1];
                String domainName = (String)objArray[2];
                String compositeName = (String)objArray[3];
                String revision = (String)objArray[4];
                String scaLabel = (String)objArray[5];
                String compositeDN = (String)objArray[6];
                String label = (String)objArray[7];
                String targetNamespace = (String)objArray[8];
                Object creationDate = objArray[9];
                Object undeployDate = objArray[10];
                String organizationalUnitId = (String)objArray[11];
                String activityName = (String)objArray[12];
                String activityLabel = (String)objArray[13];
                String role = (String)objArray[14];
                String systemString01 = (String)objArray[15];
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToInitiatableProcessMetadataSummaryList", (String)("\n processId: " + processId + "\n processName: " + processName + "\n domainName: " + domainName + "\n compositeName: " + compositeName + "\n revision: " + revision + "\n scaLabel: " + scaLabel + "\n compositeDN: " + compositeDN + "\n label: " + label + "\n targetNamespace: " + targetNamespace + "\n creationDate: " + creationDate + "\n undeployDate: " + undeployDate + "\n organizationalUnitId: " + organizationalUnitId + "\n activityName: " + activityName + "\n activityLabel: " + activityLabel + "\n role: " + role + "\n systemString01: " + systemString01));
                }
                ProcessMetadataSummary processMetadataSummary = sProcessMetadataFactory.createProcessMetadataSummary();
                if (processId != null) {
                    processMetadataSummary.setProcessId(String.valueOf(processId));
                }
                processMetadataSummary.setProjectName(compositeName);
                processMetadataSummary.setProcessName(processName);
                processMetadataSummary.setDomainName(domainName);
                processMetadataSummary.setCompositeName(compositeName);
                processMetadataSummary.setRevision(revision);
                processMetadataSummary.setLabel(scaLabel);
                processMetadataSummary.setCompositeDN(compositeDN);
                processMetadataSummary.setTargetNamespace(targetNamespace);
                processMetadataSummary.setStatus(StatusEnum.ACTIVE);
                processMetadataSummary.setOrganizationalUnitId(organizationalUnitId);
                processMetadataSummary.setHasGlobalCreationTasks(Boolean.valueOf(true));
                processMetadataSummary.setGlobalCreationTaskActivityName(activityName);
                processMetadataSummary.setGlobalCreationTaskActivityLabel(activityLabel);
                if (this.isRolePresent(applicationRoles, role)) {
                    try {
                        List taskDisplayInfoTypeList = this.remoteRuntimeConfigServiceBean.getTaskDisplayInfoByTaskDefinitionId((IWorkflowContext)context, systemString01, null);
                        TaskDisplayInfoType humanTaskDisplayInfo = this.getTaskDisplayInfo(taskDisplayInfoTypeList);
                        if (humanTaskDisplayInfo != null) {
                            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToInitiatableProcessMetadataSummaryList", (String)"\n Update Human Task display information");
                            }
                            processMetadataSummary.setTaskDisplayInfo(humanTaskDisplayInfo);
                            processMetadataSummary.setHasSwimlaneRole(Boolean.valueOf(true));
                        }
                    }
                    catch (Exception e) {
                        throw new ProcessMetadataServiceException(Severity.ERRORS, 70808, (Object[])new String[0], (Throwable)e);
                    }
                }
                processMetadataSummaryList.add(processMetadataSummary);
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"convertToInitiatableProcessMetadataSummaryList", (String)"\n list is null or empty");
        }
        return processMetadataSummaryList;
    }

    private void initBeanReferences() throws Exception {
        if (this.context == null) {
            this.context = new InitialContext();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n context: " + this.context));
            }
        }
        if (this.pqs == null) {
            this.pqs = (PersistenceQueryService)this.context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceQueryService");
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n pqs: " + this.pqs));
            }
        }
        if (this.remoteRuntimeConfigServiceBean == null) {
            RuntimeConfigServiceRemoteHome rtcfgServiceRemoteHome = (RuntimeConfigServiceRemoteHome)this.context.lookup("RuntimeConfigService");
            this.remoteRuntimeConfigServiceBean = rtcfgServiceRemoteHome.create();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n remoteRuntimeConfigServiceBean: " + this.remoteRuntimeConfigServiceBean));
            }
        }
    }

    private List select(String jpqlString) throws Exception {
        this.initBeanReferences();
        if (jpqlString == null || jpqlString.length() <= 0) {
            return null;
        }
        return this.pqs.select(jpqlString);
    }

    private void validateContext(IBPMContext context) throws ProcessMetadataServiceException {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        try {
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)context);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 71051, (Object[])new String[0], (Throwable)e);
        }
    }

    private BPMUser lookupUser(IWorkflowContext ctx) throws ProcessMetadataServiceException {
        BPMUser bpmUser = null;
        String userName = ctx.getUser();
        String identityContext = ctx.getIdentityContext();
        bpmUser = this.lookupUser(userName, identityContext);
        return bpmUser;
    }

    private BPMUser lookupUser(String userName, String identityContext) throws ProcessMetadataServiceException {
        try {
            BPMAuthorizationService service = this.getAuthorizationService(identityContext);
            BPMUser bpmUser = service.lookupUser(userName);
            return bpmUser;
        }
        catch (BPMIdentityException e) {
            Object[] errorObjs = new Object[]{userName, "lookupUser"};
            throw new ProcessMetadataServiceException(70687, errorObjs);
        }
    }

    private BPMAuthorizationService getAuthorizationService(String identityContext) {
        BPMAuthorizationService authorizationService = ServiceFactory.getAuthorizationServiceInstance();
        if (identityContext != null) {
            authorizationService = ServiceFactory.getAuthorizationServiceInstance((String)identityContext);
        }
        return authorizationService;
    }

    private boolean isBPMProcessAdmin(IWorkflowContext ctx) throws ProcessMetadataServiceException {
        boolean bpmAdminUserFlag = false;
        if (ctx.getIsAdmin()) {
            bpmAdminUserFlag = true;
        } else {
            BPMAuthorizationService authSvc = this.getAuthorizationService(ctx.getIdentityContext());
            try {
                BPMUser bpmUser = authSvc.lookupUser(ctx.getUser());
                BPMAppRole appRole = authSvc.lookupAppRole(ROLE_BPM_PROCESS_ADMIN, ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
                bpmAdminUserFlag = bpmUser.isInRole((BPMRole)appRole);
            }
            catch (BPMIdentityException e) {
                throw new ProcessMetadataServiceException(70804, (Object[])new String[0]);
            }
        }
        if (bpmAdminUserFlag) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"isBPMProcessAdmin", (String)("\n " + ctx.getUser() + " is an admin"));
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"isBPMProcessAdmin", (String)("\n " + ctx.getUser() + " is not an admin"));
        }
        return bpmAdminUserFlag;
    }

    private List<String> getApplicationRolesForUser(IBPMContext context) throws ProcessMetadataServiceException {
        List appRolesList = null;
        ArrayList<String> applicationRoles = new ArrayList<String>();
        try {
            BPMUser userObj = this.lookupUser((IWorkflowContext)context);
            appRolesList = userObj.getAppRoles(false, ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
        }
        catch (BPMIdentityException e) {
            throw new ProcessMetadataServiceException(70805, (Object[])new String[0]);
        }
        if (appRolesList != null && !appRolesList.isEmpty()) {
            for (int i = 0; i < appRolesList.size(); ++i) {
                Object obj = appRolesList.get(i);
                if (obj instanceof BPMAppRole) {
                    BPMAppRole bpmAppRole = (BPMAppRole)obj;
                    if (bpmAppRole == null) continue;
                    applicationRoles.add(bpmAppRole.getName());
                    continue;
                }
                if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getApplicationRolesForUser", (String)"\n obj is not an instance of BPMAppRole");
            }
        }
        if (applicationRoles.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getApplicationRolesForUser", (String)("\n There are no roles for " + context.getUser()));
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getApplicationRolesForUser", (String)("\n Number of roles " + context.getUser() + " has: " + applicationRoles.size() + "\n Applications roles: " + applicationRoles));
        }
        return applicationRoles;
    }

    private List<String> getOrganizationalUnitsForUser(IBPMContext context) throws ProcessMetadataServiceException {
        List organizationalUnitIdList = null;
        try {
            organizationalUnitIdList = VerificationService.getOrganizationalUnits((IBPMContext)context);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70802, (Object[])new String[0], (Throwable)e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getOrganizationalUnitsForUser", (String)("\n organizationalUnitIdList: " + organizationalUnitIdList));
        }
        return organizationalUnitIdList;
    }

    private String constructProcessQueryString(List<String> applicationRoles, List<String> organizationalUnitIdList, boolean isBPMAdminUser) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId, ");
        buf.append("p.processName, ");
        buf.append("p.domainName, ");
        buf.append("p.compositeName, ");
        buf.append("p.compositeRevision, ");
        buf.append("p.compositeLabel, ");
        buf.append("p.compositeDN, ");
        buf.append("p.label, ");
        buf.append("p.targetNamespace, ");
        buf.append("p.creationDate, ");
        buf.append("p.undeployDate, ");
        buf.append("p.organizationalUnitId, ");
        buf.append("t.activityName, ");
        buf.append("t.activityLabel, ");
        buf.append("t.role, ");
        buf.append("t.systemString01 ");
        buf.append("FROM ");
        buf.append("CubeProcess p, ");
        buf.append("CubeGlobalCreateTask t, ");
        buf.append("CubeRole r ");
        buf.append("WHERE ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append("AND ");
        buf.append("p.hasGlobalCreationTasks ");
        buf.append("= ");
        buf.append("'Y' ");
        buf.append("AND ");
        buf.append("p.status ");
        buf.append("= ");
        buf.append("1 ");
        buf.append("AND ");
        buf.append("p ");
        buf.append("= ");
        buf.append("t.cubeProcess ");
        buf.append("AND ");
        buf.append("p ");
        buf.append("= ");
        buf.append("r.cubeProcess ");
        if (!isBPMAdminUser) {
            int i;
            if (applicationRoles != null && !applicationRoles.isEmpty()) {
                String applicationRole;
                buf.append("AND ");
                buf.append(" ( ");
                buf.append(" ( ");
                buf.append("t.role ");
                buf.append("IN ( ");
                for (i = 0; i < applicationRoles.size(); ++i) {
                    applicationRole = applicationRoles.get(i);
                    if (applicationRole == null) continue;
                    buf.append("'");
                    buf.append(applicationRole);
                    buf.append("'");
                    if (i >= applicationRoles.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(" ) ");
                buf.append("OR ");
                buf.append(" ( ");
                buf.append("r.applicationRoleName ");
                buf.append("IN ( ");
                for (i = 0; i < applicationRoles.size(); ++i) {
                    applicationRole = applicationRoles.get(i);
                    if (applicationRole == null) continue;
                    buf.append("'");
                    buf.append(applicationRole);
                    buf.append("'");
                    if (i >= applicationRoles.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(" ) ");
                buf.append(" ) ");
            }
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        this.logQueryString(buf.toString());
        return buf.toString();
    }

    private String constructProcessQueryString(boolean isBPMAdminUser, String compositeDN, String keyword, String sortAttribute, String sortOrder, List<String> organizationalUnitIdList) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId, ");
        buf.append("p.processName, ");
        buf.append("p.domainName, ");
        buf.append("p.compositeName, ");
        buf.append("p.compositeRevision, ");
        buf.append("p.compositeLabel, ");
        buf.append("p.compositeDN, ");
        buf.append("p.label, ");
        buf.append("p.targetNamespace, ");
        buf.append("p.status, ");
        buf.append("p.creationDate, ");
        buf.append("p.undeployDate, ");
        buf.append("p.organizationalUnitId, ");
        buf.append("p.hasGlobalCreationTasks ");
        buf.append("FROM ");
        buf.append("CubeProcess p ");
        buf.append("WHERE ");
        buf.append("( ");
        buf.append("( ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append(") ");
        if (compositeDN != null && compositeDN.length() > 0 || keyword != null && keyword.length() > 0) {
            buf.append("AND ");
            buf.append("( ");
            if (compositeDN != null && compositeDN.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeDN ");
                buf.append("= ");
                buf.append("'");
                buf.append(compositeDN);
                buf.append("' ");
                buf.append(") ");
                if (keyword != null && keyword.length() > 0) {
                    buf.append("AND ");
                }
            }
            if (keyword != null && keyword.length() > 0) {
                buf.append("( ");
                buf.append("p.processName ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append("OR ");
                buf.append("p.compositeName ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append("OR ");
                buf.append("p.label ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append("OR ");
                buf.append("p.organizationalUnitId ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        if (!isBPMAdminUser) {
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (int i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        buf.append(") ");
        buf.append("ORDER BY ");
        if (sortAttribute != null && sortAttribute.length() > 0) {
            if (sortAttribute.equalsIgnoreCase("processName")) {
                buf.append("p.processName");
            } else if (sortAttribute.equalsIgnoreCase("compositeName")) {
                buf.append("p.compositeName");
            } else if (sortAttribute.equalsIgnoreCase("label")) {
                buf.append("p.label");
            } else if (sortAttribute.equalsIgnoreCase("organizationalUnitId")) {
                buf.append("p.organizationalUnitId");
            } else {
                buf.append("p.processName");
            }
        } else {
            buf.append("p.processName");
        }
        buf.append(" ");
        if (sortOrder != null && sortOrder.length() > 0 && sortOrder.equalsIgnoreCase("DESC")) {
            buf.append("DESC ");
        }
        this.logQueryString(buf.toString());
        return buf.toString();
    }

    private String constructProjectQueryString(boolean isBPMAdminUser, String compositeDN, String projectName, List<String> organizationalUnitIdList) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId, ");
        buf.append("p.processName, ");
        buf.append("p.domainName, ");
        buf.append("p.compositeName, ");
        buf.append("p.compositeRevision, ");
        buf.append("p.compositeLabel, ");
        buf.append("p.compositeDN, ");
        buf.append("p.label, ");
        buf.append("p.targetNamespace, ");
        buf.append("p.status, ");
        buf.append("p.creationDate, ");
        buf.append("p.undeployDate, ");
        buf.append("p.organizationalUnitId, ");
        buf.append("p.hasGlobalCreationTasks ");
        buf.append("FROM ");
        buf.append("CubeProcess p ");
        buf.append("WHERE ");
        buf.append("( ");
        buf.append("( ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append(") ");
        if (compositeDN != null && compositeDN.length() > 0 || projectName != null && projectName.length() > 0) {
            buf.append("AND ");
            buf.append("( ");
            if (compositeDN != null && compositeDN.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeDN ");
                buf.append("= ");
                buf.append("'");
                buf.append(compositeDN);
                buf.append("' ");
                buf.append(") ");
                if (projectName != null && projectName.length() > 0) {
                    buf.append("AND ");
                }
            }
            if (projectName != null && projectName.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeName ");
                buf.append("= ");
                buf.append("'");
                buf.append(projectName);
                buf.append("' ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        if (!isBPMAdminUser) {
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (int i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        buf.append(") ");
        this.logQueryString(buf.toString());
        return buf.toString();
    }

    private String constructProcessQueryString(boolean isBPMAdminUser, String compositeDN, String processName, List<String> organizationalUnitIdList) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId, ");
        buf.append("p.processName, ");
        buf.append("p.domainName, ");
        buf.append("p.compositeName, ");
        buf.append("p.compositeRevision, ");
        buf.append("p.compositeLabel, ");
        buf.append("p.compositeDN, ");
        buf.append("p.label, ");
        buf.append("p.targetNamespace, ");
        buf.append("p.status, ");
        buf.append("p.creationDate, ");
        buf.append("p.undeployDate, ");
        buf.append("p.organizationalUnitId, ");
        buf.append("p.hasGlobalCreationTasks ");
        buf.append("FROM ");
        buf.append("CubeProcess p ");
        buf.append("WHERE ");
        buf.append("( ");
        buf.append("( ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append(") ");
        if (compositeDN != null && compositeDN.length() > 0 || processName != null && processName.length() > 0) {
            buf.append("AND ");
            buf.append("( ");
            if (compositeDN != null && compositeDN.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeDN ");
                buf.append("= ");
                buf.append("'");
                buf.append(compositeDN);
                buf.append("' ");
                buf.append(") ");
                if (processName != null && processName.length() > 0) {
                    buf.append("AND ");
                }
            }
            if (processName != null && processName.length() > 0) {
                buf.append("( ");
                buf.append("p.processName ");
                buf.append("= ");
                buf.append("'");
                buf.append(processName);
                buf.append("' ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        if (!isBPMAdminUser) {
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (int i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        buf.append(") ");
        this.logQueryString(buf.toString());
        return buf.toString();
    }

    private List<ProjectMetadataSummary> getProjectMetadataSummaryList(Map<String, ProjectMetadataSummary> projectMetadataSummaryMap) {
        Set<String> keySet;
        ArrayList<ProjectMetadataSummary> projectMetadataSummaryList = new ArrayList<ProjectMetadataSummary>();
        if (projectMetadataSummaryMap != null && !projectMetadataSummaryMap.isEmpty() && (keySet = projectMetadataSummaryMap.keySet()) != null) {
            for (String compositeDN : keySet) {
                projectMetadataSummaryList.add(projectMetadataSummaryMap.get(compositeDN));
            }
        }
        return projectMetadataSummaryList;
    }

    private boolean isRolePresent(List<String> applicationRoleNamesList, String roleName) {
        boolean flag = false;
        if (applicationRoleNamesList != null && !applicationRoleNamesList.isEmpty() && roleName != null && applicationRoleNamesList.contains(roleName)) {
            flag = true;
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"isRolePresent", (String)("\n flag: " + flag));
        }
        return flag;
    }

    private TaskDisplayInfoType getTaskDisplayInfo(List taskDisplayInfoTypeList) {
        oracle.bpel.services.workflow.runtimeconfig.model.TaskDisplayInfoType taskDisplayInfoType;
        Object obj;
        TaskDisplayInfoType humanTaskDisplayInfoType = null;
        if (taskDisplayInfoTypeList == null || taskDisplayInfoTypeList.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getTaskDisplayInfo", (String)"\n taskDisplayInfoTypeList is null or empty");
            }
            return null;
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getTaskDisplayInfo", (String)("\n taskDisplayInfoTypeList.size(): " + taskDisplayInfoTypeList.size()));
        }
        if ((obj = taskDisplayInfoTypeList.get(0)) instanceof oracle.bpel.services.workflow.runtimeconfig.model.TaskDisplayInfoType && (taskDisplayInfoType = (oracle.bpel.services.workflow.runtimeconfig.model.TaskDisplayInfoType)obj) != null) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getTaskDisplayInfo", (String)("\n taskDisplayInfoType.getApplicationName(): " + taskDisplayInfoType.getApplicationName() + "\n taskDisplayInfoType.getUri(): " + taskDisplayInfoType.getUri() + "\n taskDisplayInfoType.getHostname(): " + taskDisplayInfoType.getHostname() + "\n taskDisplayInfoType.getHttpPort(): " + taskDisplayInfoType.getHttpPort() + "\n taskDisplayInfoType.getHttpsPort(): " + taskDisplayInfoType.getHttpsPort()));
            }
            humanTaskDisplayInfoType = sProcessMetadataFactory.createTaskDisplayInfoType();
            humanTaskDisplayInfoType.setApplicationName(taskDisplayInfoType.getApplicationName());
            humanTaskDisplayInfoType.setUri(taskDisplayInfoType.getUri());
            humanTaskDisplayInfoType.setHostname(taskDisplayInfoType.getHostname());
            humanTaskDisplayInfoType.setHttpPort(taskDisplayInfoType.getHttpPort());
            humanTaskDisplayInfoType.setHttpsPort(taskDisplayInfoType.getHttpsPort());
        }
        return humanTaskDisplayInfoType;
    }

    private void logQueryString(String queryString) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"logQueryString", (String)("\n queryString: " + queryString));
        }
    }
}

