/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.resources.BPMServicesResource;
import oracle.bpm.services.processdashboard.model.ComponentType;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionsType;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.TitleType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.VisualizationType;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public class StandardWidgets {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static WidgetView workloadPerProcessView;
    private static WidgetView workloadPerParticipantView;
    private static WidgetView performancePerProcessView;
    private static WidgetView performancePerProcessByParticipantView;
    private static WidgetType workloadPerProcess;
    private static WidgetType workloadPerProcessByParticipant;
    private static WidgetType performancePerProcess;
    private static WidgetType performancePerProcessByParticipant;

    public static boolean isStandardId(String id) {
        return id != null && (id.equalsIgnoreCase("SWpPro-20090902103700") || id.equalsIgnoreCase("SWpPar-20091229115500") || id.equalsIgnoreCase("SPpPro-20090902103700") || id.equalsIgnoreCase("SPpPar-20091229115500"));
    }

    public static List<WidgetView> getAll(IBPMContext bpmContext) throws BPMException {
        return StandardWidgets.getAll();
    }

    public static List<WidgetView> getAll() throws BPMException {
        ArrayList<WidgetView> widgets = new ArrayList<WidgetView>();
        widgets.add(StandardWidgets.getWorkloadPerProcessWidgetView());
        widgets.add(StandardWidgets.getPerformancePerProcessWidgetView());
        widgets.add(StandardWidgets.getWorkloadPerParticipantWidgetView());
        widgets.add(StandardWidgets.getPerformancePerParticipantWidgetView());
        return widgets;
    }

    public static WidgetView get(@NotNull String widgetId) throws BPMException {
        if (StandardWidgets.isStandardId(widgetId)) {
            for (WidgetView widgetView : StandardWidgets.getAll()) {
                if (!widgetId.equalsIgnoreCase(widgetView.getId())) continue;
                return widgetView;
            }
        }
        return null;
    }

    public static WidgetView getWorkloadPerProcessWidgetView() throws BPMException {
        if (workloadPerProcessView == null) {
            workloadPerProcessView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWpPro-20090902103700", "Workload per Process", workloadPerProcess));
        }
        return workloadPerProcessView;
    }

    public static WidgetView getWorkloadPerParticipantWidgetView() throws BPMException {
        if (workloadPerParticipantView == null) {
            workloadPerParticipantView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWpPar-20091229115500", "Workload per Participant", workloadPerProcessByParticipant));
        }
        return workloadPerParticipantView;
    }

    public static WidgetView getPerformancePerProcessWidgetView() throws BPMException {
        if (performancePerProcessView == null) {
            performancePerProcessView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPpPro-20090902103700", "Performance per Process", performancePerProcess));
        }
        return performancePerProcessView;
    }

    public static WidgetView getPerformancePerParticipantWidgetView() throws BPMException {
        if (performancePerProcessByParticipantView == null) {
            performancePerProcessByParticipantView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPpPar-20091229115500", "Performance per Participant", performancePerProcessByParticipant));
        }
        return performancePerProcessByParticipantView;
    }

    public static WidgetType getWorkloadPerProcessWidget() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"WORKLOAD_PER_PROCESS", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        visualization.getOtherAttributes().put(new QName("y1Title"), "Quantity");
        measurement.setVariable("quantity");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.SUM);
        measurement.setValueType(ValueTypeEnum.VALUE);
        xSeries.setValue("process");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_WORKLOAD);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Workload per Process");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getWorkloadPerParticipantWidget() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"WORKLOAD_PER_PARTICIPANT", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        visualization.getOtherAttributes().put(new QName("y1Title"), "Quantity");
        measurement.setVariable("quantity");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.SUM);
        measurement.setValueType(ValueTypeEnum.VALUE);
        xSeries.setValue("participant");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_WORKLOAD);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Workload per Participant");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getPerformancePerProcess() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"PERFORMANCE_PER_PROCESS", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        measurement.setVariable("taskTime");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        measurement.setValueType(ValueTypeEnum.MINUTES);
        xSeries.setValue("process");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Performance per Process");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getPerformancePerParticipant() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"PERFORMANCE_PER_PARTICIPANT", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        measurement.setVariable("taskTime");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        measurement.setValueType(ValueTypeEnum.MINUTES);
        xSeries.setValue("participant");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_TASK_PERFORMANCE);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Performance per Participant");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    private static UserApplicationDataType getUserApplicationDataType(@NotNull String id, @NotNull String name, @NotNull WidgetType widget) throws BPMException {
        UserApplicationDataType userApplicationDataType = ModelTypeFactory.getUserModelFactory().createUserApplicationDataType();
        userApplicationDataType.setId(id);
        userApplicationDataType.setName(name);
        userApplicationDataType.setApplicationDataType("BAM-WIDGET");
        userApplicationDataType.setData(ModelTypeFactory.getXMLFromWidget((WidgetType)widget));
        return userApplicationDataType;
    }

    static {
        workloadPerProcess = StandardWidgets.getWorkloadPerProcessWidget();
        workloadPerProcessByParticipant = StandardWidgets.getWorkloadPerParticipantWidget();
        performancePerProcess = StandardWidgets.getPerformancePerProcess();
        performancePerProcessByParticipant = StandardWidgets.getPerformancePerParticipant();
    }
}

