/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.common.model.ComponentDNModelUtils;
import oracle.bpm.services.processdashboard.model.Condition;
import oracle.bpm.services.processdashboard.model.JoinOperator;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.Operator;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.ValueType;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.impl.ConditionImpl;
import oracle.bpm.services.processdashboard.model.impl.PredicateImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import org.jetbrains.annotations.NotNull;

public class ProcessDashboardUtils {
    public static WidgetViewImpl validateWidgetView(IBPMContext bpmContext, IProcessMetadataService service, WidgetViewImpl widgetView) throws BPMException {
        return ProcessDashboardUtils.validateWidgetView(widgetView, ProcessDashboardUtils.getProcesses(bpmContext, service));
    }

    public static WidgetViewImpl validateWidgetView(@NotNull WidgetViewImpl widgetView, @NotNull Set<ComponentDNModel> processes) throws BPMException {
        WidgetImpl widget;
        if (widgetView != null && widgetView.hasWidget() && (widget = ProcessDashboardUtils.validateWidget((WidgetImpl)widgetView.getWidget(), processes)) != null) {
            widgetView.setWidget((Widget)widget);
            return widgetView;
        }
        return null;
    }

    public static Widget fixWidget(@NotNull IBPMContext bpmContext, @NotNull IProcessMetadataService service, @NotNull Widget widget) throws BPMException {
        return ProcessDashboardUtils.fixWidget(bpmContext, ProcessDashboardUtils.getProcesses(bpmContext, service), widget);
    }

    public static Widget fixWidget(@NotNull IBPMContext bpmContext, @NotNull Set<ComponentDNModel> processes, @NotNull Widget widget) throws BPMException {
        Widget _widget = widget;
        if (_widget != null && _widget.getData() != null && widget.getData().hasSeries()) {
            _widget = ProcessDashboardUtils.fixMeasurement(widget);
            if (!bpmContext.getIsAdmin()) {
                _widget = ProcessDashboardUtils.addProcessConditions(_widget, processes);
            }
        }
        return _widget;
    }

    public static Set<ComponentDNModel> getProcesses(@NotNull IBPMContext bpmContext, @NotNull IProcessMetadataService service) throws BPMException {
        TreeSet<ComponentDNModel> activeProcesses = new TreeSet<ComponentDNModel>();
        List processes = service.listProcessMetadataSummary(bpmContext, null, null, null);
        for (ProcessMetadataSummary process : processes) {
            if (process.getStatus() != null && process.getStatus() != StatusEnum.ACTIVE && process.getStatus() != StatusEnum.RETIRED) continue;
            ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)process.getDomainName(), (String)process.getCompositeName(), (String)process.getRevision(), (String)process.getLabel(), (String)process.getProcessName());
            activeProcesses.add(componentDN);
        }
        return activeProcesses;
    }

    private static WidgetImpl validateWidget(@NotNull WidgetImpl widget, @NotNull Set<ComponentDNModel> processes) throws BPMException {
        if (widget != null && widget.getData() != null && widget.getData().hasSeries()) {
            ArrayList<Series> validSeries = new ArrayList<Series>();
            for (Series series : widget.getData().getSeries()) {
                if (series.hasProcess() && series.getProcess() != null) {
                    ComponentDNModel seriesProcess = ComponentDNModel.parseConsolidatedComponentDN((String)series.getProcess());
                    ComponentDNModel validProcess = ComponentDNModelUtils.getCurrentProcessLabel((ComponentDNModel)seriesProcess, processes);
                    if (validProcess == null) {
                        validProcess = ComponentDNModelUtils.getAnyVersion((ComponentDNModel)seriesProcess, processes);
                    }
                    if (validProcess == null) continue;
                    series.setProcess(validProcess.getDNString());
                    validSeries.add(series);
                    continue;
                }
                validSeries.add(series);
            }
            if (!validSeries.isEmpty()) {
                widget.getData().clear();
                for (Series _series : validSeries) {
                    widget.getData().addSeries(_series);
                }
                return widget;
            }
        }
        return null;
    }

    private static Widget fixMeasurement(@NotNull Widget widget) throws BPMException {
        if (widget != null && widget.getData() != null && widget.getData().hasSeries()) {
            for (Series series : widget.getData().getSeries()) {
                Measurement measurement;
                String variable;
                boolean fixValueType;
                if (!series.hasMeasurement() || !(fixValueType = (variable = (measurement = series.getMeasurement()).getVariable()) != null && ("avgTimeProcess".equalsIgnoreCase(variable) || "avgTimeTask".equalsIgnoreCase(variable) || "medianTimeProcess".equalsIgnoreCase(variable) || "medianTimeTask".equalsIgnoreCase(variable) || "taskTime".equalsIgnoreCase(variable)))) continue;
                switch (measurement.getValueType()) {
                    case AUTOMATIC_HANDLE_DATE: 
                    case VALUE: {
                        measurement.setValueType(ValueType.MINUTES);
                    }
                }
            }
        }
        return widget;
    }

    private static Widget addProcessConditions(@NotNull Widget widget, @NotNull Set<ComponentDNModel> processes) throws BPMException {
        if (widget != null && widget.getData() != null && widget.getData().hasSeries()) {
            PredicateImpl processPredicate = PredicateImpl.create();
            processPredicate.setJoinOperator(JoinOperator.OR);
            for (ComponentDNModel processDN : processes) {
                ConditionImpl condition = ConditionImpl.create();
                condition.setVariable("process");
                condition.setOperator(Operator.EQUALS);
                condition.setValue((Object)processDN.getDNString());
                processPredicate.addCondition((Condition)condition);
            }
            for (Series series : widget.getData().getSeries()) {
                if (series.hasProcess()) continue;
                PredicateImpl predicate = PredicateImpl.create();
                if (series.hasPredicate()) {
                    predicate.setLeftCondition(series.getPredicate());
                    predicate.setJoinOperator(JoinOperator.AND);
                    predicate.setRightCondition((Predicate)processPredicate);
                } else {
                    predicate = processPredicate;
                }
                series.setPredicate((Predicate)predicate);
            }
        }
        return widget;
    }
}

